<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Yajra\Datatables\Datatables;
use App\Models\Fatura;
use App\Models\Pagamento;

class PagamentoController extends Controller
{
    public function getPagamentos(Request $request){
        $data = $request->only(['dataInicial', 'dataFinal']);
        if($data['dataInicial'] != 'undefined'){
            $dataInicial = $data['dataInicial'];
            $dataFinal   = $data['dataFinal'];
        }else{
            $dataInicial = date("Y-m-01");
            $dataFinal   = date("Y-m-d");
        }
        $cond =  " where data BETWEEN '".$dataInicial."' AND '".$dataFinal."' ";

        $query = "select numero, data, format(pagamento.valor, 2) valor, pagamento.observacao, reftransferencia, datatransferencia, idpagamento from pagamento inner join fatura on pagamento.idfatura=fatura.idfatura ".$cond;

        $pagamento = DB::select($query);
        return DataTables::of($pagamento)
                ->addColumn('action', function ($f) {
                    $editar ='<a href="'.route("fatura.edit",$f->idpagamento).'"class="btn btn-warning btn-sm" title="Editar Pagamento de Fatura"><i class="entypo-pencil"></i> Editar</a> ';          

                    return $editar;
                })->removeColumn('idpagamento')
                ->editColumn("data", function($f) {
                    if($f->data != null){
                        return date("d/m/Y", strtotime($f->data));
                    }				    
			    })->make();
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('faturacao.listapagamentos');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
        $fatura = Fatura::where('idfatura',$id)->first();
        $pago = DB::select("select if(isnull(sum(valor)),0,sum(valor)) valor from pagamento where idfatura =".$id);
        $valorpago =$pago[0]->valor;
        $title = "Pagamento de Fatura de Fornecedor";
        return view('faturacao.frmpagamento', compact('title', 'fatura', 'valorpago'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data                 = $request->all();
        $data['valor']        = str_replace(',','',$data['valor']);
        $data['idutilizador'] = auth()->user()->id;
        $data['datacriacao']  = date("Y-m-d H:i:s");

        if(Pagamento::create($data)) {
            return redirect()
                ->route("faturas")
                ->with("success", "Pagamento Efetuado com Successo!");
        }else{
            return redirect()
                    ->back()
                    ->with("error", "Erro ao Gravar!");
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
