<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use DB;
use Yajra\Datatables\Datatables;
use App\User;

class UsersController extends Controller
{
    public function index()
    {
    	return view('utilizador.lista');
    }

    public function getUtilizadores()
    {
    	$query = "SELECT name,username,email,perfil,id from users";

    	$users = DB::select($query);

        return Datatables::of($users)->addColumn('action', function ($u) {
            return '<a href="'.route('utilizador.edit',$u->id).'" class="btn btn-xs btn-info" title="Editar Utilzador"><i class="entypo-pencil"></i></a> <a href="'.route('utilizador.delete', $u->id).'" class="btn btn-xs btn-danger" title="Apagar"><i class="entypo-trash"></i></a>';
            
        })->removeColumn('id')->make();
    }

    public function create()
    {
    	$title = 'Cadastrar Utilizador';
    	return view('utilizador.frmutilizador', compact('title'));
    }

    public function store(Request $request)
    {
    	$data = $request->all();
        $data["password"] = Hash::make($data['password']);

        if(User::create($data)) {
            return redirect()->route("utilizadores")->with("success", "Utilizador Cadastrado com Successo!");
        } else {
            return redirect()->back()->with("error", "Falha ao Gravar!");
        }
    }


    public function update(Request $request,$id)
    {
    	$data = $request->except(['_token','_method']);

        if(User::where('id',$id)->update($data)) {
            return redirect()->route("utilizadores")->with("success", "Utilizador Actualizado com Successo!");
        } else {
            return redirect()->back()->with("error", "Falha ao Gravar!");
        }
    }

    public function edit($id)
    {
    	$user  = User::find($id);
    	$title = 'Atualizar Dados de Utilizador';
    	return view('Utilizador.frmutilizador',compact('title', 'user'));
    }

    public function senhaUpdateView()
    {
    	$title = 'Atualizar Senha do Utilizador';
    	return view('utilizador.updatesenha', compact('title'));
    }

    public function senhaUpdate(Request $request)
    {
    	$data = $request->only('password');

        $data["password"] = Hash::make($data['password']);

		if(User::where("id", auth()->user()->id)->update($data)) {
            return redirect()->route("utilizador.senhaupdateview")->with("success", "Senha Actualizada com Successo!");
        } else {
            return redirect()->back()->with("error", "Erro ao Actualizar Senha!");
        }
    }

    public function delete($id)
    {
    	$user  = User::find($id);
    	$title = 'Apagar Utilizador';
    	return view('Utilizador.utilizadordelete',compact('title', 'user'));
    }

    public function destroy($id)
    {
        $delete = User::where('id',$id)->delete();
        
        if($delete)
            return redirect()
                            ->route('utilizadores')
                            ->with('success',"Utilizador Apagado com Sucesso!");
        else
            return redirect()
                            ->back()
                            ->with('error', "Erro ao Apagar!");
    }
}
