@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="#"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>
	Gestão de Fundo de Maneio
</li>
<li class="active">
	<strong>Lista de Fundos de Maneio</strong>
</li>
@endsection
@section('content')

<div class="row">	
  <div class="col-md-12">
    @if(auth()->user()->perfil == 'USER')
        <a  href="{{ route('caixa.create') }}" class="btn btn-info"><i class="fa fa-plus-circle"></i> Novo Fundo de Maneio</a><br /><br />
    @endif
  </div>
	<div class="col-md-12">
        @include('layout.alerts')	
        <div class="panel panel-primary" data-collapsed="0">		
            <div class="panel-heading ">
                <div class="panel-title">
                    <strong>Lista de Fundos de Maneio Criados</strong>
                </div>
            </div>			
            <div class="panel-body">								
                <div class="col-md-12 table-responsive">	                            	
                    <table class="table table-responsive table-striped table-bordered _datatable_" id="cheques_table">
                        <thead>
                            <th><p class="_datatable_head"><strong>Mês Referente</strong></p></th>
                            <th><p class="_datatable_head"><strong>Valor do Fundo</strong></p></th>
                            <th><p class="_datatable_head"><strong>Data de Criação</strong></p></th>
                            <th class="noExport"><p class="_datatable_head"><strong>Acção</strong></p></th>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>		
                </div>						
            </div>
        </div>
	
	</div>
</div>
@endsection

@section('js')
<script>
    var table =  $('#cheques_table').DataTable({
        processing: true,
        serverSide: true,
        responsive: true,
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Todos"]],
        search: {
            "case-insensitive": true
        },          
        ajax: '{!! route('getcaixas') !!}',
        columns: [
            { data: 'descricao', name: 'descricao' },
            { data: 'valor', name: 'valor' },
            { data: 'data', name: 'data' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ],
          order: [[2, 'desc']],
        language: {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "Nenhum registo encontrado",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "Sem registros disponíveis",
            "infoFiltered": "(filtrado de _MAX_ registros totais)",    
            "loadingRecords": "Carregando...",
            "processing":     "Processando...",
            "search":         "Pesquisar:",
            "paginate": {
                "first":      "Primeiro",
                "last":       "Último",
                "next":       "Próximo",
                "previous":   "Anterior"
            },
        },    
    });
    
    $("#cheques_table_filter").css("font-size", 15);
    $('#cheques_table').css("font-size", 15);
    table.columns.adjust().draw();
</script>
@endsection