
@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="#"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>
	Faturação
</li>
<li>
	Controlo de Saldos de Faturas
</li>
<li class="active">
	<strong>Pagar Fatura</strong>
</li>
@endsection
@section('content')
<div class="row">			
	<div class="col-md-12">
		<a  href="{{ route('faturas') }}" class="btn btn-info"><i class="entypo-to-start"></i> Voltar</a><br /><br />
	</div>
	<div class="col-md-12">					
        @if(isset($pagamento))
        	<form role="form" class="form-horizontal" method="post" action="{{route('pagamento.update',$pagamento->idpagamento)}}" enctype="multipart/form-data">
          	{!! method_field('put') !!}
        @else
			<form role="form" class="form-horizontal" method="post" action="{{route('pagamento.store')}}" enctype="multipart/form-data">	
		@endif 
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong>{{ $title }}</strong>
				</div>
			</div>			
			<div class="panel-body">				
                {!! csrf_field() !!} 
                <input type="hidden" class="form-control" id="idfatura" name="idfatura"  value="{{ $fatura->idfatura ?? null}}">
                <div class="col-md-6">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group has-info">
                                <label class="control-label col-md-12">Data de Pagamento *</label>
                                <div class="col-md-12">
                                    <input type="date" class="form-control" id="data" name="data" value="{{ $pagamento->data ?? date("Y-m-d") }}" required>
                                </div>
                            </div>	
                        </div>
                        <div class="col-md-6">
                            <div class="form-group has-info">
                                <label class="control-label col-md-12">Valor Pago *</label>
                                <div class="col-md-12">
                                    <input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" id="valor" name="valor" placeholder="valor" value="{{ $pagamento->valor ?? null}}" required>
                                </div>
                            </div>	
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group has-info">
                                <label class="control-label col-md-12">Observação </label>
                                <div class="col-md-12">
                                    <textarea type="text" class="form-control" id="observacao" name="observacao" required> {{ $pagamento->observacao ?? null }} </textarea>
                                </div>
                            </div>	
                        </div>
                        <div class="col-md-6">
                            <div class="form-group has-info">
                                <label class="control-label col-md-12">Refer&ecirc;ncia de Transferência</label>
                                <div class="col-md-12">
                                    <input type="text" class="form-control" id="reftransferencia" name="reftransferencia" placeholder="Ref. Transferência" value="{{ $pagamento->reftransferencia ?? null}}">                               
                                </div>									
                            </div>	
                        </div>
                        <div class="col-md-6">
                            <div class="form-group has-info">
                                <label class="control-label col-md-12">Data de Transferência</label>
                                <div class="col-md-12">
                                    <input type="date" class="form-control" id="datatransferencia" name="datatransferencia" value="{{ $pagamento->datatransferencia ?? null }}">
                                </div>
                            </div>	
                        </div>
                    </div>
                </div>
                <div class="col-md-6">	
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group has-info">
                                <label class="control-label col-md-12">N&ordm; da Fatura </label>
                                <div class="col-md-12">
                                    <input type="text" class="form-control" id="numero" placeholder="Número da Fatura" value="{{ $fatura->numero ?? null}}" readonly>                               
                                </div>									
                            </div>	
                        </div>
                        <div class="col-md-4">
                            <div class="form-group has-info">
                                <label class="control-label col-md-12">Valor da Fatura</label>
                                <div class="col-md-12">
                                    <input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" id="valor" placeholder="valor" value="{{ $fatura->valor ?? null}}" readonly>
                                </div>
                            </div>	
                        </div>
                        <div class="col-md-4">
                            <div class="form-group has-info">
                                <label class="control-label col-md-12">Total Pago</label>
                                <div class="col-md-12">
                                    <input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" id="valor" placeholder="valor" value="{{ $valorpago ?? null}}" readonly>
                                </div>
                            </div>	
                        </div>
                        <div class="col-md-6">
                            <div class="form-group has-info">
                                <label class="control-label col-md-12">Data de Emissão *</label>
                                <div class="col-md-12">
                                    <input type="date" class="form-control" id="dataemissao" value="{{ $fatura->dataemissao ?? null }}" readonly>
                                </div>
                            </div>	
                        </div>
                        <div class="col-md-6">
                            <div class="form-group has-info">
                            <label for="data" class="control-label col-md-12">Data de Vencimento</label>
                                <div class="col-md-12">
                                    <input type="date" class="form-control" id="datavencimento" value="{{ $fatura->datavencimento ?? null }}" readonly>
                                </div>
                            </div>	
                        </div>
                    </div>		
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group has-info">
                                <label class="control-label col-md-12">Descritivo</label>
                                <div class="col-md-12">
                                    <textarea type="text" class="form-control" id="descricao" readonly> {{ $fatura->descricao ?? null }} </textarea>
                                </div>
                            </div>	
                        </div>
                        <div class="col-md-6">
                            <div class="form-group has-info">
                                <label class="control-label col-md-12">Refer&ecirc;ncia de Fornecedor</label>
                                <div class="col-md-12">
                                    <input type="text" class="form-control" id="referenciafornecedor" value="{{ $fatura->referenciafornecedor ?? null}}" readonly>                               
                                </div>									
                            </div>	
                        </div>
                    </div>
                </div>							
			</div>
			<div class="panel-footer">
				<button type="submit" id="gravar" class="btn btn-success">
					<i class="fa fa-save"></i> Gravar
				</button>    
			</div>
			</form>	
		</div>
	
	</div>
</div>
@endsection

@section('js')
@endsection