@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="#"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Faturação</li>
<li class="active">
	<strong>Controlo de Saldos de Faturas</strong>
</li>
@endsection
@section('content')

<div class="row">	
  <div class="col-md-12">
    <a  href="{{ route('fatura.create') }}" class="btn btn-info"><i class="fa fa-plus-circle"></i> Nova Fatura</a><br /><br />
  </div>
	<div class="col-md-12">
        @include('layout.alerts')	
        <div class="panel panel-primary" data-collapsed="0">		
            <div class="panel-heading ">
                <div class="panel-title">
                    <strong>Lista de Faturas Com Saldo</strong>
                </div>
            </div>			
            <div class="panel-body">								
                <div class="col-md-12 table-responsive">	                            	
                    <table class="table table-responsive table-striped table-bordered _datatable_" id="faturas_table">
                        <thead>
                            <th><label class="_datatable_head">Data</label></th>
                            <th><label class="_datatable_head">N&ordm;</label></th>
                            <th><label class="_datatable_head">Descritivo</label></th>
                            <th class="noExport"><label class="_datatable_head">Valor&nbsp;da&nbsp;Fatura</label></th>
                            <th class="noExport"><label class="_datatable_head">Valor&nbsp;Pago</label></th>
                            <th><label class="_datatable_head">Saldo</label></th>
                            <th class="noExport"><label class="_datatable_head">Data&nbsp;Pag.</label></th>
                            <th><label class="_datatable_head">Observação</label></th>
                            <th class="noExport"><label class="_datatable_head">Acções</label></th>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>		
                </div>						
            </div>
        </div>
	
	</div>
</div>
@endsection

@section('js')
<script>
    var table =  $('#faturas_table').DataTable({
        processing: true,
        serverSide: true,
        responsive: true,
        dom: 'lBfrtip',
        pageLength: 50,
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Todos"]],
        search: {
            "case-insensitive": true
        },          
        ajax: {
            url: '{!! route('getfaturas') !!}',
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}',
                dataInicial: function() { return $('#dataInicial').val() },
                dataFinal: function() { return $('#dataFinal').val() },
            }
        },
        columns: [
            { data: 'dataemissao', name: 'dataemissao' },
            { data: 'numero', name: 'numero' },
            { data: 'descricao', name: 'descricao' },
            { data: 'valor', name: 'valor' },
            { data: 'pago', name: 'pago' },
            { data: 'saldo', name: 'saldo' },
            { data: 'data', name: 'data' },
            { data: 'observacao', name: 'observacao' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ],
        buttons: [
            {
                extend: 'excel',
                footer: true,
                title: 'Extrato de Faturas Com Saldos',
                text: '<i class="fa fa-file-excel-o" style="font-size:20px; color: green"></i>',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                }
            },
        //   {
        //     extend: 'pdf',
        //     title: 'Lista de Cheques Emitidos',
        //     text: '<i class="fa fa-file-pdf-o" style="font-size:20px; color: red"></i>',
        //     orientation: 'portrait',
        //     exportOptions: {
        //         columns: "thead th:not(.noExport)"
        //     },
        //   },
            {
            text: '<i class="fa fa-refresh" style="font-size:20px"></i>',
                action: function ( e, dt, node, config ) {
                    dt.ajax.reload();
                }
            }
        ],
        //   order: [[0, 'asc']],
        language: {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "Nenhum registo encontrado",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "Sem registros disponíveis",
            "infoFiltered": "(filtrado de _MAX_ registros totais)",    
            "loadingRecords": "Carregando...",
            "processing":     "Processando...",
            "search":         "Pesquisar:",
            "paginate": {
                "first":      "Primeiro",
                "last":       "Último",
                "next":       "Próximo",
                "previous":   "Anterior"
            }
        }    
    });

    
    control = '<label aria-controls="faturas_table" style="color: black">';
    control += '&nbsp;&nbsp;Data Inicial: <input type="date" class="form-control input-sm" id="dataInicial" name="data"  aria-controls="faturas_table_table" required >';
    control += '</label>';

    control += '<label aria-controls="faturas_table" style="color: black">';
    control += '&nbsp;&nbsp;Data Final: <input type="date" class="form-control input-sm" id="dataFinal" name="data" value="{{ date("Y-m-d") }}" aria-controls="faturas_table" required >';
    control += '</label>';
    
    $("#faturas_table_filter").append(control);

    $('#dataInicial, #dataFinal').change(function() {
        table.draw();
    });
    
    // $("#faturas_table_filter").css("font-size", 15);
    // $('#faturas_table').css("font-size", 15);
    // table.columns.adjust().draw();
</script>
@endsection