@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="#"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>
	Controle de Cheques/Transferências
</li>
<li>
	Lista de Cheques/Transferências
</li>
<li class="active">
	<strong>Novo/a Cheque/Transferência</strong>
</li>
@endsection
@section('content')
<div class="row">	
	<div class="col-md-12">
		<a  href="{{ route('movimentos') }}" class="btn btn-info"><i class="entypo-to-start"></i> Voltar</a><br /><br />
	</div>
	<div class="col-md-12">					
        @if(isset($mov))
        	<form role="form" class="form-horizontal" method="post" action="{{route('movimento.update',$mov->idmovimento)}}" enctype="multipart/form-data">
          	{!! method_field('put') !!}
        @else
			<form role="form" class="form-horizontal" method="post" action="{{route('movimento.store')}}" enctype="multipart/form-data">	
		@endif 
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong>{{ $title }}</strong>
				</div>
			</div>			
			<div class="panel-body">				
				{!! csrf_field() !!} 	
				<div class="row">
					<div class="col-md-6">
						<div class="form-group has-info">
                        <label for="data" class="control-label col-md-12">Data de Cheque/Transferência *</label>
							<div class="col-md-12">
								<input type="date" class="form-control" id="data" name="data" value="{{ $mov->data ?? null }}" required>
							</div>
						</div>	
						<div class="form-group has-info">
							<label class="control-label col-md-12">N&ordm; de Cheque/Transferência</label>
							<div class="col-md-12">
								<input type="text" class="form-control" id="numerocheque" name="numerocheque" placeholder="Número de Cheque ou Transferência" value="{{ $mov->numerocheque ?? null }}">
							</div>
						</div>
						<div class="form-group has-info">
							<label class="control-label col-md-12">Descritivo *</label>
							<div class="col-md-12">
								<textarea type="text" class="form-control" id="descricao" name="descricao"> {{ $mov->descricao ?? null }} </textarea>
							</div>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group has-info">
							<label class="control-label col-md-12">Tipo de Movimento *</label>
							<div class="col-md-12">
								<select class="selectboxit" name="tipomovimento" id="tipomovimento" style="width: 100%;" required>
									<option value="" >Seleccione</option>
									<option value="1" @if(isset($mov->tipomovimento) && $mov->tipomovimento == 1) selected="true" @endif>Entrada</option>
									<option value="2" @if(isset($mov->tipomovimento) && $mov->tipomovimento == 2) selected="true" @endif>Saída</option>
								</select>
							</div>									
						</div>
						<div class="form-group has-info">
							<label class="control-label col-md-12">Valor *</label>
							<div class="col-md-12">
								<input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" id="valor" name="valor" placeholder="valor" required value="{{ $mov->valor ?? null }}">
							</div>
						</div>	
					</div>
				</div>	
							
			</div>
			<div class="panel-footer">
				<button type="submit" id="gravar" class="btn btn-success">
					<i class="fa fa-save"></i> Gravar
				</button>    
			</div>
			</form>	
		</div>
	
	</div>
</div>
@endsection

@section('js')
@endsection