@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="#"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>
	Gestão Fundo de Maneio
</li>
<li>
	Lista de Fundos de Maneio
</li>
<li class="active">
	<strong>Novo Movimento de Fundo de Maneio</strong>
</li>
@endsection
@section('content')
<div class="row">	
	<div class="col-md-12">
		<a  href="{{ route('movimentos.caixa') }}" class="btn btn-info"><i class="entypo-to-start"></i> Voltar</a><br /><br />
	</div>
	<div class="col-md-12">					
        @if(isset($mov))
        	<form role="form" class="form-horizontal" method="post" action="{{route('movimento.update2',$mov->idmovimento)}}" enctype="multipart/form-data">
          	{!! method_field('put') !!}
        @else
			<form role="form" class="form-horizontal" method="post" action="{{route('movimento.store2')}}" enctype="multipart/form-data">	
		@endif 
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong>{{ $title }}</strong>
				</div>
			</div>			
			<div class="panel-body">				
				{!! csrf_field() !!} 	
				<div class="row">
					<div class="col-md-6">
						<div class="form-group has-info">
                        <label for="data" class="control-label col-md-12">Data do Movimento *</label>
							<div class="col-md-12">
								<input type="date" class="form-control" id="data" name="data" value="{{ $mov->data ?? date("Y-m-d") }}" required>
							</div>
						</div>	
						<div class="form-group has-info">
							<label class="control-label col-md-12">Descritivo *</label>
							<div class="col-md-12">
								<textarea type="text" class="form-control" id="descricao" name="descricao"> {{ $mov->descricao ?? null }} </textarea>
							</div>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group has-info">
							<label class="control-label col-md-12">Valor *</label>
							<div class="col-md-12">
								<input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" id="valor" name="valor" placeholder="valor" value="{{ $mov->valor ?? null }}" required>
							</div>
						</div>	
					</div>
				</div>	
							
			</div>
			<div class="panel-footer">
				<button type="submit" id="gravar" class="btn btn-success">
					<i class="fa fa-save"></i> Gravar
				</button>    
			</div>
			</form>	
		</div>
	
	</div>
</div>
@endsection

@section('js')
@endsection