@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="#"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Gestão de Fundo de Maneio</li>
<li class="active">
	<strong>Lista de Fundos de Maneio</strong>
</li>
@endsection
@section('content')

<div class="row">	
  <div class="col-md-12">
    @if(auth()->user()->perfil == 'USER')
        <a  href="{{ route('movimento.create',2) }}" class="btn btn-info"><i class="fa fa-plus-circle"></i> Novo Movimento</a><br /><br />
    @endif
  </div>
	<div class="col-md-12">
        @include('layout.alerts')	
        <div class="panel panel-primary" data-collapsed="0">		
            <div class="panel-heading ">
                <div class="panel-title">
                    <strong>Lista de Movimentos de Fundo de Maneio Emitidos</strong>
                </div>
            </div>			
            <div class="panel-body">								
                <div class="col-md-12 table-responsive">	                            	
                    <table class="table table-responsive table-striped table-bordered _datatable_" id="cheques_table">
                        <thead>
                            <th><label class="_datatable_head">Data do Movimento</label></th>
                            <th style="max-width: 50%"><label class="_datatable_head">Descritivo&nbsp;do&nbsp;Movimento</label></th>
                            <th><label class="_datatable_head">Valor</label></th>
                            <th class="noExport"><label class="_datatable_head">Acção</label></th>
                        </thead>
                        <tbody>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td>
                                    <p class="_datatable_head"><strong> Requisitado:</strong></p>
                                    <p class="_datatable_head"><strong> Gasto:</strong></p>
                                    <p class="_datatable_head"><strong>Saldo&nbsp;Final:</strong></p>
                                </td>
                                <td></td>
                                <td>
                                    <p><strong id="totalR" class="_datatable_head"></strong></p>
                                    <p><strong id="totalG" class="_datatable_head"></strong></p>
                                    <p><strong id="saldo" class="_datatable_head"></strong></p>
                                </td>
                                <td></td>
                            </tr>
                            {{-- <tr>
                                <td>Total Gasto:</td>
                                <td></td>
                                <td><strong id="totalG"></strong></td>
                                <td></td>
                            </tr>
                            <tr>
                                <th>Saldo Final:</th>
                                <th></th>
                                <th><strong id="saldo"></strong></th>
                                <th></th>
                            </tr> --}}
                        </tfoot>
                    </table>		
                </div>						
            </div>
        </div>
	
	</div>
</div>
@endsection

@section('js')
<script>
    var table =  $('#cheques_table').DataTable({
        processing: true,
        serverSide: true,
        responsive: true,
        dom: 'lBfrtip',
        pageLength: 50,
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Todos"]],
        search: {
            "case-insensitive": true
        },          
        ajax: {
            url: '{!! route('getmovimentos') !!}',
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}',
                mes: function() { return $('#mes').val() },
                ano: function() { return $('#ano').val() },
            }
        },
        columns: [
            { data: 'data', name: 'data' },
            { data: 'descricao', name: 'descricao' },
            { data: 'valor', name: 'valor' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ],
        //   order: [[0, 'asc']],
        buttons: [
            // {
            //     extend: 'excel',
            //     footer: true,
            //     title: 'Extrato de Faturas Com Saldos',
            //     text: '<i class="fa fa-file-excel-o" style="font-size:20px; color: green"></i>',
            //     exportOptions: {
            //         columns: "thead th:not(.noExport)"
            //     }
            // },
            {
                extend: 'pdf',
                footer: true,
                title: 'Lista de Movimentos de Fundo de Maneio Emitidos',
                text: '<i class="fa fa-file-pdf-o" style="font-size:20px; color: red"></i>',
                orientation: 'portrait',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                },
            },
            {
            text: '<i class="fa fa-refresh" style="font-size:20px"></i>',
                action: function ( e, dt, node, config ) {
                    dt.ajax.reload();
                }
            }
        ],
        language: {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "Nenhum registo encontrado",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "Sem registros disponíveis",
            "infoFiltered": "(filtrado de _MAX_ registros totais)",    
            "loadingRecords": "Carregando...",
            "processing":     "Processando...",
            "search":         "Pesquisar:",
            "paginate": {
                "first":      "Primeiro",
                "last":       "Último",
                "next":       "Próximo",
                "previous":   "Anterior"
            },
        },    
    });

    control = '<label aria-controls="cheques_table" style="color: black">';
    control += 'Mês: <select class="form-control input-sm" name="mes" id="mes" required>';
    @foreach ($mes as $mes)
        control+= '<option value="{{ $mes->idmes }}"';
         @if( $mes->idmes == date("m") )
             control+= 'selected="true" ';
         @endif
         control+= '>{{ $mes->descricao }}</option>';
    @endforeach
    control += '</select></label>';

    control += '<label aria-controls="cheques_table" style="color: black">';
    control += '&nbsp;Ano do Fundo:<input type="number" class="form-control input-sm" id="ano" name="ano" value="{{ date("Y") }}" aria-controls="cheques_table" required >';
    control += '</label>';
    
    $("#cheques_table_filter").empty().append(control);

    $('#mes, #ano').change(function() {
        table.draw();
    });
    
    $("#cheques_table_filter").css("font-size", 15);
    $('#cheques_table').css("font-size", 15);
    table.columns.adjust().draw();

    $(document).ready(function(){
        geTotais();
        $('#mes').change(function() {
            geTotais();
        });
        $('#ano').change(function() {
            geTotais();
        });
        function geTotais(){
            var mes = $('#mes').val();
            var ano = $('#ano').val();
            var url = "{{ route('gettotaismovimentos', ['_mes_', '_ano_']) }}".replace('_mes_', mes).replace('_ano_', ano);

            $.getJSON(url, function (dados){ 
            //alert(dados);
            if (dados.length > 0){ 
                $.each(dados, function(i, obj){
                    totalreq = new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(obj.totalreq);

                    totalgasto = new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(obj.totalgasto);

                    saldo = new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(obj.saldo);

                    $('#totalR').empty().append(totalreq);
                    $('#totalG').empty().append(totalgasto);
                    $('#saldo').empty().append(saldo);
                }) 
            } 
            })
        }
	});
</script>
@endsection