@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="#"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Utilizadores</li>
<li class="active">
	<strong>Listagens</strong>
</li>
@endsection
@section('content')

<div class="row">	
  <div class="col-md-12">
    <a  href="{{ route('utilizador.create') }}" class="btn btn-info"><i class="fa fa-plus-circle"></i> Novo Utilizador</a><br /><br />
  </div>
	<div class="col-md-12">
		@include('layout.alerts')	
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong>Lista de Utilizadores</strong>
				</div>
			</div>			
			<div class="panel-body">								
				<div class="col-md-12">	
					<table class="table table-striped table-bordered _datatable_" id="clientes_table">
						<thead>
							<th>Nome</th>
              <th>E-mail</th>
              <th>Nome de Utilizador</th>
              <th>Perfil</th>
              <th class="noExport">Acção</th>
						</thead>
						<tbody>
						</tbody>
					</table>		
				</div>						
			</div>
		</div>
	
	</div>
</div>
@endsection

@section('js')
<script>
      $('#clientes_table').DataTable({
          processing: true,
          serverSide: true,
          responsive: true,
          dom: 'lBfrtip',
          search: {
            "case-insensitive": true
          },
          ajax: '{!! route('getutilizadores') !!}',
          columns: [
            { data: 'name', name: 'name' },
            { data: 'email', name: 'email' },
            { data: 'username', name: 'username' },
            { data: 'perfil', name: 'perfil' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
          ],
          order: [[0, 'asc']],
          buttons: [
              {
                extend: 'excel',
                title: 'Lista de Utilzadores',
                text: '<i class="fa fa-file-excel-o" style="font-size:20px; color: green"></i>',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                }
              },
              {
                extend: 'pdf',
                title: 'Lista de Utilzadores',
                text: '<i class="fa fa-file-pdf-o" style="font-size:20px; color: red"></i>',
                orientation: 'landscape',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                },
              },
              {
                text: '<i class="fa fa-refresh" style="font-size:20px"></i>',
                action: function ( e, dt, node, config ) {
                    dt.ajax.reload();
                }
              }
          ],
          language: {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "Nenhum registo encontrado",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "Sem registros disponíveis",
            "infoFiltered": "(filtrado de _MAX_ registros totais)",    
            "loadingRecords": "Carregando...",
            "processing":     "Processando...",
            "search":         "Pesquisar:",
            "paginate": {
              "first":      "Primeiro",
              "last":       "Último",
              "next":       "Próximo",
              "previous":   "Anterior"
            },
          }          
      });
    
    $("#clientes_table_filter").css("font-size", 15);
    $('#clientes_table').css("font-size", 15);
    table.columns.adjust().draw();
</script>
@endsection