<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
// 	$title = 'Dashboard';
//     return view('home', compact('title'));
// })->name('home');

Route::get('/', function () {
    return view('auth/login');
});

Auth::routes();

Route::group(['middleware' => ['auth']], function() {

	Route::get('/home', 'HomeController@index')->name('home');	

	//UTILIZADORES
	Route::get('/utilizadores/', 'UsersController@index')->name('utilizadores');
	Route::get('/utilizador/add', 'UsersController@create')->name('utilizador.create');
	Route::post('/utilizador/store', 'UsersController@store')->name('utilizador.store');
	Route::get('/utilizador/edit/{id}', 'UsersController@edit')->name('utilizador.edit');
	Route::put('/utilizador/update/{id}', 'UsersController@update')->name('utilizador.update');
	Route::get('/utilizador/delete/{id}', 'UsersController@delete')->name('utilizador.delete');
	Route::put('/utilizador/destroy/{id}', 'UsersController@destroy')->name('utilizador.destroy');
	Route::post('/utilizador/senha/update', 'UsersController@senhaUpdate')->name('utilizador.senhaupdate');
	Route::get('/utilizador/senhaupdateview', 'UsersController@senhaUpdateView')->name('utilizador.senhaupdateview');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE UTILIZADORES
	Route::get('/getutilizadores', 'UsersController@getUtilizadores')->name('getutilizadores');

	//METAS
	Route::get('/metas/listagestoressme', 'MetaController@indexSME')->name('metas.listagestoressme');
	Route::get('/metas/listagestoresindividuais', 'MetaController@indexIndividuais')->name('metas.listagestoresindividuais');
	Route::get('/meta/add', 'MetaController@create')->name('meta.create');
	Route::get('/meta/edit/{id}', 'MetaController@edit')->name('meta.edit');
	Route::put('/meta/update/{id}', 'MetaController@update')->name('meta.update');
	// Route::get('/faturasemitidas', 'FaturaController@faturasEmitidas')->name('faturasemitidas');
	// Route::get('/fatura/add', 'FaturaController@create')->name('fatura.create');
	// Route::post('/fatura/store', 'FaturaController@store')->name('fatura.store');
	// Route::get('/fatura/edit/{id}', 'FaturaController@edit')->name('fatura.edit');
	 //REQUISICAO AJAX PARA CARREGAR LISTA DE FATURAS COM SALDOS
	 Route::post('/getgestoressme', 'MetaController@getGestoresIndividuais')->name('getgestoresindividuais');
	 Route::post('/getgestoresindividuais', 'MetaController@getGestoresSME')->name('getgestoressme');
	 Route::post('/getgestores', 'MetaController@getGestoresIndividuais')->name('getgestores');

	//MOVIMENTO DE TESOURARIA
	Route::get('/movimentos', 'MovimentoController@index')->name('movimentos');
	Route::get('/movimento/add/{id}', 'MovimentoController@create')->name('movimento.create');
	Route::get('/movimento/edit/{id}', 'MovimentoController@edit')->name('movimento.edit');
	Route::post('/movimento/store', 'MovimentoController@store')->name('movimento.store');
	Route::put('/movimento/update/{id}', 'MovimentoController@update')->name('movimento.update');
	Route::get('/movimento/edit/caixa/{id}', 'MovimentoController@edit2')->name('movimento.edit2');
	Route::get('/movimentos/caixa', 'MovimentoController@index2')->name('movimentos.caixa');
	Route::post('/movimento/store2', 'MovimentoController@store2')->name('movimento.store2');
	Route::put('/movimento/update2/{id}', 'MovimentoController@update2')->name('movimento.update2');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE CHEQUES EMITIDOS
	Route::post('/getcheques', 'MovimentoController@getCheques')->name('getcheques');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE MOVIMENTOS EMITIDOS
	Route::post('/getmovimentos', 'MovimentoController@getMovimentos')->name('getmovimentos');
	//REQUISICAO AJAX PARA CARREGAR VALORES TOTAIS DE MOVIMENTOS EMITIDOS
	Route::get('/gettotaismovimentos/{mes}/{ano}', 'MovimentoController@getTotaisMovimentos')->name('gettotaismovimentos');

	//CAIXA
	Route::get('/caixas', 'CaixaController@index')->name('caixas');
	Route::get('/caixa/add', 'CaixaController@create')->name('caixa.create');
	Route::post('/caixa/store', 'CaixaController@store')->name('caixa.store');
	Route::get('/caixa/edit/{id}', 'CaixaController@edit')->name('caixa.edit');
	Route::put('/caixa/update/{id}', 'CaixaController@update')->name('caixa.update');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE MOVIMENTOS EMITIDOS
	Route::get('/getcaixas', 'CaixaController@getCaixas')->name('getcaixas');

	//FATURA
	Route::get('/faturas', 'FaturaController@index')->name('faturas');
	Route::get('/faturasemitidas', 'FaturaController@faturasEmitidas')->name('faturasemitidas');
	Route::get('/fatura/add', 'FaturaController@create')->name('fatura.create');
	Route::post('/fatura/store', 'FaturaController@store')->name('fatura.store');
	Route::get('/fatura/edit/{id}', 'FaturaController@edit')->name('fatura.edit');
	Route::put('/fatura/update/{id}', 'FaturaController@update')->name('fatura.update');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE FATURAS COM SALDOS
	Route::post('/getfaturas', 'FaturaController@getFaturas')->name('getfaturas');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE FATURAS EMITIDAS
	Route::post('/getfaturasemitidas', 'FaturaController@getFaturasEmitidas')->name('getfaturasemitidas');

	//FATURA
	Route::get('/pagamentos', 'PagamentoController@index')->name('pagamentos');
	Route::get('/pagamento/add/{id}', 'PagamentoController@create')->name('pagamento.create');
	Route::post('/pagamento/store', 'PagamentoController@store')->name('pagamento.store');
	Route::get('/pagamento/edit/{id}', 'PagamentoController@edit')->name('pagamento.edit');
	Route::put('/pagamento/update/{id}', 'PagamentoController@update')->name('pagamento.update');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE PAGAMENTOS EFETUADOS
	Route::post('/getpagamentos', 'PagamentoController@getPagamentos')->name('getpagamentos');

});
