<?php $__env->startSection('breadcrumb'); ?>
<li>
	<a href="#"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Controle de Cheques/Transferências</li>
<li class="active">
	<strong>Lista de Cheques/Transferências</strong>
</li>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="row">	
  <div class="col-md-12">
    <a  href="<?php echo e(route('movimento.create',1)); ?>" class="btn btn-info"><i class="fa fa-plus-circle"></i> Novo/a Cheque/Transferência</a><br /><br />
  </div>
	<div class="col-md-12">
        <?php echo $__env->make('layout.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>	
        <div class="panel panel-primary" data-collapsed="0">		
            <div class="panel-heading ">
                <div class="panel-title">
                    <strong>Lista de Cheques/Transferências</strong>
                </div>
            </div>			
            <div class="panel-body">								
                <div class="col-md-12 table-responsive">	                            	
                    <table class="table table-responsive table-striped table-bordered _datatable_" id="cheques_table">
                        <thead>
                            <th><label class="_datatable_head">Data</label></th>
                            <th><label class="_datatable_head">N&ordm; Cheque/Transf.</label></th>
                            <th><label class="_datatable_head">Designação</label></th>
                            <th><label class="_datatable_head">Entrada</label></th>
                            <th><label class="_datatable_head">Saída</label></th>
                            <th><label class="_datatable_head">Saldo</label></th>
                            <th class="noExport">Acção</th>
                        </thead>
                        <tbody>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th><label class="_datatable_head">Totais:</label></th>
                                <th colspan="2">&nbsp;</th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>		
                </div>						
            </div>
        </div>
	
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>

    function inicio(i){
        return i;
    }

    function fim(j){
        return j;
    }
    
    var dataI = '<?php echo e(date("01/01/Y")); ?>';
    var dataF = '<?php echo e(date("d/m/Y")); ?>';
    var table =  $('#cheques_table').DataTable({
        processing: true,
        serverSide: true,
        responsive: true,
        dom: 'lBfrtip',
        pageLength: 25,
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Todos"]],
        search: {
        "case-insensitive": true
        },          
        ajax: {
            url: '<?php echo route('getcheques'); ?>',
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                dataInicial: function() { return $('#dataInicial').val() },
                dataFinal: function() { return $('#dataFinal').val() },
            }
        },
        columns: [
        { data: 'data', name: 'data' },
        { data: 'numerocheque', name: 'numerocheque' },
        { data: 'descricao', name: 'descricao' },
        { data: 'entrada', name: 'entrada' },
        { data: 'saida', name: 'saida' },
        { data: 'saldo', name: 'saldo' },
        { data: 'action', name: 'action', orderable: false, searchable: false }
        ],
        aaSorting: [],
    //   order: [[0, 'asc']],
        buttons: [
            // {
            //     extend: 'excel',
            //     orientation: 'landscape',
            //     footer: true,
            //     title: 'Lista de Recebimentos. Período: '+ $('#dataInicial').val() +' á '+dataF,
            //     text: '<i class="fa fa-file-excel-o" style="font-size:20px; color: green"></i>',
            //     exportOptions: {
            //         columns: "thead th:not(.noExport)"
            //     }
            // },
            {
                extend: 'pdf',
                orientation: 'landscape',
                footer: true,
                title: 'Lista de Cheques/Transferências. <?php echo e("Período: "); ?>'+dataI+' á '+dataF,
                text: '<i class="fa fa-file-pdf-o" style="font-size:20px; color: red"></i>',
                orientation: 'portrait',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                },
            },
            {
            text: '<i class="fa fa-refresh" style="font-size:20px"></i>',
                action: function ( e, dt, node, config ) {
                    dt.ajax.reload();
                }
            }
        ],
        language: {
        "lengthMenu": "Mostrar _MENU_ registros por página",
        "zeroRecords": "Nenhum registo encontrado",
        "info": "Mostrando página _PAGE_ de _PAGES_",
        "infoEmpty": "Sem registros disponíveis",
        "infoFiltered": "(filtrado de _MAX_ registros totais)",    
        "loadingRecords": "Carregando...",
        "processing":     "Processando...",
        "search":         "Pesquisar:",
        "paginate": {
            "first":      "Primeiro",
            "last":       "Último",
            "next":       "Próximo",
            "previous":   "Anterior"
        },
        },    
        footerCallback: function (row, data, start, end, display) {
            var api = this.api(), data;
            var intVal = function (i) {
            return typeof i === 'string' ? 
                i.replace(/[\$,]/g, '')*1 : 
                typeof i === 'number' ? 
                    i : 0;
        };

        totalEntrada = api
            .column(3, { page: 'current'})
            .data()
            .reduce(function (a, b) {
                return intVal(a)+intVal(b);
            }, 0);

        totalEntradaF = new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(totalEntrada);

        totalSaida = api
            .column(4, { page: 'current'})
            .data()
            .reduce(function (a, b) {
                return intVal(a)+intVal(b);
            }, 0);

        totalSaidaF = new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(totalSaida);

        totalSaldo = new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(totalEntrada+totalSaida);
        
        // //Totais Todos Registos
        // totalEntradaTodos = api
        //     .column(3)
        //     .data()
        //     .reduce(function (a, b) {
        //        return intVal(a)+intVal(b);
        //     }, 0);

        // totalSaidaTodos = api
        //     .column(4)
        //     .data()
        //     .reduce(function (a, b) {
        //        return intVal(a)+intVal(b);
        //     }, 0);

        $(api.column(3).footer()).html('<label class="_datatable_head">'+totalEntradaF+'</label>');
        $(api.column(4).footer()).html('<label class="_datatable_head">'+totalSaidaF+'</label>');
        $(api.column(5).footer()).html('<label class="_datatable_head">'+totalSaldo+'</label>');
        }     
    });

    control = '<label aria-controls="cheques_table" style="color: black">';
    control += '&nbsp;&nbsp;Data Inicial: <input type="date" class="form-control input-sm" id="dataInicial" name="data" value="<?php echo e(date("Y-01-01")); ?>" aria-controls="cheques_table" required >';
    control += '</label>';

    control += '<label aria-controls="cheques_table" style="color: black">';
    control += '&nbsp;&nbsp;Data Final: <input type="date" class="form-control input-sm" id="dataFinal" name="data" value="<?php echo e(date("Y-m-d")); ?>" aria-controls="cheques_table" required >';
    control += '</label>';
    
    $("#cheques_table_filter").append(control);

    $('#dataInicial, #dataFinal').change(function() {
        // alert('shdssfs');
        dataI = $('#dataInicial').val();
        dataF = $('#dataFinal').val();
        table.draw();
    });
    $("#cheques_table_filter").css("font-size", 15);
    $('#cheques_table').css("font-size", 15);
    table.columns.adjust().draw();
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp73\htdocs\smartechmz\smartesouraria\resources\views/movimento/listacheque.blade.php ENDPATH**/ ?>