<?php $__env->startSection('breadcrumb'); ?>
<li>
	<a href="#"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Gestão de Fundo de Maneio</li>
<li class="active">
	<strong>Lista de Fundos de Maneio</strong>
</li>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="row">	
  <div class="col-md-12">
    <?php if(auth()->user()->perfil == 'USER'): ?>
        <a  href="<?php echo e(route('movimento.create',2)); ?>" class="btn btn-info"><i class="fa fa-plus-circle"></i> Novo Movimento</a><br /><br />
    <?php endif; ?>
  </div>
	<div class="col-md-12">
        <?php echo $__env->make('layout.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>	
        <div class="panel panel-primary" data-collapsed="0">		
            <div class="panel-heading ">
                <div class="panel-title">
                    <strong>Lista de Movimentos de Fundo de Maneio Emitidos</strong>
                </div>
            </div>			
            <div class="panel-body">								
                <div class="col-md-12 table-responsive">	                            	
                    <table class="table table-responsive table-striped table-bordered _datatable_" id="cheques_table">
                        <thead>
                            <th><label class="_datatable_head">Data do Movimento</label></th>
                            <th style="max-width: 50%"><label class="_datatable_head">Descritivo&nbsp;do&nbsp;Movimento</label></th>
                            <th><label class="_datatable_head">Valor</label></th>
                            <th class="noExport"><label class="_datatable_head">Acção</label></th>
                        </thead>
                        <tbody>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td>
                                    <p class="_datatable_head"><strong> Requisitado:</strong></p>
                                    <p class="_datatable_head"><strong> Gasto:</strong></p>
                                    <p class="_datatable_head"><strong>Saldo&nbsp;Final:</strong></p>
                                </td>
                                <td></td>
                                <td>
                                    <p><strong id="totalR" class="_datatable_head"></strong></p>
                                    <p><strong id="totalG" class="_datatable_head"></strong></p>
                                    <p><strong id="saldo" class="_datatable_head"></strong></p>
                                </td>
                                <td></td>
                            </tr>
                            
                        </tfoot>
                    </table>		
                </div>						
            </div>
        </div>
	
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    var table =  $('#cheques_table').DataTable({
        processing: true,
        serverSide: true,
        responsive: true,
        dom: 'lBfrtip',
        pageLength: 50,
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Todos"]],
        search: {
            "case-insensitive": true
        },          
        ajax: {
            url: '<?php echo route('getmovimentos'); ?>',
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                mes: function() { return $('#mes').val() },
                ano: function() { return $('#ano').val() },
            }
        },
        columns: [
            { data: 'data', name: 'data' },
            { data: 'descricao', name: 'descricao' },
            { data: 'valor', name: 'valor' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ],
        //   order: [[0, 'asc']],
        buttons: [
            // {
            //     extend: 'excel',
            //     footer: true,
            //     title: 'Extrato de Faturas Com Saldos',
            //     text: '<i class="fa fa-file-excel-o" style="font-size:20px; color: green"></i>',
            //     exportOptions: {
            //         columns: "thead th:not(.noExport)"
            //     }
            // },
            {
                extend: 'pdf',
                footer: true,
                title: 'Lista de Movimentos de Fundo de Maneio Emitidos',
                text: '<i class="fa fa-file-pdf-o" style="font-size:20px; color: red"></i>',
                orientation: 'portrait',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                },
            },
            {
            text: '<i class="fa fa-refresh" style="font-size:20px"></i>',
                action: function ( e, dt, node, config ) {
                    dt.ajax.reload();
                }
            }
        ],
        language: {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "Nenhum registo encontrado",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "Sem registros disponíveis",
            "infoFiltered": "(filtrado de _MAX_ registros totais)",    
            "loadingRecords": "Carregando...",
            "processing":     "Processando...",
            "search":         "Pesquisar:",
            "paginate": {
                "first":      "Primeiro",
                "last":       "Último",
                "next":       "Próximo",
                "previous":   "Anterior"
            },
        },    
    });

    control = '<label aria-controls="cheques_table" style="color: black">';
    control += 'Mês: <select class="form-control input-sm" name="mes" id="mes" required>';
    <?php $__currentLoopData = $mes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        control+= '<option value="<?php echo e($mes->idmes); ?>"';
         <?php if( $mes->idmes == date("m") ): ?>
             control+= 'selected="true" ';
         <?php endif; ?>
         control+= '><?php echo e($mes->descricao); ?></option>';
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    control += '</select></label>';

    control += '<label aria-controls="cheques_table" style="color: black">';
    control += '&nbsp;Ano do Fundo:<input type="number" class="form-control input-sm" id="ano" name="ano" value="<?php echo e(date("Y")); ?>" aria-controls="cheques_table" required >';
    control += '</label>';
    
    $("#cheques_table_filter").empty().append(control);

    $('#mes, #ano').change(function() {
        table.draw();
    });
    
    $("#cheques_table_filter").css("font-size", 15);
    $('#cheques_table').css("font-size", 15);
    table.columns.adjust().draw();

    $(document).ready(function(){
        geTotais();
        $('#mes').change(function() {
            geTotais();
        });
        $('#ano').change(function() {
            geTotais();
        });
        function geTotais(){
            var mes = $('#mes').val();
            var ano = $('#ano').val();
            var url = "<?php echo e(route('gettotaismovimentos', ['_mes_', '_ano_'])); ?>".replace('_mes_', mes).replace('_ano_', ano);

            $.getJSON(url, function (dados){ 
            //alert(dados);
            if (dados.length > 0){ 
                $.each(dados, function(i, obj){
                    totalreq = new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(obj.totalreq);

                    totalgasto = new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(obj.totalgasto);

                    saldo = new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(obj.saldo);

                    $('#totalR').empty().append(totalreq);
                    $('#totalG').empty().append(totalgasto);
                    $('#saldo').empty().append(saldo);
                }) 
            } 
            })
        }
	});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp73\htdocs\smartechmz\gestaodesempenho\resources\views/movimento/listamovimento.blade.php ENDPATH**/ ?>