<?php $__env->startSection('breadcrumb'); ?>
<li>
	<a href="#"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Gestão de Metas</li>
<li>Gestores Individuais</li>
<li class="active">
	<strong>Lista de Gestores Individuais por Atribuir Metas</strong>
</li>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="row">	
  
	<div class="col-md-12">
        <?php echo $__env->make('layout.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>	
        <div class="panel panel-primary" data-collapsed="0">		
            <div class="panel-heading ">
                <div class="panel-title">
                    <strong>Lista de Gestores Individuais por Atribuir Metas</strong>
                </div>
            </div>			
            <div class="panel-body">								
                <div class="col-md-12 table-responsive">	                            	
                    <table class="table table-responsive table-striped table-bordered _datatable_" id="faturas_table">
                        <thead>
                            <th><label class="_datatable_head">Nome do Gestor</label></th>
                            <th><label class="_datatable_head">Balcão</label></th>
                            <th class="noExport"><label class="_datatable_head">Acções</label></th>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>		
                </div>						
            </div>
        </div>
	
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    var table =  $('#faturas_table').DataTable({
        processing: true,
        serverSide: true,
        responsive: true,
        dom: 'lBfrtip',
        pageLength: 50,
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Todos"]],
        search: {
            "case-insensitive": true
        },          
        ajax: {
            url: '<?php echo route('getgestoresindividuais'); ?>',
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                idbalcao: function() { return $('#idbalcao').val() },
            }
        },
        columns: [
            { data: 'nome', name: 'nome' },
            { data: 'balcao', name: 'balcao' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ],
        buttons: [
            {
                extend: 'excel',
                footer: true,
                title: 'Lista de Gestores Individuais por Atribuir Metas',
                text: '<i class="fa fa-file-excel-o" style="font-size:20px; color: green"></i>',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                }
            },
        //   {
        //     extend: 'pdf',
        //     title: 'Lista de Cheques Emitidos',
        //     text: '<i class="fa fa-file-pdf-o" style="font-size:20px; color: red"></i>',
        //     orientation: 'portrait',
        //     exportOptions: {
        //         columns: "thead th:not(.noExport)"
        //     },
        //   },
            {
            text: '<i class="fa fa-refresh" style="font-size:20px"></i>',
                action: function ( e, dt, node, config ) {
                    dt.ajax.reload();
                }
            }
        ],
        //   order: [[0, 'asc']],
        language: {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "Nenhum registo encontrado",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "Sem registros disponíveis",
            "infoFiltered": "(filtrado de _MAX_ registros totais)",    
            "loadingRecords": "Carregando...",
            "processing":     "Processando...",
            "search":         "Pesquisar:",
            "paginate": {
                "first":      "Primeiro",
                "last":       "Último",
                "next":       "Próximo",
                "previous":   "Anterior"
            }
        }    
    });

    
    control = '<label aria-controls="faturas_table" style="color: black">';
    // control += '&nbsp;&nbsp;Data Inicial: <input type="date" class="form-control input-sm" id="dataInicial" name="data"  aria-controls="faturas_table_table" required >';
    // control += '</label>';

    // control += '<label aria-controls="faturas_table" style="color: black">';
    // control += '&nbsp;&nbsp;Data Final: <input type="date" class="form-control input-sm" id="dataFinal" name="data" value="<?php echo e(date("Y-m-d")); ?>" aria-controls="faturas_table" required >';
    // control += '</label>';
    
    control += '&nbsp;&nbsp;&nbsp;Balcão: <select class="form-control input-sm" name="idbalcao" id="idbalcao">';
    control+= '<option value="undefined">Seleciona</option>';
    <?php $__currentLoopData = $balcoes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $balcao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        control+= '<option value="<?php echo e($balcao->idbalcao); ?>"';
        control+= '><?php echo e($balcao->nome); ?></option>';
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    control += '</select></label>';
    
    $("#faturas_table_filter").append(control);

    $('#idbalcao').change(function() {
        table.draw();
    });
    
    // $("#faturas_table_filter").css("font-size", 15);
    // $('#faturas_table').css("font-size", 15);
    // table.columns.adjust().draw();
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp73\htdocs\smartechmz\gestaodesempenho\resources\views/meta/listagestoresindividuais.blade.php ENDPATH**/ ?>