<?php $__env->startSection('content_header'); ?>
    <h1>Lista de Consultores Individuais</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  <div class="box">
        <?php echo $__env->make('layouts.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="box-header">
      <a class="btn btn-sm btn-success" href="<?php echo e(route('individual.create')); ?>">
        <i class="fa fa-plus-circle"></i> Novo
      </a>
    </div>
    <div class="box-body table-responsive no-padding">
      <div class="content">
        <table class="table table-bordered table-hover" id="individual_table">
          <thead>
              <tr>
                <th style="width: 60px">N&ordm; Processo</th>
                <th style="width: 120px">N&ordm; Certificado</th>
                <th>Nome</th>
                <th>Profissão</th>
                <th>Local de Trabalho</th>
                <th>Telefone</th>
                <th>Área de Consultoria</th>
                <th>NUIT</th>
                <th>Seguro Profissional</th>
                <th class="noExport" style="width: 110px">Acções</th>
              </tr>
          </thead>
        </table>
      </div>
      
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('adminlte_js'); ?>
<script>
      $('#individual_table').DataTable({
          processing: true,
          serverSide: true,
          responsive: true,
          dom: 'lBfrtip',
          search: {
            "case-insensitive": true
          },
          ajax: '<?php echo route('getconsultorind'); ?>',
          columns: [
            { data: 'noprocesso', name: 'noprocesso' },
            { data: 'nocertificado', name: 'nocertificado' },
            { data: 'nome', name: 'nome' },
            { data: 'profissao', name: 'profissao' },
            { data: 'localtrabalho', name: 'localtrabalho' },
            { data: 'telefoneres', name: 'telefoneres' },
            { data: 'areaconsultoria', name: 'areaconsultoria' },
            { data: 'nuit', name: 'nuit' },
            { data: 'seguroprofissional', name: 'seguroprofissional' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
          ],
          buttons: [
              {
                extend: 'excel',
                title: 'Lista de Consultores Individuais',
                text: '<i class="fa fa-file-excel-o" style="font-size:20px; color: green"></i>',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                }
              },
              {
                extend: 'pdf',
                title: 'Lista de Consultores Individuais',
                text: '<i class="fa fa-file-pdf-o" style="font-size:20px; color: red"></i>',
                orientation: 'landscape',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                },
              },
              {
                text: '<i class="fa fa-refresh" style="font-size:20px"></i>',
                action: function ( e, dt, node, config ) {
                    dt.ajax.reload();
                }
              }
          ],
          language: {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "Nenhum registo encontrado",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "Sem registros disponíveis",
            "infoFiltered": "(filtrado de _MAX_ registros totais)",    
            "loadingRecords": "Carregando...",
            "processing":     "Processando...",
            "search":         "Pesquisar:",
            "paginate": {
              "first":      "Primeiro",
              "last":       "Último",
              "next":       "Próximo",
              "previous":   "Anterior"
            },
          }          
      });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp73\htdocs\dinab\resources\views/individual/lista.blade.php ENDPATH**/ ?>