<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Yajra\Datatables\Datatables;
use App\Models\Caixa;
use App\Models\Mes;

class CaixaController extends Controller
{
    public function getCaixas(){
        $query = "SELECT descricao, format(valor,2) valor, data, fechado, idcaixa from caixa inner join mes on idmes=caixa.mes ";
        
        $movs = DB::select($query);
        return DataTables::of($movs)
                ->addColumn('action', function ($f) {
                    $editar ='<a href="'.route("caixa.edit",$f->idcaixa).'"class="btn btn-info btn-sm" title="Editar Fundo de Maneio"><i class="entypo-pencil"></i> Editar</a> ';
                    if($f->fechado == 1){
                        $link = '';
                    }else{
                        if(auth()->user()->perfil == 'USER'){
                            $link = $editar;
                        }else{
                            $link = '';
                        }
                        
                    }
                    
                    return $link;
                })->removeColumn('idcaixa')
                ->removeColumn('fechado')
                ->editColumn("data", function($f) {
				return date("d/m/Y", strtotime($f->data));
			})->make();
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('caixa.listacaixa');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $mes   = Mes::all();
        $title = 'Abrir Novo Fundo de Maneio';
        return view('caixa.frmcaixa', compact('title','mes'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data                 = $request->all();
        $data['valor']        = str_replace(',','',$data['valor']);
        $data['idutilizador'] = auth()->user()->id;
        $data['datacriacao']  = date("Y-m-d H:i:s");

        $caixa = Caixa::where('fechado',0)->first();

        $cx['fechado'] = 1;

        $update = Caixa::where('idcaixa',$caixa->idcaixa)->update($cx);
        if(Caixa::create($data)) {
            return redirect()
                ->route("caixas")
                ->with("success", "Fundo de Maneio Criado com Successo!");
        }else{
            return redirect()
                    ->back()
                    ->with("error", "Erro ao Gravar!");
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $mes   = Mes::all();
        $caixa = Caixa::where('idcaixa', $id)->first();
        $title = 'Editar Fundo de Maneio';
        return view('caixa.frmcaixa', compact('title','mes','caixa'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data                 = $request->except(['_method','_token']);
        $data['valor']        = str_replace(',','',$data['valor']);
        $data['utilizadoratualizacao'] = auth()->user()->id;
        $data['dataatualizacao']  = date("Y-m-d H:i:s");

        $update = Caixa::where('idcaixa', $id)->update($data);

        if($update) {
            return redirect()
                ->route("caixas")
                ->with("success", "Fundo de Maneio Atualizado com Successo!");
        }else{
            return redirect()
                    ->back()
                    ->with("error", "Erro ao Gravar!");
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
