<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Yajra\Datatables\Datatables;
use App\Models\Fatura;

class FaturaController extends Controller
{
    public function getFaturas(Request $request){
        $data = $request->only(['dataInicial', 'dataFinal']);
        if($data['dataInicial'] != 'undefined'){
            $dataInicial = $data['dataInicial'];
            $dataFinal   = $data['dataFinal'];
        }else{
            $dataInicial = '';
            $dataFinal   = date("Y-m-d");
        }
        $cond =  " where dataemissao BETWEEN '".$dataInicial."' AND '".$dataFinal."' ";

        $query = "select fatura.idfatura, dataemissao, numero, descricao, format(fatura.valor,2) valor, format(sum(if(isnull(pagamento.valor),0, pagamento.valor)), 2) pago, format((fatura.valor-sum(if(isnull(pagamento.valor),0, pagamento.valor))), 2) saldo, data, pagamento.observacao from fatura  left join pagamento on fatura.idfatura = pagamento.idfatura ".$cond." group by fatura.idfatura having saldo<>0.0 ";

        $fatura = DB::select($query);
        return DataTables::of($fatura)
                ->addColumn('action', function ($f) {
                    if($f->idfatura != null){
                        if($f->pago == '0.0'){
                            $editar ='<a href="'.route("fatura.edit",$f->idfatura).'"class="btn btn-warning btn-sm" title="Editar Fatura"><i class="entypo-pencil"></i> Editar</a> ';
                        }else{
                            $editar ='';
                        }
                        
                        if($f->saldo <> '0.0' ){
                            $pagar ='<a href="'.route("pagamento.create",$f->idfatura).'"class="btn btn-info btn-sm" title="Pagar Fatura"><i class="fa fa-money"></i> Pagar</a> ';
                           
                        }else{
                           $pagar = ''; 
                        }                        
                    }else{
                        $pagar = '';
                        $editar = '';
                    }          

                    return $pagar.$editar;
                })->removeColumn('idfatura')
                ->editColumn("dataemissao", function($f) {
                    //return date("d/m/Y", strtotime($f->dataemissao));
                    if($f->dataemissao != null){
                        return date("d/m/Y", strtotime($f->dataemissao));
                    }
			    })
                ->editColumn("data", function($f) {
                    if($f->data != null){
                        return date("d/m/Y", strtotime($f->data));
                    }				    
			    })->make();
    }

    public function getFaturasEmitidas(Request $request){
        $data = $request->only(['dataInicial', 'dataFinal']);
        if($data['dataInicial'] != 'undefined'){
            $dataInicial = $data['dataInicial'];
            $dataFinal   = $data['dataFinal'];
        }else{
            $dataInicial = date("Y-m-01");
            $dataFinal   = date("Y-m-d");
        }
        $cond =  " where dataemissao BETWEEN '".$dataInicial."' AND '".$dataFinal."' ";

        $query = "select fatura.idfatura, dataemissao, numero, descricao, format(fatura.valor,2) valor, format(sum(if(isnull(pagamento.valor),0, pagamento.valor)), 2) pago, format((fatura.valor-sum(if(isnull(pagamento.valor),0, pagamento.valor))), 2) saldo, data, pagamento.observacao from fatura  left join pagamento on fatura.idfatura = pagamento.idfatura ".$cond." group by fatura.idfatura ";

        $fatura = DB::select($query);
        return DataTables::of($fatura)
            // ->addColumn('action', function ($f) {
            //     if($f->idfatura != null){
            //         if($f->pago = 0){
            //             $editar ='<a href="'.route("fatura.edit",$f->idfatura).'"class="btn btn-warning btn-xs" title="Editar Fatura"><i class="entypo-pencil"></i></a> ';
            //         }else{
            //             $editar ='';
            //         }
                                            
            //     }else{
            //         $pagar = '';
            //     }          

            //     return $editar;
            // })
            ->removeColumn('idfatura')
            ->editColumn("dataemissao", function($f) {
                //return date("d/m/Y", strtotime($f->dataemissao));
                if($f->dataemissao != null){
                    return date("d/m/Y", strtotime($f->dataemissao));
                }
            })
            ->editColumn("data", function($f) {
                if($f->data != null){
                    return date("d/m/Y", strtotime($f->data));
                }				    
            })->make(); 
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('faturacao.listafaturas');
    }

    public function faturasEmitidas(){
        return view('faturacao.listafaturasemitidas');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = "Nova Fatura de Fornecedor";
        return view('faturacao.frmfatura', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data                 = $request->all();
        $data['valor']        = str_replace(',','',$data['valor']);
        $data['idutilizador'] = auth()->user()->id;
        $data['datacriacao']  = date("Y-m-d H:i:s");

        if(Fatura::create($data)) {
            return redirect()
                ->route("faturas")
                ->with("success", "Fatura Cadastrada com Successo!");
        }else{
            return redirect()
                    ->back()
                    ->with("error", "Erro ao Gravar!");
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
