<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Yajra\Datatables\Datatables;
use App\Models\Gestor;
use App\Models\Balcao;

class GestorController extends Controller
{
    public function indexIndividuais()
    {
        $query = "SELECT * from balcao ";
        
        $balcoes = DB::select($query);
        return view('gestores.listagestoresindividuais', compact('balcoes'));
    }

    public function indexSME()
    {
        $query = "SELECT * from balcao ";
        
        $balcoes = DB::select($query);
        return view('gestores.listagestoressme', compact('balcoes'));
    }

    public function getGestoresIndividuais(Request $request){
        $data = $request->only(['idbalcao']);
        if($data['idbalcao'] != 'undefined'){
            $condition = " and balcao_idbalcao = ".$data['idbalcao'];
        }else{
            $condition = " ";
        }

        $query = "SELECT gestor.nome, balcao.nome as balcao from gestor inner join balcao on balcao_idbalcao=idbalcao where tipogestor='I'  ".$condition;
        
        $gestores = DB::select($query);
        return DataTables::of($gestores)->make();
    }

    public function getGestoresSME(Request $request){
        $data = $request->only(['idbalcao']);
        if($data['idbalcao'] != 'undefined'){
            $condition = " and balcao_idbalcao = ".$data['idbalcao'];
        }else{
            $condition = " ";
        }

        $query = "SELECT gestor.nome, balcao.nome as balcao from gestor inner join balcao on balcao_idbalcao=idbalcao where tipogestor='S'  ".$condition;
        
        $gestores = DB::select($query);
        return DataTables::of($gestores)->make();
    }
}
