<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Yajra\Datatables\Datatables;
use App\Models\Meta;
use App\Models\Produto;
use App\Models\Gestor;
use App\Models\Balcao;
use App\Models\Metagestor;

class MetaController extends Controller
{
    public function indexIndividuais()
    {
        $query = "SELECT * from balcao ";
        
        $balcoes = DB::select($query);
        return view('meta.listagestoresindividuais', compact('balcoes'));
    }

    public function indexSME()
    {
        $query = "SELECT * from balcao ";
        
        $balcoes = DB::select($query);
        return view('meta.listagestoressme', compact('balcoes'));
    }

    public function getGestoresIndividuais(Request $request){
        $data = $request->only(['idbalcao']);
        if($data['idbalcao'] != 'undefined'){
            $condition = " and balcao_idbalcao = ".$data['idbalcao'];
        }else{
            $condition = " ";
        }

        $query = "SELECT gestor.nome, balcao.nome as balcao, idgestor from gestor inner join balcao on balcao_idbalcao=idbalcao where idgestor in (select distinct gestor_idgestor from meta) and tipogestor='I'  ".$condition;
        
        $gestores = DB::select($query);
        return DataTables::of($gestores)
                ->addColumn('action', function ($f) {
                    $editar ='<a href="'.route("meta.edit",$f->idgestor).'"class="btn btn-warning btn-sm" title="Editar Meta"><i class="entypo-pencil"></i> Editar</a> ';
                    $meta =' <a href="'.route("meta.addmeta",$f->idgestor).'"class="btn btn-info btn-sm" title="Atribuir Meta"><i class="fa fa-trophy"></i> Atribuir Meta Alcançada</a> ';
                    if(auth()->user()->perfil == 'ADMIN'){
                        $link = $editar.$meta;
                    }else{
                        $link = '';
                    }
                    
                    return $link;
                })->removeColumn('idgestor')->make();
    }

    public function getGestoresSME(Request $request){
        $data = $request->only(['idbalcao']);
        if($data['idbalcao'] != 'undefined'){
            $condition = " and balcao_idbalcao = ".$data['idbalcao'];
        }else{
            $condition = " ";
        }

        $query = "SELECT gestor.nome, balcao.nome as balcao, idgestor from gestor inner join balcao on balcao_idbalcao=idbalcao where idgestor in (select distinct gestor_idgestor from meta) and tipogestor='S'  ".$condition;
        
        $gestores = DB::select($query);
        return DataTables::of($gestores)
                ->addColumn('action', function ($f) {
                    $editar ='<a href="'.route("meta.edit",$f->idgestor).'"class="btn btn-info btn-sm" title="Editar Meta"><i class="entypo-pencil"></i> Editar</a> ';
                    if(auth()->user()->perfil == 'ADMIN'){
                        $link = $editar;
                    }else{
                        $link = '';
                    }
                    
                    return $link;
                })->removeColumn('idgestor')->make();
    }

    public function addMeta($id){
        
        $gestor   = Gestor::where('idgestor', $id)->first();

        $query = "SELECT meta.*, produto.descricao from meta inner join produto on produto_idproduto = idproduto where gestor_idgestor = ".$id;
        
        $metas = DB::select($query);

        $title = 'Atribuir Meta ao Gestor SME';
        if($gestor->tipogestor == "I"){
            $title = 'Atribuir Meta ao Gestor Individual';
        }

        return view('meta.addmetaalcancada', compact('gestor', 'metas', 'title'));
    }

    public function create()
    {
        $gestor   = Gestor::all();
        return view('meta.createmeta', compact('gestor'));
    }

    public function edit($id)
    {
        $gestor   = Gestor::where('idgestor', $id)->first();
        $produtos = Produto::all();

        $query = "SELECT meta.*, produto.descricao from meta inner join produto on produto_idproduto = idproduto where gestor_idgestor = ".$id;
        
        $metas = DB::select($query);

        $title = 'Editar Meta do Gestor SME';
        if($gestor->tipogestor == "I"){
            $title = 'Editar Meta do Gestor Individual';
        }

        return view('meta.editmeta', compact('gestor', 'metas', 'title'));
    }

    public function saveMeta(Request $request)
    {
        $metas = array();
        $gestor_idgestor = $request->input(['gestor_idgestor']); 
        
        $idmeta          = $request->input(["idmeta"]);
        $meta            = $request->input(["meta"]);
        $vendido         = $request->input(["vendido"]);
        $ano             = $request->input(["ano"]);
        $mes             = $request->input(["mes"]);

        DB::beginTransaction();
        for ($i=0; $i <count($idmeta) ; $i++) {
            $metas[$i] = [
                'meta_idmeta'     => $idmeta[$i],
                'ano'             => $ano,
                'mes'             => $mes,
                'meta'            => str_replace(',','',$meta[$i])+0,
                'vendido'         => str_replace(',','',$vendido[$i])+0,
                'gestor_idgestor' => $gestor_idgestor,
            ];
            $insertMeta = Metagestor::create($metas[$i]);   
        }

        $gestor   = Gestor::where('idgestor', $gestor_idgestor)->first();
        $route = "metas.listagestoressme";
        if($gestor->tipogestor == 'I'){
            $route = "metas.listagestoresindividuais";
        }
        
        if ($insertMeta) {
            DB::commit();
            return redirect()
                    ->route($route)
                    ->with('success',"Metas Atribuidas com Sucesso!");
        }else{
            DB::rollBack();
            return redirect()
                    ->back()
                    ->with('error', 'Erro ao Atribuir Metas!');
        }
    }

    public function update(Request $request, $id)
    {
        $metas = array();
        $gestor_idgestor = $request->input(['gestor_idgestor']); 
        
        $idmeta            = $request->input(["idmeta"]);
        $produto_idproduto = $request->input(["produto_idproduto"]);
        $meta              = $request->input(["meta"]);
        $peso              = $request->input("peso");

        DB::beginTransaction();
        for ($i=0; $i <count($idmeta) ; $i++) {
            $metas[$i] = [
                'idmeta'            => $idmeta[$i],
                'produto_idproduto' => $produto_idproduto[$i],
                'meta'              => str_replace(',','',$meta[$i])+0,
                'peso'              => str_replace(',','',$peso[$i])+0,
                'gestor_idgestor'   => $gestor_idgestor,
            ];
            $insertMeta = Meta::where('idmeta',$idmeta[$i])->update($metas[$i]);   
        }

        $gestor   = Gestor::where('idgestor', $gestor_idgestor)->first();
        $route = "metas.listagestoressme";
        if($gestor->tipogestor == 'I'){
            $route = "metas.listagestoresindividuais";
        }
        
        if ($insertMeta) {
            DB::commit();
            return redirect()
                    ->route($route)
                    ->with('success',"Metas Atualizadas com Sucesso!");
        }else{
            DB::rollBack();
            return redirect()
                    ->back()
                    ->with('error', 'Erro ao Actualizar Metas!');
        }
    }
}
