<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Yajra\Datatables\Datatables;
use App\Models\Movimento;
use App\Models\Conta;
use App\Models\Caixa;
use App\Models\Mes;

class MovimentoController extends Controller
{

    public function getCheques(Request $request){
        $data = $request->only(['dataInicial', 'dataFinal']);
        if($data['dataInicial'] != 'undefined'){
            $dataInicial = $data['dataInicial'];
            $dataFinal   = $data['dataFinal'];
        }else{
            $dataInicial = date("Y-01-01");
            $dataFinal   = date("Y-m-d");
        }
        $cond =  " and movimento.data BETWEEN '".$dataInicial."' AND '".$dataFinal."' ";
        
        $query = "SELECT data, numerocheque,descricao, if(tipomovimento=1, format(valor,2), 0.0) entrada, if(tipomovimento=2, format(valor*(-1),2), 0.0) saida, (select format(sum(if(tipomovimento=1,valor,(valor*(-1)))),2) from movimento m where m.idconta=1 and m.datacriacao<=movimento.datacriacao) saldo, idmovimento from movimento where idconta=1 ".$cond." group by idmovimento";
        
        $cheques = DB::select($query);
        return DataTables::of($cheques)
                ->addColumn('action', function ($f) {
                    $editar ='<a href="'.route("movimento.edit",$f->idmovimento).'"class="btn btn-info btn-sm" title="Editar Movimento de Cheque"><i class="entypo-pencil"></i> Editar</a> ';

                    return $editar;
                })->removeColumn('idmovimento')
                ->editColumn("data", function($f) {
				return date("d/m/Y", strtotime($f->data));
			})->make();
    }

    public function getMovimentos(Request $request){
        $data = $request->only(['mes', 'ano']);
        //dd($data);
        if($data['mes'] != 'undefined'){
            $mes = $data['mes'];
            $ano = $data['ano'];
        }else{
            $mes = date("m");
            $ano = date("Y");
        }

        $query = "SELECT movimento.data, format(movimento.valor,2) valor, descricao, idmovimento from movimento inner join caixa on caixa.idcaixa=movimento.idcaixa where mes=".$mes." and year(caixa.data)=".$ano." ";
        
        $movs = DB::select($query);
        return DataTables::of($movs)
                ->addColumn('action', function ($f) {
                    $editar ='<a href="'.route("movimento.edit2",$f->idmovimento).'"class="btn btn-info btn-sm" title="Editar Movimento de Fundo de Maneio"><i class="entypo-pencil"></i> Editar</a> ';

                    if(auth()->user()->perfil == 'ADMIN'){
                        $editar = '';
                    }
                    return $editar;
                })->removeColumn('idmovimento')
                ->editColumn("data", function($f) {
				return date("d/m/Y", strtotime($f->data));
			})->make();
    }

    public function getTotaisMovimentos($mes, $ano){
        $query = "SELECT caixa.valor totalreq, sum(movimento.valor) totalgasto, caixa.valor-sum(movimento.valor) saldo from movimento inner join caixa on movimento.idcaixa=caixa.idcaixa where mes=".$mes." and year(caixa.data)=".$ano." ";
        
        $movs = DB::select($query);
        return json_encode($movs);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
         return view('movimento.listacheque');
    }

    public function index2()
    {
        $mes   = Mes::all();
         return view('movimento.listamovimento', compact('mes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
        if($id==1){
            $title = 'Emitir Novo/a Cheque/Transferência';
            return view('movimento.frmcheque', compact('title'));
        }else{
            $title = 'Novo Movimento de Fundo de Maneio';
            return view('movimento.frmmovimento', compact('title'));
        }
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $conta                = Conta::get()->first();
        $data                 = $request->all();
        $data['valor']        = str_replace(',','',$data['valor']);
        $data['idutilizador'] = auth()->user()->id;
        $data['idconta']      = $conta->idconta;
        $data['datacriacao']  = date("Y-m-d H:i:s");
        if(Movimento::create($data)) {
            return redirect()
                ->route("movimentos")
                ->with("success", "Cheque/Transferência Cadastrado/a com Successo!");
        }else{
            return redirect()
                    ->back()
                    ->with("error", "Erro ao Gravar!");
        }
    }

    public function store2(Request $request)
    {
        $caixa                = Caixa::where('fechado',0)->get()->first();
        $data                 = $request->all();
        $data['valor']        = str_replace(',','',$data['valor']);
        $data['idutilizador'] = auth()->user()->id;
        $data['idcaixa']      = $caixa->idcaixa;
        $data['datacriacao']  = date("Y-m-d H:i:s");
        
        if(Movimento::create($data)) {
            return redirect()
                ->route("movimentos.caixa")
                ->with("success", "Movimento de Fundo de Maneio Cadastrado com Successo!");
        }else{
            return redirect()
                    ->back()
                    ->with("error", "Erro ao Gravar!");
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $mov   = Movimento::where('idmovimento',$id)->first();
        $title = 'Editar Cheque';
        return view('movimento.frmcheque', compact('title','mov'));
    }

    public function edit2($id)
    {
        $mov   = Movimento::where('idmovimento',$id)->first();
        $title = 'Editar Movimento de Fundo de Maneio';
        return view('movimento.frmmovimento', compact('title','mov'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data                 = $request->except(['_method','_token']);
        $data['valor']        = str_replace(',','',$data['valor']);
        $data['utilizadoratualizacao'] = auth()->user()->id;
        $data['dataatualizacao']  = date("Y-m-d H:i:s");
        if(Movimento::where('idmovimento',$id)->update($data)) {
            return redirect()
                ->route("movimentos")
                ->with("success", "Cheque Atualizado com Successo!");
        }else{
            return redirect()
                    ->back()
                    ->with("error", "Erro ao Gravar!");
        }
    }

    public function update2(Request $request, $id)
    {
        $data                 = $request->except(['_method','_token']);
        $data['valor']        = str_replace(',','',$data['valor']);
        $data['utilizadoratualizacao'] = auth()->user()->id;
        $data['dataatualizacao']  = date("Y-m-d H:i:s");
        
        if(Movimento::where('idmovimento',$id)->update($data)) {
            return redirect()
                ->route("movimentos.caixa")
                ->with("success", "Movimento de Fundo de Maneio Atualizado com Successo!");
        }else{
            return redirect()
                    ->back()
                    ->with("error", "Erro ao Gravar!");
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
