
@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="#"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>
	Gestão de Fundo de Maneio
</li>
<li>
	Lista de Fundos de Maneio
</li>
<li class="active">
	<strong>Novo Fundo de Maneio</strong>
</li>
@endsection
@section('content')
<div class="row">			
	<div class="col-md-12">
		<a  href="{{ route('caixas') }}" class="btn btn-info"><i class="entypo-to-start"></i> Voltar</a><br /><br />
	</div>
	<div class="col-md-12">					
        @if(isset($caixa))
        	<form role="form" class="form-horizontal" method="post" action="{{route('caixa.update',$caixa->idcaixa)}}" enctype="multipart/form-data">
          	{!! method_field('put') !!}
        @else
			<form role="form" class="form-horizontal" method="post" action="{{route('caixa.store')}}" enctype="multipart/form-data">	
		@endif 
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong>{{ $title }}</strong>
				</div>
			</div>			
			<div class="panel-body">				
				{!! csrf_field() !!} 	
				<div class="row">
					<div class="col-md-4">
						<div class="form-group has-info">
							<label class="control-label col-md-12">Mês do Fundo de Maneio *</label>
							<div class="col-md-12">
								<select class="selectboxit" name="mes" id="mes" style="width: 100%;" required>
                                    <option value="" >Seleccione</option>
                                    @foreach ($mes as $mes)
                                        <option value="{{ $mes->idmes }}" @if(isset($caixa->mes) && $caixa->mes == $mes->idmes) selected="true" @endif>{{ $mes->descricao }}</option>
                                    @endforeach
								</select>                                
							</div>									
						</div>	
					</div>
					<div class="col-md-4">
						<div class="form-group has-info">
							<label class="control-label col-md-12">Valor *</label>
							<div class="col-md-12">
                            <input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" id="valor" name="valor" placeholder="valor" value="{{ $caixa->valor ?? null}}" required>
							</div>
						</div>	
					</div>
					<div class="col-md-4">
						<div class="form-group has-info">
                        <label for="data" class="control-label col-md-12">Data *</label>
							<div class="col-md-12">
								<input type="date" class="form-control" id="data" name="data" value="{{ $caixa->data ?? date("Y-m-d") }}" required>
							</div>
						</div>	
					</div>
				</div>	
							
			</div>
			<div class="panel-footer">
				<button type="submit" id="gravar" class="btn btn-success">
					<i class="fa fa-save"></i> Gravar
				</button>    
			</div>
			</form>	
		</div>
	
	</div>
</div>
@endsection

@section('js')
@endsection