
@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="#"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>
	Faturação
</li>
<li>
	Controlo de Saldos de Faturas
</li>
<li class="active">
	<strong>Nova Fatura</strong>
</li>
@endsection
@section('content')
<div class="row">			
	<div class="col-md-12">
		<a  href="{{ route('faturas') }}" class="btn btn-info"><i class="entypo-to-start"></i> Voltar</a><br /><br />
	</div>
	<div class="col-md-12">					
        @if(isset($fatura))
        	<form role="form" class="form-horizontal" method="post" action="{{route('fatura.update',$fatura->idfatura)}}" enctype="multipart/form-data">
          	{!! method_field('put') !!}
        @else
			<form role="form" class="form-horizontal" method="post" action="{{route('fatura.store')}}" enctype="multipart/form-data">	
		@endif 
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong>{{ $title }}</strong>
				</div>
			</div>			
			<div class="panel-body">				
				{!! csrf_field() !!} 	
				<div class="row">
					<div class="col-md-4">
						<div class="form-group has-info">
							<label class="control-label col-md-12">N&ordm; da Fatura *</label>
							<div class="col-md-12">
								<input type="text" class="form-control" id="numero" name="numero" placeholder="Número da Fatura" value="{{ $fatura->numero ?? null}}" required>                               
							</div>									
						</div>	
					</div>
					<div class="col-md-4">
						<div class="form-group has-info">
							<label class="control-label col-md-12">Data de Emissão *</label>
							<div class="col-md-12">
                                <input type="date" class="form-control" id="dataemissao" name="dataemissao" value="{{ $fatura->dataemissao ?? date("Y-m-d") }}" required>
							</div>
						</div>	
					</div>
					<div class="col-md-4">
						<div class="form-group has-info">
                        <label for="data" class="control-label col-md-12">Data de Vencimento</label>
							<div class="col-md-12">
								<input type="date" class="form-control" id="datavencimento" name="datavencimento" value="{{ $fatura->datavencimento ?? date("Y-m-d") }}" required>
							</div>
						</div>	
					</div>
				</div>		
				<div class="row">
					<div class="col-md-4">
						<div class="form-group has-info">
							<label class="control-label col-md-12">Valor *</label>
							<div class="col-md-12">
                                <input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" id="valor" name="valor" placeholder="valor" value="{{ $fatura->valor ?? null}}" required>
							</div>
						</div>	
					</div>
                    <div class="col-md-4">
						<div class="form-group has-info">
							<label class="control-label col-md-12">Descritivo *</label>
							<div class="col-md-12">
								<textarea type="text" class="form-control" id="descricao" name="descricao" required> {{ $fatura->descricao ?? null }} </textarea>
							</div>
						</div>	
					</div>
					<div class="col-md-4">
						<div class="form-group has-info">
							<label class="control-label col-md-12">Refer&ecirc;ncia de Fornecedor</label>
							<div class="col-md-12">
								<input type="text" class="form-control" id="referenciafornecedor" name="referenciafornecedor" placeholder="Ref. Fornecedor" value="{{ $fatura->referenciafornecedor ?? null}}">                               
							</div>									
						</div>	
                    </div>
				</div>							
			</div>
			<div class="panel-footer">
				<button type="submit" id="gravar" class="btn btn-success">
					<i class="fa fa-save"></i> Gravar
				</button>    
			</div>
			</form>	
		</div>
	
	</div>
</div>
@endsection

@section('js')
@endsection