@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="#"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Gestão de Clientes</li>
<li>Gestores SME</li>
<li class="active">
	<strong>Lista de Gestores SME</strong>
</li>
@endsection
@section('content')

<div class="row">	
	<div class="col-md-12">
        @include('layout.alerts')	
        <div class="panel panel-primary" data-collapsed="0">		
            <div class="panel-heading ">
                <div class="panel-title">
                    <strong>Lista de Gestores SME</strong>
                </div>
            </div>			
            <div class="panel-body">								
                <div class="col-md-12 table-responsive">	                            	
                    <table class="table table-responsive table-striped table-bordered _datatable_" id="faturas_table">
                        <thead>
                            <th><label class="_datatable_head">Nome do Gestor</label></th>
                            <th><label class="_datatable_head">Balcão</label></th>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>		
                </div>						
            </div>
        </div>
	
	</div>
</div>
@endsection

@section('js')
<script>
    var table =  $('#faturas_table').DataTable({
        processing: true,
        serverSide: true,
        responsive: true,
        dom: 'lBfrtip',
        pageLength: 50,
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Todos"]],
        search: {
            "case-insensitive": true
        },          
        ajax: {
            url: '{!! route('gestoresgetgestoressme') !!}',
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}',
                idbalcao: function() { return $('#idbalcao').val() },
            }
        },
        columns: [
            { data: 'nome', name: 'nome' },
            { data: 'balcao', name: 'balcao' },
        ],
        buttons: [
            {
                extend: 'excel',
                footer: true,
                title: 'Lista de Gestores SME',
                text: '<i class="fa fa-file-excel-o" style="font-size:20px; color: green"></i>',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                }
            },
            {
            text: '<i class="fa fa-refresh" style="font-size:20px"></i>',
                action: function ( e, dt, node, config ) {
                    dt.ajax.reload();
                }
            }
        ],
        language: {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "Nenhum registo encontrado",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "Sem registros disponíveis",
            "infoFiltered": "(filtrado de _MAX_ registros totais)",    
            "loadingRecords": "Carregando...",
            "processing":     "Processando...",
            "search":         "Pesquisar:",
            "paginate": {
                "first":      "Primeiro",
                "last":       "Último",
                "next":       "Próximo",
                "previous":   "Anterior"
            }
        }    
    });

    
    control = '<label aria-controls="faturas_table" style="color: black">';
    
    control += '&nbsp;&nbsp;&nbsp;Balcão: <select class="form-control input-sm" name="idbalcao" id="idbalcao">';
    control+= '<option value="undefined">Seleciona</option>';
    @foreach ($balcoes as $balcao)
        control+= '<option value="{{ $balcao->idbalcao }}"';
        control+= '>{{ $balcao->nome }}</option>';
    @endforeach
    control += '</select></label>';
    
    $("#faturas_table_filter").append(control);

    $('#idbalcao').change(function() {
        table.draw();
    });
</script>
@endsection