
@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="#"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Gestão de Metas</li>
<li>Gestores Individuais</li>
<li><strong>Lista de Gestores Individuais por Atribuir Metas</strong></li>
<li class="active">
	<strong>Editar Meta</strong>
</li>
@endsection
@section('content')
<div class="row">			
	<div class="col-md-12">
        @if($gestor->tipogestor == 'I')
        	<a  href="{{ route('metas.listagestoresindividuais') }}" class="btn btn-info"><i class="entypo-to-start"></i> Voltar</a>
        @else
			<a  href="{{ route('metas.listagestoressme') }}" class="btn btn-info"><i class="entypo-to-start"></i> Voltar</a>	
		@endif 
		<br /><br />
	</div>
	<div class="col-md-12">	
        @include('layout.alerts')		
        <form role="form" class="form-horizontal" method="post" action="{{route('meta.savemeta')}}" enctype="multipart/form-data">
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong>{{ $title }}</strong>
				</div>
			</div>			
			<div class="panel-body">				
				{!! csrf_field() !!} 	
				<div class="row">
					<div class="col-md-4">
						<div class="form-group has-info">
							<label class="control-label col-md-12">Nome do Gestor</label>
							<div class="col-md-12">
								<select class="selectboxit" name="gestor_idgestor" id="gestor_idgestor" style="width: 100%;" required >
                                        <option value="{{ $gestor->idgestor }}" >{{ $gestor->nome }}</option>
								</select>                               
							</div>								
						</div>	
					</div>
					<div class="col-md-2">
						<div class="form-group has-info">
							<label class="control-label col-md-12">Ano</label>
							<div class="col-md-12">
                                <select class="selectboxit" name="ano" id="ano" style="width: 100%;" required >
                                    <option value="{{ date("Y") }}" >{{ date("Y") }}</option>
                                    <option value="{{ date("Y")-1 }}" >{{ date("Y")-1 }}</option>
								</select>                                
							</div>								
						</div>	
					</div>
					<div class="col-md-2">
						<div class="form-group has-info">
							<label class="control-label col-md-12">Mês</label>
							<div class="col-md-12">
								<select class="selectboxit" name="mes" id="mes" style="width: 100%;" required readonly>
                                        <option value="01" @if(date("m")=="01"){ selected } @endif >Janeiro</option>
                                        <option value="02" @if(date("m")=="02"){ selected } @endif>Fevereiro</option>
                                        <option value="03" @if(date("m")=="03"){ selected } @endif>Março</option>
                                        <option value="04" @if(date("m")=="04"){ selected } @endif>Abril</option>
                                        <option value="05" @if(date("m")=="05"){ selected } @endif>Maio</option>
                                        <option value="06" @if(date("m")=="06"){ selected } @endif>Junho</option>
                                        <option value="07" @if(date("m")=="07"){ selected } @endif>Julho</option>
                                        <option value="08" @if(date("m")=="08"){ selected } @endif >Agosto</option>
                                        <option value="09" @if(date("m")=="09"){ selected } @endif>Setembro</option>
                                        <option value="10" @if(date("m")=="10"){ selected } @endif>Outubro</option>
                                        <option value="11" @if(date("m")=="1"){ selected } @endif>Novembro</option>
                                        <option value="12" @if(date("m")=="12"){ selected } @endif>Dezembro</option>
								</select>                                
							</div>								
						</div>	
					</div>
				</div>	
				<div class="row">
                    <div class="col-md-12 table-responsive">	                            	
                    <table class="table table-responsive table-striped table-bordered _datatable_" >
                        <thead>
                            <th><label class="_datatable_head">Produto</label></th>
                            <th><label class="_datatable_head">Meta Prevista</label></th>
                            <th><label class="_datatable_head">Meta Alcançada</label></th>
                        </thead>
                        <tbody>
                            @foreach ($metas as $meta)
                                <tr>
                                    <td>
                                        <input type="text" class="form-control"  value="{{ $meta->descricao ?? null }}" disabled>
                                        <input type="hidden" class="form-control" name="idmeta[]"  value="{{ $meta->idmeta ?? null }}">
                                        <input type="hidden" class="form-control" name="produto_idproduto[]"  value="{{ $meta->produto_idproduto ?? null }}">
                                    </td>
                                    <td>
                                        <input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" name="meta[]" placeholder="Meta" value="{{ $meta->meta ?? null}}" required readonly>
                                    </td>
                                    <td>
                                        <input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" name="vendido[]" placeholder="Valor da Meta Alcançada" required>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    </div>
                </div>			
			</div>
			<div class="panel-footer">
				<button type="submit" id="gravar" class="btn btn-success">
					<i class="fa fa-save"></i> Gravar
				</button>    
			</div>
			</form>	
		</div>
	
	</div>
</div>
@endsection

@section('js')
@endsection