
@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="#"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Gestão de Metas</li>
<li>Gestores Individuais</li>
<li><strong>Lista de Gestores Individuais por Atribuir Metas</strong></li>
<li class="active">
	<strong>Editar Meta</strong>
</li>
@endsection
@section('content')
<div class="row">			
	<div class="col-md-12">
        @if($gestor->tipogestor == 'I')
        	<a  href="{{ route('metas.listagestoresindividuais') }}" class="btn btn-info"><i class="entypo-to-start"></i> Voltar</a>
        @else
			<a  href="{{ route('metas.listagestoressme') }}" class="btn btn-info"><i class="entypo-to-start"></i> Voltar</a>	
		@endif 
		<br /><br />
	</div>
	<div class="col-md-12">	
        @include('layout.alerts')		
        <form role="form" class="form-horizontal" method="post" action="{{route('meta.update',$gestor->idgestor)}}" enctype="multipart/form-data">
          	{!! method_field('put') !!}
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong>{{ $title }}</strong>
				</div>
			</div>			
			<div class="panel-body">				
				{!! csrf_field() !!} 	
				<div class="row">
					<div class="col-md-4">
						<div class="form-group has-info">
							<label class="control-label col-md-12">Nome do Gestor</label>
							<div class="col-md-12">
								<select class="selectboxit" name="gestor_idgestor" id="gestor_idgestor" style="width: 100%;" required readonly>
                                        <option value="{{ $gestor->idgestor }}" >{{ $gestor->nome }}</option>
								</select>                                
							</div>								
						</div>	
					</div>
				</div>	
				<div class="row">
                    <div class="col-md-12 table-responsive">	                            	
                    <table class="table table-responsive table-striped table-bordered _datatable_" >
                        <thead>
                            <th><label class="_datatable_head">Produto</label></th>
                            <th><label class="_datatable_head">Meta</label></th>
                            <th><label class="_datatable_head">Peso</label></th>
                        </thead>
                        <tbody>
                            @foreach ($metas as $meta)
                                <tr>
                                    <td>
                                        <input type="text" class="form-control"  value="{{ $meta->descricao ?? null }}" disabled>
                                        <input type="hidden" class="form-control" name="idmeta[]"  value="{{ $meta->idmeta ?? null }}">
                                        <input type="hidden" class="form-control" name="produto_idproduto[]"  value="{{ $meta->produto_idproduto ?? null }}">
                                    </td>
                                    <td>
                                        <input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" name="meta[]" placeholder="Meta" value="{{ $meta->meta ?? null}}" required>
                                    </td>
                                    <td>
                                        <input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" name="peso[]" placeholder="Peso" value="{{ $meta->peso ?? null}}" required>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    </div>
                </div>			
			</div>
			<div class="panel-footer">
				<button type="submit" id="gravar" class="btn btn-success">
					<i class="fa fa-save"></i> Gravar
				</button>    
			</div>
			</form>	
		</div>
	
	</div>
</div>
@endsection

@section('js')
@endsection