@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="#"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Produtos</li>
<li class="active">
	<strong>Lista de Produtos</strong>
</li>
@endsection
@section('content')

<div class="row">	
	<div class="col-md-12">
        @include('layout.alerts')	
        <div class="panel panel-primary" data-collapsed="0">		
            <div class="panel-heading ">
                <div class="panel-title">
                    <strong>Lista de Produtos</strong>
                </div>
            </div>			
            <div class="panel-body">								
                <div class="col-md-12 table-responsive">	                            	
                    <table class="table table-responsive table-striped table-bordered _datatable_" id="faturas_table">
                        <thead>
                            <th><label class="_datatable_head">Nome do Produto</label></th>
                            <th><label class="_datatable_head">Unidade de Medida</label></th>
                            <th><label class="_datatable_head">Tipo de Cliente</label></th>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>		
                </div>						
            </div>
        </div>
	
	</div>
</div>
@endsection

@section('js')
<script>
    var table =  $('#faturas_table').DataTable({
        processing: true,
        serverSide: true,
        responsive: true,
        dom: 'lBfrtip',
        pageLength: 50,
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Todos"]],
        search: {
            "case-insensitive": true
        },          
        ajax: {
            url: '{!! route('getprodutos') !!}',
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}',
                tipocliente: function() { return $('#tipocliente').val() },
            }
        },
        columns: [
            { data: 'descricao', name: 'descricao' },
            { data: 'unidademedida', name: 'unidademedida' },
            { data: 'tipocliente', name: 'tipocliente' },
        ],
        buttons: [
            {
                extend: 'excel',
                footer: true,
                title: 'Lista de Produtos',
                text: '<i class="fa fa-file-excel-o" style="font-size:20px; color: green"></i>',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                }
            },
            {
            text: '<i class="fa fa-refresh" style="font-size:20px"></i>',
                action: function ( e, dt, node, config ) {
                    dt.ajax.reload();
                }
            }
        ],
        language: {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "Nenhum registo encontrado",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "Sem registros disponíveis",
            "infoFiltered": "(filtrado de _MAX_ registros totais)",    
            "loadingRecords": "Carregando...",
            "processing":     "Processando...",
            "search":         "Pesquisar:",
            "paginate": {
                "first":      "Primeiro",
                "last":       "Último",
                "next":       "Próximo",
                "previous":   "Anterior"
            }
        }    
    });

    
    control = '<label aria-controls="faturas_table" style="color: black">';
    
    control += '&nbsp;&nbsp;&nbsp;Balcão: <select class="form-control input-sm" name="tipocliente" id="tipocliente">';
    control+= '<option value="undefined">Seleciona</option>';
    control+= '<option value="I">Individuais</option>';
    control+= '<option value="S">SME</option>';
    control+= '<option value="A">Todos</option>';
    control += '</select></label>';
    
    $("#faturas_table_filter").append(control);

    $('#tipocliente').change(function() {
        table.draw();
    });
</script>
@endsection