@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="#"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>
	Utilizadores
</li>
<li class="active">
	<strong>Cadastrar</strong>
</li>
@endsection
@section('content')
<div class="row">	
	<div class="col-md-12">
		<a  href="{{ route('utilizadores') }}" class="btn btn-info"><i class="entypo-to-start"></i> Voltar</a><br /><br />
	</div>
	<div class="col-md-12">					
        @if(isset($user))
        	<form role="form" class="form-horizontal" method="post" action="{{route('utilizador.update',$user->id)}}" enctype="multipart/form-data">
          	{!! method_field('put') !!}
        @else
			<form role="form" class="form-horizontal" method="post" action="{{route('utilizador.store')}}" enctype="multipart/form-data">	
		@endif 
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong>{{ $title }}</strong>
				</div>
			</div>			
			<div class="panel-body">				
				{!! csrf_field() !!} 	
				<div class="row">
					<div class="col-md-6">
						<div class="form-group has-info">
							<label for="name" class="control-label col-md-12">Nome do Utilizador *</label>
							<div class="col-md-12">
								<input type="text" class="form-control" id="name" name="name" placeholder="Nome da Utilizador" value="{{ $user->name ?? null }}" required>
							</div>
						</div>	
						<div class="form-group has-info">
							<label class="control-label col-md-12">E-mail</label>
							<div class="col-md-12">
								<input type="email" class="form-control" id="email" name="email" placeholder="E-mail do Utilizador" value="{{ $user->email ?? null }}">
							</div>
						</div>
						<div class="form-group has-info">
							<label class="control-label col-md-12">Login *</label>
							<div class="col-md-12">
								<input type="text" class="form-control" id="username" name="username" placeholder="Nome de Autenticação" value="{{ $user->username ?? null }}" required>
							</div>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group has-info">
							<label class="control-label col-md-12">Perfil *</label>
							<div class="col-md-12">
								<select class="selectboxit" name="perfil" id="perfil" style="width: 100%;" required>
									<option value="" >Seleccione</option>
									<option value="ADMIN" @if(isset($user->perfil) && $user->perfil == 'ADMIN') selected="true" @endif>Administrador</option>
									<option value="USER" @if(isset($user->perfil) && $user->perfil == 'USER') selected="true" @endif>Utilizador</option>
								</select>
							</div>									
						</div>
						@if(!isset($user))
						<div class="form-group has-info">
							<label class="control-label col-md-12">Senha *</label>
							<div class="col-md-12">
								<input type="password" class="form-control" id="password" name="password" placeholder="Senha do Utilizador" required>
							</div>
						</div>	
						<div class="form-group has-info" id="pwddiv">
							<label class="control-label col-md-12">Repetir Senha *</label>
							<div class="col-md-12">
								<input type="password" class="form-control" id="password2" placeholder="Repetir Senha do Utilizador" required>
							</div>
						</div>
						@endif
					</div>
				</div>	
							
			</div>
			<div class="panel-footer">
				<button type="submit" id="gravar" class="btn btn-success">
					<i class="fa fa-save"></i> Gravar
				</button>    
			</div>
			</form>	
		</div>
	
	</div>
</div>
@endsection

@section('js')
<script>
	$(document).ready(function(){
		$('#password2').change(function(e){
			var pw1=$('#password').val();
			var pw2=$('#password2').val();
			if(pw1!=pw2){
				$('#pwddiv').append("<div id='msgdiv2' style='color:red;' class='col-md-12 text-left'><p>As senhas devem ser iguais!</p></div>");
				$('#password2').val("");
				$('#password').val("");
				$('#msgdiv2').delay(3000).fadeOut('slow');
				return false;
			}
		})
					
	});
</script>
@endsection