<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Yajra\Datatables\Datatables;
use App\Models\DocsEmp;

class DocsEmpController extends Controller
{

    public function __construct(){
         $this->url = (env('APP_DEBUG') == false) ? 'https://jtmc.co.mz/smartechmz/jtmc/storage/app/docsemp/' : 'http://localhost/smartechmz/smarcredito/storage/app/docsemp/';
    }

    //LISTA DE DOCUMENTOS
    public function getDocsemp()
    {
        $query = "select descricao, path, iddocsemp from docsemp order by descricao ";

        $docsemp = DB::select($query);

        return Datatables::of($docsemp)->addColumn('action', function ($u) {
            return '<a href="'.$this->url.$u->path.'" target="_blank" class="btn btn-xs btn-primary" title="Visualizar"><i class="fa fa-eye"></i></a> <a href="'.route("docsemp.delete",$u->iddocsemp).'" class="btn btn-xs btn-danger" title="Apagar"><i class="fa fa-trash"></i></a>';
        })->removeColumn('iddocsemp')->make();
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $url = $this->url;
        $title = 'Lista de Documentos Diversos';
        $docsemp = DocsEmp::orderBy('descricao')->get();
        return view('docsemp.lista', compact('docsemp', 'title', 'url'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'Cadastrar Documentos Diversos';
        return view('docsemp.frmdocsemp',compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data      = $request->except(['image']);

        $nameFile  = null;
         
        // Verifica se informou o arquivo e se é válido
        if ($request->hasFile('image') && $request->file('image')->isValid()) {  
            // if($request->file('image')->getSize() > 15000000){
            //     return redirect()
            //             ->back()
            //             ->with('error', 'Ficheiro demasiado grande! Selecione um ficheiro inferior a 15Mb.')
            //             ->withInput();
            // }
            // Define um aleatório para o arquivo baseado no timestamps atual
            $name = uniqid(date('HisYmd'));     
            // Recupera a extensão do arquivo
            $extension = $request->image->extension();     
            // Define finalmente o nome
            $nameFile = "{$name}.{$extension}";  

            // Faz o upload:
            $upload = $request->image->storeAs('docsemp', $nameFile);

            // Se tiver funcionado o arquivo foi armazenado em storage/app/public/fotos/nameFile.extensao     
            // Verifica se NÃO deu certo o upload (Redireciona de volta)
            if ( !$upload ){
                return redirect()
                        ->back()
                        ->with('error', 'Falha ao fazer upload')
                        ->withInput();
            }else{
                $data['path'] = $nameFile;
                $insert  = DocsEmp::create($data);
                if ($insert) {
                    return redirect()
                              ->route('docsemp')
                              ->with('success',"Dcoumento Gravado com Sucesso!");
                }else{
                    return redirect()
                                ->back()
                                ->with('error', 'Erro ao Gravar!');
                }
                
            }
     
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    public function delete($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
