<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\Models\Emprestimo;
use App\Models\Cliente;
use App\Models\Amort;
use App\Models\Taxajuro;
use App\Models\Taxaservico;
use App\Models\Tipodoc;
use App\Models\Garantia;
use App\Models\Anexo;
use App\Models\Planoamort;
use Yajra\Datatables\Datatables;
use App\Helpers\Helper;

class EmprestimoController extends Controller
{
    public function __construct(){
        $this->url = (env('APP_DEBUG') == false) ? 'https://jtmc.co.mz/smartechmz/jtmc/storage/app/anexos' : 'http://localhost/smartechmz/jtmc/storage/app/anexos/';
    }

    //LISTA DE EMPRESTIMOS
    public function getEmprestimos()
    {
        $query = "select nome, apelido, FORMAT(credito, 2) credito, prestacoes, FORMAT(valorprest, 2) valorprest, taxajuros, amort.descricao, datainicio, idemprestimo from emprestimo inner join cliente on emprestimo.idcliente=cliente.idcliente inner join amort on amort.idamort=emprestimo.idamort order by nome ";

        $emprestimo = DB::select($query);

        return Datatables::of($emprestimo)->addColumn('action', function ($u) {

            $ver = '<a href="'.route('emprestimo.show',$u->idemprestimo).'" class="btn btn-xs btn-primary" title="Visualizar"><i class="fa fa-eye"></i></a> ';

            $editar = '<a href="'.route("emprestimo.edit",$u->idemprestimo).'" class="btn btn-xs btn-warning" title="Editar"><i class="entypo-pencil"></i></a> ';

            $apagar = '<a href="'.route("emprestimo.delete",$u->idemprestimo).'" class="btn btn-xs btn-danger" title="Apagar"><i class="fa fa-trash"></i></a>';

            if(auth()->user()->perfil == 'ADMIN'){
                $link = $ver.$editar.$apagar;
            }else{
                $link = $ver;
            }
            return $link;

        })->removeColumn('idemprestimo')->make();
    }

    //LISTA DE CONTROLO DE EXPEDIÇÃO
    public function getExpedicao()
    {
        $query = "SELECT nome,apelido,deleted,num,valorprestacao, if(isnull(sum(valorpago)),0,valorpago) valorp,idplanoamort,datapagar,(valorprestacao-if(isnull(sum(valorpago)),0,valorpago)) valorpagar,origem from (select nome,apelido,deleted,num,valorprestacao,sum(valor) valorpago,datapagar,planoamort.idplanoamort,origem FROM movimento right join planoamort on movimento.idplanoamort=planoamort.idplanoamort join emprestimo on emprestimo.idemprestimo=planoamort.idemprestimo join cliente on cliente.idcliente=emprestimo.idcliente group by idplanoamort,num,origem having if(isnull(origem),'',origem)<>'JM' )t group by idplanoamort having (valorprestacao-valorp)<>0 and datapagar<=sysdate() and if(isnull(origem),'',origem)<>'JM' and deleted<>1 order by datapagar desc,nome";

        $expedicao = DB::select($query);

        return Datatables::of($expedicao)->addColumn('action', function ($u) {

            //if(auth()->user()->perfil == 'ADMIN'){
                return '<a href="'.route('movimento.create',$u->idplanoamort).'" class="btn btn-xs btn-primary" title="Efectuar Pagamento"><i class="fa fa-money"></i> Pagar</a>';
           // }
            
        })->removeColumn('idplanoamort','deleted','origem')->make();
    }

    public function getJurosMora(){
        $query = "SELECT nome,apelido,num,datapagar,datamov,valorprestacao,valortotal,idmovimento, FORMAT(juros-valorjuros,2) as valorpago,FORMAT(juros,2) juros, FORMAT(valorjuros,2) valorjuros,idplanoamort,prestacoes from (SELECT nome,apelido,num,datapagar,datamov,valorprestacao,valortotal,idmovimento,(0.1/prestacoes*valortotal) juros,  (0.1/prestacoes*valortotal) valorjuros,movimento.idplanoamort,prestacoes FROM emprestimo inner join planoamort on emprestimo.idemprestimo=planoamort.idemprestimo inner join movimento on movimento.idplanoamort=planoamort.idplanoamort inner join cliente on cliente.idcliente=emprestimo.idcliente where (origem='PST' and idamort<>1 and datamov>datapagar and movimento.idplanoamort not in (select distinct idplanoamort from movimento where origem='JM'))union SELECT nome,apelido,num,datapagar,datamov,valorprestacao,valortotal,idmovimento,(0.1/prestacoes*valortotal) juros, ((0.1/prestacoes*valortotal)-(select sum((if(isnull(valor),0,valor))) from movimento where ltrim(rtrim(origem))=('JM') and movimento.idplanoamort=planoamort.idplanoamort)) valorjuros,movimento.idplanoamort,prestacoes FROM emprestimo inner join planoamort on emprestimo.idemprestimo=planoamort.idemprestimo inner join movimento on movimento.idplanoamort=planoamort.idplanoamort inner join cliente on cliente.idcliente=emprestimo.idcliente where (origem='JM' and ((valortotal-(select sum(if(isnull(valor),0,valor)) from movimento where origem='JM' and movimento.idplanoamort=planoamort.idplanoamort))>0)) group by movimento.idplanoamort)t where valorjuros>0 group by idplanoamort order by datapagar desc,nome";
        
        $juros = DB::select($query);

        return Datatables::of($juros)->addColumn('action', function ($u) {

            if(auth()->user()->perfil == 'ADMIN'){
                return '<a href="'.route('movimento.createjuros',$u->idplanoamort).'" class="btn btn-xs btn-primary" title="Efectuar Pagamento de Juros"><i class="fa fa-money"></i> Pagar</a>';
            }
            
        })->removeColumn('idplanoamort','idmovimento','valortotal','prestacoes','valorprestacao')->make();
    }

    public function viewexpedicoes(){
        return view('emprestimo.listaexpedicao');
    }

    public function viewJuros(){
        return view('emprestimo.listajuros');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $title = 'Lista de Créditos';
        return view('emprestimo.lista', compact('title'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $cl          = Cliente::where('deleted','<>','1')->orderBy('nome')->get();
        $amort       = Amort::all();
        $taxaservico = Taxaservico::all();
        $taxajuro    = Taxajuro::orderBy('perc')->get();
        $tipodoc     = Tipodoc::orderBy('descricao')->get();
        $title       = 'Cadastrar Crédito';

        return view('emprestimo.frmemprestimo', compact('title', 'cl', 'taxaservico', 'taxajuro', 'amort', 'tipodoc'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $names  = array();
        $anexos = array();
        $garant = array();
        $planoA = array();
        $data   = $request->except(['valor', 'bem','new','update','idgarantia','tipodoc','path','descricaodoc','new2','update2','idanexo']);

        $bem    = $request->input(["bem"]);
        $valor  = $request->input(["valor"]);
        $count  = 0;
        $count2 = 0;

        $descd  = $request->input(["descricaodoc"]);
        $path   = $request->file("path");

        $data['credito']    = str_replace(',','',$data['credito']);
        $data['valortotal'] = str_replace(',','',$data['valortotal']);
        $data['valorprest'] = str_replace(',','',$data['valorprest']);


        $datapagar = $data['datainicio'];

        //dd($path);
        DB::beginTransaction();

        $insert    = Emprestimo::create($data);
        $insAnexo  = true;
        $insGarant = true;
        $insPlanoA = false;

        if($path!=null){
            foreach ($path as $p) {
                $name          = uniqid(date('HisYmd')).'_'.str_replace(' ','_',$descd[$count]).'.'.$p->extension();
                $p             = $p->storeAs('anexos', $name); 
                $names[$count] = $name;
                $count++;
            }
            if($p){
                for ($i=0; $i <count($descd) ; $i++) {
                    $anexos[$i] = [
                        'descricao'    => $descd[$i],
                        'path'         => $names[$i],
                        'idemprestimo' => $insert->idemprestimo,
                    ];
                    $insAnexo = Anexo::create($anexos[$i]);
                }
            }else{
                return redirect()
                        ->back()
                        ->with('error', 'Erro ao Carregar Anexos! Crédito não Gravado.');
            }            
        }

        if($bem != null){
            for ($i=0; $i <count($bem) ; $i++) {
                $garant[$i] = [
                    'bem'          => $bem[$i],
                    'valor'        => $valor[$i],
                    'idemprestimo' => $insert->idemprestimo,
                ];
                $insGarant = Garantia::create($garant[$i]);
                $count2++;
            }
        }

        for($i=0; $i< $data['prestacoes']; $i++){
            $planoA[$i] = [
                'num'            => $i+1,
                'valorprestacao' => $data['valorprest'],
                'datapagar'      => $datapagar,
                'saldo'          => $data['valortotal']-$data['valorprest']*($i+1),
                'idemprestimo'   => $insert->idemprestimo,
            ];

            $insPlanoA = Planoamort::create($planoA[$i]);

            //INCREMENTO A DATA DO PROXIMO PAGAMENTO DEPENDENDO DO PLANO DE AMORTIZAÇÃO ESCOLHIDO
            if($data['idamort'] == 1){
                $dias        = 1;
                $datapagar = date("Y-m-d", strtotime($datapagar. '+ '.$dias.' days'));
            }
            if($data['idamort'] == 2){
                $dias        = 7;
                $datapagar = date("Y-m-d", strtotime($datapagar. '+ '.$dias.' days'));
            }
            if($data['idamort'] == 3){
                $dias        = 30;
                $datapagar = date("Y-m-d", strtotime($datapagar. '+ '.$dias.' days'));
            }
        }

        if ($insert && $insAnexo && $insGarant) {
            DB::commit();
            return redirect()
                    ->route('emprestimos')
                    ->with('success',"Crédito Gravado com Sucesso! \n".$count." Anexos Carregados. \n".$count2." Garantias Inseridas.");
        }else{
            DB::rollBack();
            return redirect()
                    ->back()
                    ->with('error', 'Erro ao Gravar!');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $query = "select nome, apelido, emprestimo.*, amort.descricao as planoamortizacao from emprestimo inner join cliente on emprestimo.idcliente=cliente.idcliente inner join amort on amort.idamort=emprestimo.idamort where idemprestimo = ".$id." ";

        $emprestimo = DB::select($query);

        $anexos    = Anexo::where('idemprestimo',$id)->orderBy('descricao')->get();
        $garantias = Garantia::where('idemprestimo',$id)->orderBy('bem')->get();
        $url       = $this->url;
        $title     = 'Consultar Crédito';
        return view('emprestimo.emprestimoshow', compact('title', 'emprestimo', 'anexos', 'garantias', 'url'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $emp         = Emprestimo::where('idemprestimo',$id)->first();

        $anexos      = Anexo::where('idemprestimo',$id)->orderBy('descricao')->get();
        $garantias   = Garantia::where('idemprestimo',$id)->orderBy('bem')->get();

        $cl          = Cliente::where('deleted','<>','1')->orderBy('nome')->get();
        $amort       = Amort::all();
        $taxaservico = Taxaservico::all();
        $taxajuro    = Taxajuro::orderBy('perc')->get();
        $tipodoc     = Tipodoc::orderBy('descricao')->get();
        $url         = $this->url;
        $title       = 'Atualizar Crédito';

        return view('emprestimo.frmemprestimo', compact('title', 'emp', 'anexos', 'garantias', 'cl', 'taxaservico', 'taxajuro', 'amort', 'tipodoc', 'url'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $names  = array();
        $anexos = array();
        $garant = array();
        $planoA = array();
        $data   = $request->except(['_token','_method','deleteds','deleteds2','valor', 'bem','valorl', 'beml','new','update','idgarantia','tipodoc','path','descricaodoc','new2','update2','idanexo']);

        $bem        = $request->input(["bem"]);
        $valor      = $request->input(["valor"]);
        $new        = $request->input("new");

        $beml       = $request->input(["beml"]);
        $valorl     = $request->input(["valorl"]);
        $idgarantia = $request->input(["idgarantia"]);
        $update     = $request->input("update");
        $deleteds   = $request->input("deleteds");
        $count      = 0;
        $count2     = 0;

        $descd     = $request->input(["descricaodoc"]);
        $path      = $request->file("path");
        $idanexo   = $request->input(["idanexo"]);
        $new2      = $request->input("new2");
        $deleteds2 = $request->input("deleteds2");
        $update2   = $request->input("update2");

        $data['credito']    = str_replace(',','',$data['credito']);
        $data['valortotal'] = str_replace(',','',$data['valortotal']);
        $data['valorprest'] = str_replace(',','',$data['valorprest']);


        $datapagar = $data['datainicio'];

        //dd($path);
        DB::beginTransaction();

        $insert    = Emprestimo::where('idemprestimo',$id)->update($data);

        $delPlano = Planoamort::where('idemprestimo',$id)->delete();

        for($i=0; $i< $data['prestacoes']; $i++){
            $planoA[$i] = [
                'num'            => $i+1,
                'valorprestacao' => $data['valorprest'],
                'datapagar'      => $datapagar,
                'saldo'          => $data['valortotal']-$data['valorprest']*($i+1),
                'idemprestimo'   => $id,
            ];

            $insPlanoA = Planoamort::create($planoA[$i]);

            //INCREMENTO A DATA DO PROXIMO PAGAMENTO DEPENDENDO DO PLANO DE AMORTIZAÇÃO ESCOLHIDO
            if($data['idamort'] == 1){
                $dias        = 1;
                $datapagar = date("Y-m-d", strtotime($datapagar. '+ '.$dias.' days'));
            }
            if($data['idamort'] == 2){
                $dias        = 7;
                $datapagar = date("Y-m-d", strtotime($datapagar. '+ '.$dias.' days'));
            }
            if($data['idamort'] == 3){
                $dias        = 30;
                $datapagar = date("Y-m-d", strtotime($datapagar. '+ '.$dias.' days'));
            }
        }

        $insAnexo  = 1;
        $insGarant = 1;
        $insPlanoA = 1;
        $updGarant = 1;
        $delGarant = 1;
        $delAnexo  = 1;

        if($bem != null){
            for ($i=0; $i <count($bem) ; $i++) {
                $garant[$i] = [
                    'bem'          => $bem[$i],
                    'valor'        => $valor[$i],
                    'idemprestimo' => $id,
                ];
                if($new[$i] == true){
                    $insGarant = Garantia::create($garant[$i]);
                }               
                
                $count2++;
            }
        }

        if($beml != null){
            for ($i=0; $i <count($beml) ; $i++) {
                $garantl[$i] = [
                    'bem'          => $beml[$i],
                    'valor'        => $valorl[$i],
                    'idemprestimo' => $id,
                ];
                $upGarant = Garantia::where('idgarantia',$idgarantia[$i])->update($garantl[$i]);                                
                $count2++;
            }
        }
        //TRATANDO DOS DELETED
        if($deleteds>0){    
            //CICLO PARA APURAR GARANTIAS        
            foreach ($deleteds as $d) {
                $delGarant = Garantia::where('idgarantia',$d)->delete();
            }             
        }

        if($path!=null){
            foreach ($path as $p) {
                $name          = uniqid(date('HisYmd')).'_'.str_replace(' ','_',$descd[$count]).'.'.$p->extension();
                $p             = $p->storeAs('anexos', $name); 
                $names[$count] = $name;
                $count++;
            }
            if($p){
                for ($i=0; $i <count($descd) ; $i++) {
                    $anexos[$i] = [
                        'descricao'    => $descd[$i],
                        'path'         => $names[$i],
                        'idemprestimo' => $id,
                    ];
                    $insAnexo = Anexo::create($anexos[$i]);
                }
            }else{
                return redirect()
                        ->back()
                        ->with('error', 'Erro ao Carregar Anexos! Crédito não Gravado.');
            }            
        }

        //TRATANDO DOS DELETED ANEXOS
        if($deleteds2 > 0){    
            //CICLO PARA APURAR ANEXOS        
            foreach ($deleteds2 as $d2) {
                $delAnexo = Anexo::where('idanexo',$d2)->delete();
            }             
        }

        if ($insert && $insGarant && $delGarant && $insAnexo && $delAnexo) {
            DB::commit();
            return redirect()
                    ->route('emprestimos')
                    ->with('success',"Crédito Atualizado com Sucesso!");
        }else{
            DB::rollBack();
            return redirect()
                    ->back()
                    ->with('error', 'Erro ao Gravar!');
        }
    }

    public function delete($id){  

        $query       = "select * from movimento where idplanoamort in (select idplanoamort from planoamort where idemprestimo = ".$id.") ";

        $emprestimo = DB::select($query);
        if(count($emprestimo)>0){
            return redirect()
                    ->route('emprestimo.show', $id)
                    ->with('error',"Este Crédito já tem pagamentos, não pode ser apagado!");
        }else{
            $delete    = true;
            $query = "select nome, apelido, emprestimo.*, amort.descricao as planoamortizacao from emprestimo inner join cliente on emprestimo.idcliente=cliente.idcliente inner join amort on amort.idamort=emprestimo.idamort where idemprestimo = ".$id." ";

            $emprestimo = DB::select($query);

            $anexos    = Anexo::where('idemprestimo',$id)->orderBy('descricao')->get();
            $garantias = Garantia::where('idemprestimo',$id)->orderBy('bem')->get();
            $url       = $this->url;
            $title     = 'Consultar Crédito';
            return view('emprestimo.emprestimoshow', compact('title', 'emprestimo', 'anexos', 'garantias', 'url', 'delete'));
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete = Emprestimo::where('idemprestimo',$id)->delete();
        
        if($delete)
            return redirect()
                            ->route('emprestimos')
                            ->with('success',"Crédito Apagado com Sucesso!");
        else
            return redirect()
                            ->route('emprestimos',$id)
                            ->with('error', "Erro ao Apagar!");
    }
}
