<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Yajra\Datatables\Datatables;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function getCreditos(){
        $query = "SELECT nome,apelido,deleted,num,valorprestacao, if(isnull(sum(valorpago)),0,valorpago) valorp,idplanoamort,datapagar,(valorprestacao-if(isnull(sum(valorpago)),0,valorpago)) valorpagar,origem from (select nome,apelido,deleted,num,valorprestacao,sum(valor) valorpago,datapagar,planoamort.idplanoamort,origem FROM movimento right join planoamort on movimento.idplanoamort=planoamort.idplanoamort join emprestimo on emprestimo.idemprestimo=planoamort.idemprestimo join cliente on cliente.idcliente=emprestimo.idcliente group by idplanoamort,num,origem having if(isnull(origem),'',origem)<>'JM' )t group by idplanoamort having (valorprestacao-valorp)<>0 and DATEDIFF(datapagar,curdate()) between 1 and 7 and if(isnull(origem),'',origem)<>'JM' and deleted<>1 order by datapagar asc,nome";

        $expedicao = DB::select($query);

        return Datatables::of($expedicao)->addColumn('action', function ($u) {

            //if(auth()->user()->perfil == 'ADMIN'){
                return '<a href="'.route('movimento.create',$u->idplanoamort).'" class="btn btn-xs btn-primary" title="Efectuar Pagamento"><i class="fa fa-money"></i> Pagar</a>';
           // }
            
        })->removeColumn('idplanoamort','deleted','origem')->make();
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $title = 'Dashboard';
        return view('home', compact('title'));
    }
}
