<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Yajra\Datatables\Datatables;

class RelatoriosController extends Controller
{
    public function getPagamentos()
    {
    	$query = "SELECT nome,apelido,num,if(origem='PST','Prestação','Juro de Mora') origem,valor,datamov,concat(datasistema,' ás ',hora) datasistema, idmovimento FROM cliente inner join emprestimo on cliente.idcliente=emprestimo.idcliente inner join planoamort on planoamort.idemprestimo=emprestimo.idemprestimo inner join movimento on movimento.idplanoamort=planoamort.idplanoamort where deleted=0  order by datasistema desc,nome,apelido,num";

    	$pags = DB::select($query);

        return Datatables::of($pags)->addColumn('action', function ($u) {
            return '<a href="'.url('/').'/reports/recibo2.php?recordID='.$u->idmovimento.'" class="btn btn-xs btn-primary" title="Imprimir Recibo de Pagamento" target="_blank"><i class="entypo-print"></i></a>';
            
        })->removeColumn('idmovimento')->make();
    }

    public function pagamentos(){
    	return view('relatorios.listapagamentos');
    }

    public function getCreditosNaoLiq(){
    	$query = "SELECT idemprestimo,nome,apelido,prestacoes, sum(valor) valor,credito,valortotal,taxajuros,taxaservico,datainicio,datadesembolso,descricao,deleted FROM (select emprestimo.idemprestimo,nome,apelido,origem,prestacoes, if(isnull(sum(valor)),0,valor) valor,credito,valortotal,taxajuros,taxaservico,datainicio, datadesembolso, descricao,deleted,accgarant from planoamort inner join emprestimo on emprestimo.idemprestimo=planoamort.idemprestimo inner join cliente on cliente.idcliente=emprestimo.idcliente inner join amort on emprestimo.idamort=amort.idamort right join movimento on movimento.idplanoamort=planoamort.idplanoamort group by emprestimo.idemprestimo having origem<>'JM' and deleted<>1 union all select emprestimo.idemprestimo,nome,apelido, '' origem,prestacoes, 0 valor,credito,valortotal,taxajuros,taxaservico,datainicio, datadesembolso, descricao, deleted,accgarant from planoamort inner join emprestimo on emprestimo.idemprestimo=planoamort.idemprestimo inner join cliente on cliente.idcliente=emprestimo.idcliente inner join amort on emprestimo.idamort=amort.idamort where idplanoamort not in (select idplanoamort from movimento) group by emprestimo.idemprestimo )t group by idemprestimo having valortotal-valor>0 and deleted<>1 order by nome,apelido";

    	$pags = DB::select($query);

        return Datatables::of($pags)->addColumn('action', function ($u) {
            return '<a href="#" class="btn btn-xs btn-primary" title="Visualizar Detalhes do Crédito"><i class="entypo-eye"></i></a>';
            
        })->removeColumn('idemprestimo', 'deleted')->make();
    }    

    public function creditosNaoLiq(){
    	return view('relatorios.listacreditosnaoliq');
    }

    public function getCreditosLiq(){
    	$query = "SELECT idemprestimo,nome,apelido,prestacoes, sum(valor) valor,credito,valortotal,taxajuros,taxaservico,datainicio,datadesembolso,descricao,deleted FROM (select emprestimo.idemprestimo,nome,apelido,origem,prestacoes, if(isnull(sum(valor)),0,valor) valor,credito,valortotal,taxajuros,taxaservico,datainicio, datadesembolso, descricao,deleted,accgarant from planoamort inner join emprestimo on emprestimo.idemprestimo=planoamort.idemprestimo inner join cliente on cliente.idcliente=emprestimo.idcliente inner join amort on emprestimo.idamort=amort.idamort right join movimento on movimento.idplanoamort=planoamort.idplanoamort group by emprestimo.idemprestimo having origem<>'JM' and deleted<>1 union all select emprestimo.idemprestimo,nome,apelido, '' origem,prestacoes, 0 valor,credito,valortotal,taxajuros,taxaservico,datainicio, datadesembolso, descricao, deleted,accgarant from planoamort inner join emprestimo on emprestimo.idemprestimo=planoamort.idemprestimo inner join cliente on cliente.idcliente=emprestimo.idcliente inner join amort on emprestimo.idamort=amort.idamort where idplanoamort not in (select idplanoamort from movimento) group by emprestimo.idemprestimo )t group by idemprestimo having valortotal-valor=0 and deleted<>1 order by nome,apelido";

    	$pags = DB::select($query);

        return Datatables::of($pags)->addColumn('action', function ($u) {
            return '<a href="#" class="btn btn-xs btn-primary" title="Visualizar Detalhes do Crédito"><i class="entypo-eye"></i></a>';
            
        })->removeColumn('idemprestimo', 'deleted')->make();
    }    

    public function creditosLiq(){
    	return view('relatorios.listacreditosliq');
    }

    public function getCreditosGarantia(){
        $query = "SELECT idemprestimo,nome,apelido,prestacoes, sum(valor) valor,credito,valortotal,taxajuros,taxaservico,datainicio,datadesembolso,descricao,deleted,accgarant FROM (select emprestimo.idemprestimo,nome,apelido,origem,prestacoes, if(isnull(sum(valor)),0,valor) valor,credito,valortotal,taxajuros,taxaservico,datainicio, datadesembolso, descricao,deleted,accgarant from planoamort inner join emprestimo on emprestimo.idemprestimo=planoamort.idemprestimo inner join cliente on cliente.idcliente=emprestimo.idcliente inner join amort on emprestimo.idamort=amort.idamort right join movimento on movimento.idplanoamort=planoamort.idplanoamort group by emprestimo.idemprestimo having origem<>'JM' and deleted<>1 union all select emprestimo.idemprestimo,nome,apelido, '' origem,prestacoes, 0 valor,credito,valortotal,taxajuros,taxaservico,datainicio, datadesembolso, descricao, deleted,accgarant from planoamort inner join emprestimo on emprestimo.idemprestimo=planoamort.idemprestimo inner join cliente on cliente.idcliente=emprestimo.idcliente inner join amort on emprestimo.idamort=amort.idamort where idplanoamort not in (select idplanoamort from movimento) group by emprestimo.idemprestimo )t group by idemprestimo having accgarant=1 and deleted<>1 order by nome,apelido";

        $pags = DB::select($query);

        return Datatables::of($pags)->addColumn('action', function ($u) {
            return '<a href="#" class="btn btn-xs btn-primary" title="Visualizar Detalhes do Crédito"><i class="entypo-eye"></i></a>';
            
        })->removeColumn('idemprestimo', 'deleted','accgarant')->make();
    }    

    public function creditosGarantia(){
        return view('relatorios.listacreditogarantia');
    }

    

    //AUDITORIA DE CLIENTES
    public function getAuditClientes()
    {
        $query = "select cliente.nome, apelido, morada, celular, cliente.email, descricao,datacriado,utilizador.nome name, idcliente from cliente inner join tipocliente on cliente.idtipocliente=tipocliente.idtipocliente inner join utilizador on cliente.idutilizador=utilizador.idutilizador order by nome ";

        $cliente = DB::select($query);

        return Datatables::of($cliente)->removeColumn('idcliente')->make();
    }

    public function auditoriaClientes(){
        return view('relatorios.auditclientes');
    }

    //AUDITORIA DE CREDITOS
    public function getAuditCreditos()
    {
       $query = "select cliente.nome, apelido, FORMAT(credito, 2) credito, prestacoes, FORMAT(valorprest, 2) valorprest, taxajuros, amort.descricao, datainicio,emprestimo.datacriado,utilizador.nome name, idemprestimo from emprestimo inner join cliente on emprestimo.idcliente=cliente.idcliente inner join amort on amort.idamort=emprestimo.idamort inner join utilizador on emprestimo.idutilizador=utilizador.idutilizador order by nome ";

        $emprestimo = DB::select($query);

        return Datatables::of($emprestimo)->removeColumn('idemprestimo')->make();
    }
    
    public function auditoriaCreditos(){
        return view('relatorios.auditcreditos');
    }

    //AUDITORIA DE CREDITOS
    public function getAuditPagamentos()
    {
       $query = "SELECT cliente.nome,apelido,num,if(origem='PST','Prestação','Juro de Mora') origem,FORMAT(valor, 2) valor ,datamov,concat(datasistema,' ás ',hora) datasistema,utilizador.nome name, idmovimento FROM cliente inner join emprestimo on cliente.idcliente=emprestimo.idcliente inner join planoamort on planoamort.idemprestimo=emprestimo.idemprestimo inner join movimento on movimento.idplanoamort=planoamort.idplanoamort inner join utilizador on movimento.idutilizador=utilizador.idutilizador where deleted=0  order by datasistema desc,nome,apelido,num";

        $pags = DB::select($query);

        return Datatables::of($pags)->removeColumn('idmovimento')->make();
    }
    
    public function auditoriaPagamentos(){
        return view('relatorios.auditpagamentos');
    }
}
