@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="{{ route('home') }}"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Créditos</li>
<li class="active">
	<strong>Juros de Mora</strong>
</li>
@endsection
@section('content')

<div class="row">	
	<div class="col-md-12">
		@include('layout.alerts')	
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong>Pagamento de Juros de Mora</strong>
				</div>
			</div>			
			<div class="panel-body">								
				<div class="col-md-12">	
					<table class="table table-striped table-bordered _datatable_" id="clientes_table">
						<thead>
							<th width="15%">Nome</th>
              <th>Apelido</th>
              <th>N&ordm; Prestação</th>
              <th>Data Limite</th>
              <th>Data Pagamento</th>
              <th>Juros de Mora</th>
              <th>Valor Pago</th>
              <th>Valor a Pagar</th>
              <th class="noExport">Acção</th>
						</thead>
						<tbody>
						</tbody>
					</table>		
				</div>						
			</div>
		</div>
	
	</div>
</div>
@endsection

@section('js')
<script>
      $('#clientes_table').DataTable({
          processing: true,
          serverSide: true,
          responsive: true,
          dom: 'lBfrtip',
          search: {
            "case-insensitive": true
          },
          ajax: '{!! route('getjurosmora') !!}',
          columns: [
            { data: 'nome', name: 'nome' },
            { data: 'apelido', name: 'apelido' },
            { data: 'num', name: 'num' },
            { data: 'datapagar', name: 'datapagar' },
            { data: 'datamov', name: 'datamov' },
            { data: 'juros', name: 'juros' },
            { data: 'valorpago', name: 'valorpago' },
            { data: 'valorjuros', name: 'valorjuros' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
          ],
          order: [[3, 'desc']],
          buttons: [
              {
                extend: 'excel',
                title: 'Lista de Juros de Mora por Pagar',
                text: '<i class="fa fa-file-excel-o" style="font-size:20px; color: green"></i>',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                }
              },
              {
                extend: 'pdf',
                title: 'Lista de Juros de Mora por Pagar',
                text: '<i class="fa fa-file-pdf-o" style="font-size:20px; color: red"></i>',
                orientation: 'landscape',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                },
              },
              {
                text: '<i class="fa fa-refresh" style="font-size:20px"></i>',
                action: function ( e, dt, node, config ) {
                    dt.ajax.reload();
                }
              }
          ],
          language: {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "Nenhum registo encontrado",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "Sem registros disponíveis",
            "infoFiltered": "(filtrado de _MAX_ registros totais)",    
            "loadingRecords": "Carregando...",
            "processing":     "Processando...",
            "search":         "Pesquisar:",
            "paginate": {
              "first":      "Primeiro",
              "last":       "Último",
              "next":       "Próximo",
              "previous":   "Anterior"
            },
          }          
      });
</script>
@endsection