<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
// 	$title = 'Dashboard';
//     return view('home', compact('title'));
// })->name('home');

Route::get('/', function () {
    return view('auth/login');
});

Auth::routes();

Route::group(['middleware' => ['auth']], function() {

	Route::get('/home', 'HomeController@index')->name('home');
	Route::get('/home/getcreditos', 'HomeController@getCreditos')->name('home.getcreditos');	

	//UTILIZADORES
	Route::get('/utilizadores/', 'UsersController@index')->name('utilizadores');
	Route::get('/utilizador/add', 'UsersController@create')->name('utilizador.create');
	Route::post('/utilizador/store', 'UsersController@store')->name('utilizador.store');
	Route::get('/utilizador/edit/{id}', 'UsersController@edit')->name('utilizador.edit');
	Route::put('/utilizador/update/{id}', 'UsersController@update')->name('utilizador.update');
	Route::get('/utilizador/delete/{id}', 'UsersController@delete')->name('utilizador.delete');
	Route::put('/utilizador/destroy/{id}', 'UsersController@destroy')->name('utilizador.destroy');
	Route::post('/utilizador/senha/update', 'UsersController@senhaUpdate')->name('utilizador.senhaupdate');
	Route::get('/utilizador/senhaupdateview', 'UsersController@senhaUpdateView')->name('utilizador.senhaupdateview');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE UTILIZADORES
	Route::get('/getutilizadores', 'UsersController@getUtilizadores')->name('getutilizadores');

	//FICHA DA EMPRESA
	Route::get('/empresa', 'EmpresaController@index')->name('empresa');
	Route::post('/empresa/store', 'EmpresaController@store')->name('empresa.store');
	Route::put('/empresa/update/{id}', 'EmpresaController@update')->name('empresa.update');

	//DOCUMENTOS DA EMPRESA
	Route::get('/docsemp/', 'DocsEmpController@index')->name('docsemp');
	Route::get('/docsemp/add', 'DocsEmpController@create')->name('docsemp.create');
	//VISUALIZA DETALHES DO DOCUMENTO DA EMPRESA
	Route::get('/docsemp/show/{id}', 'DocsEmpController@show')->name('docsemp.show');
	Route::post('/docsemp/store', 'DocsEmpController@store')->name('docsemp.store');
	Route::put('/docsemp/update/{id}', 'DocsEmpController@update')->name('docsemp.update');
	//APAGA  DOCUMENTO DA EMPRESA NA BASE DE DADOS
	Route::get('/docsemp/delete/{id}', 'DocsEmpController@delete')->name('docsemp.delete');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE DOCUMENTOS DIVERSOS
	Route::get('/getdocsemp', 'DocsEmpController@getDocsemp')->name('getdocsemp');

	//CLIENTE
	Route::get('/clientes/', 'ClienteController@index')->name('clientes');
	Route::get('/clientes/show/{id}', 'ClienteController@show')->name('cliente.show');
	Route::get('/clientes/add', 'ClienteController@create')->name('cliente.create');
	Route::post('/clientes/store', 'ClienteController@store')->name('cliente.store');
	Route::get('/clientes/edit/{id}', 'ClienteController@edit')->name('cliente.edit');
	Route::put('/clientes/update/{id}', 'ClienteController@update')->name('cliente.update');
	Route::get('/clientes/delete/{id}', 'ClienteController@destroy')->name('cliente.delete');
	Route::get('/clientes/creditos/{id}', 'ClienteController@viewCreditos')->name('cliente.creditos');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE CLIENTES
	Route::get('/getclientes', 'ClienteController@getClientes')->name('getclientes');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE CREDITOS DUM CLIENTE 
	Route::get('/getcreditos/{id}', 'ClienteController@getCreditos')->name('getcreditos');

	//AVALISTA
	Route::get('/avalistas/{id}', 'AvalistaController@index')->name('avalistas');
	Route::get('/avalistas/show/{id}', 'AvalistaController@show')->name('avalista.show');
	Route::get('/avalistas/add/{id}', 'AvalistaController@create')->name('avalista.create');
	Route::post('/avalistas/store', 'AvalistaController@store')->name('avalista.store');
	Route::get('/avalistas/edit/{id}', 'AvalistaController@edit')->name('avalista.edit');
	Route::put('/avalistas/update/{id}', 'AvalistaController@update')->name('avalista.update');
	Route::get('/avalistas/delete/{id}', 'AvalistaController@destroy')->name('avalista.delete');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE AVALISTAS
	Route::get('/getavalistas/{id}', 'AvalistaController@getAvalistas')->name('getavalistas');

	//EMPRESTIMO
	Route::get('/emprestimos/', 'EmprestimoController@index')->name('emprestimos');
	Route::get('/emprestimos/show/{id}', 'EmprestimoController@show')->name('emprestimo.show');
	Route::get('/emprestimos/add', 'EmprestimoController@create')->name('emprestimo.create');
	Route::post('/emprestimos/store', 'EmprestimoController@store')->name('emprestimo.store');
	Route::get('/emprestimos/edit/{id}', 'EmprestimoController@edit')->name('emprestimo.edit');
	Route::put('/emprestimos/update/{id}', 'EmprestimoController@update')->name('emprestimo.update');
	Route::get('/emprestimos/delete/{id}', 'EmprestimoController@delete')->name('emprestimo.delete');
	Route::get('/emprestimos/destroy/{id}', 'EmprestimoController@destroy')->name('emprestimo.destroy');
	Route::get('/emprestimos/expedicoes', 'EmprestimoController@viewexpedicoes')->name('emprestimo.expedicao');
	// Route::get('/emprestimos/expedicoesdet', 'EmprestimoController@viewexpedicoesdet')->name('emprestimo.expedicaodet');
	Route::get('/emprestimos/juros', 'EmprestimoController@viewJuros')->name('emprestimo.juros');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE EMPRESTIMOS
	Route::get('/getemprestimos', 'EmprestimoController@getEmprestimos')->name('getemprestimos');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE EXPEDIÇÕES
	Route::get('/getexpedicao', 'EmprestimoController@getExpedicao')->name('getexpedicao');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE PAGAMENTO POR EFECTUAR DE UM CLIENTE
	// Route::get('/getexpedicaodet/{id}', 'EmprestimoController@getExpedicaoDet')->name('getexpedicaodet');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE JUROS DE MORA POR PAGAR
	Route::get('/getjurosmora', 'EmprestimoController@getJurosMora')->name('getjurosmora');

	//MOVIMENTO OU PAGAMENTO
	Route::get('/movimento/add/{id}', 'MovimentoController@create')->name('movimento.create');
	Route::post('/movimento/store', 'MovimentoController@store')->name('movimento.store');
	Route::get('/movimento/addjuros/{id}', 'MovimentoController@createJuros')->name('movimento.createjuros');

	//RELATORIOS
	Route::get('/relatorios/pagamentos', 'RelatoriosController@pagamentos')->name('relatorios.pagamentos');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE PAGAMENTOS
	Route::get('/relatorios/getpagamentos', 'RelatoriosController@getPagamentos')->name('getpagamentos');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE CREDITOS NÃO LIQUIDADOS
	Route::get('/relatorios/getcreditosnaoliq', 'RelatoriosController@getCreditosNaoLiq')->name('getcreditosnaoliq');
	Route::get('/relatorios/creditosnaoliq', 'RelatoriosController@creditosNaoLiq')->name('relatorios.creditosnaoliq');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE CREDITOS LIQUIDADOS
	Route::get('/relatorios/getcreditosliq', 'RelatoriosController@getCreditosLiq')->name('getcreditosliq');
	Route::get('/relatorios/creditosliq', 'RelatoriosController@creditosLiq')->name('relatorios.creditosliq');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE CREDITOS COM GARANTIA ACCIONADA
	Route::get('/relatorios/getcreditosgarantia', 'RelatoriosController@getCreditosGarantia')->name('getcreditosgarantia');
	Route::get('/relatorios/creditosgarantia', 'RelatoriosController@creditosGarantia')->name('relatorios.creditosgarantia');

	//REQUISICAO AJAX PARA CARREGAR LISTA DE AUDITORIA DE CLIENTES
	Route::get('/relatorios/getauditclientes', 'RelatoriosController@getAuditClientes')->name('getauditclientes');
	Route::get('/relatorios/auditoriaclientes', 'RelatoriosController@auditoriaClientes')->name('relatorios.auditoriaclientes');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE AUDITORIA DE CREDITOS
	Route::get('/relatorios/getauditcreditos', 'RelatoriosController@getAuditCreditos')->name('getauditcreditos');
	Route::get('/relatorios/auditoriacreditos', 'RelatoriosController@auditoriaCreditos')->name('relatorios.auditoriacreditos');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE AUDITORIA DE PAGAMENTOS
	Route::get('/relatorios/getauditpagamentos', 'RelatoriosController@getAuditPagamentos')->name('getauditpagamentos');
	Route::get('/relatorios/auditoriapagamentos', 'RelatoriosController@auditoriaPagamentos')->name('relatorios.auditoriapagamentos');
	
	//TIPO DE ANEXOS
	Route::get('/tipoanexos/', 'TipoanexoController@index')->name('tipoanexos');
	Route::get('/tipoanexo/add', 'TipoanexoController@create')->name('tipoanexo.create');
	Route::post('/tipoanexo/store', 'TipoanexoController@store')->name('tipoanexo.store');
	Route::get('/tipoanexo/edit/{id}', 'TipoanexoController@edit')->name('tipoanexo.edit');
	Route::put('/tipoanexo/update/{id}', 'TipoanexoController@update')->name('tipoanexo.update');
	Route::get('/tipoanexo/delete/{id}', 'TipoanexoController@delete')->name('tipoanexo.delete');
	Route::put('/tipoanexo/destroy/{id}', 'TipoanexoController@destroy')->name('tipoanexo.destroy');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE TIPOS DE ANEXOS
	Route::get('/gettipoanexo', 'TipoanexoController@getTipoanexo')->name('gettipoanexo');

	//TIPO DE TAXAS DE JUROS
	Route::get('/taxajuros/', 'TaxajuroController@index')->name('taxajuros');
	Route::get('/taxajuro/add', 'TaxajuroController@create')->name('taxajuro.create');
	Route::post('/taxajuro/store', 'TaxajuroController@store')->name('taxajuro.store');
	Route::get('/taxajuro/edit/{id}', 'TaxajuroController@edit')->name('taxajuro.edit');
	Route::put('/taxajuro/update/{id}', 'TaxajuroController@update')->name('taxajuro.update');
	Route::get('/taxajuro/delete/{id}', 'TaxajuroController@delete')->name('taxajuro.delete');
	Route::put('/taxajuro/destroy/{id}', 'TaxajuroController@destroy')->name('taxajuro.destroy');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE TAXAS DE JUROS
	Route::get('/gettaxajuro', 'TaxajuroController@getTaxajuro')->name('gettaxajuro');

	//TIPO DE TAXAS DE SERVICO
	Route::get('/taxaservicos/', 'TaxaservicoController@index')->name('taxaservicos');
	Route::get('/taxaservico/add', 'TaxaservicoController@create')->name('taxaservico.create');
	Route::post('/taxaservico/store', 'TaxaservicoController@store')->name('taxaservico.store');
	Route::get('/taxaservico/edit/{id}', 'TaxaservicoController@edit')->name('taxaservico.edit');
	Route::put('/taxaservico/update/{id}', 'TaxaservicoController@update')->name('taxaservico.update');
	Route::get('/taxaservico/delete/{id}', 'TaxaservicoController@delete')->name('taxaservico.delete');
	Route::put('/taxaservico/destroy/{id}', 'TaxaservicoController@destroy')->name('taxaservico.destroy');
	//REQUISICAO AJAX PARA CARREGAR LISTA DE TAXAS DE SERVICOS
	Route::get('/gettaxaservico', 'TaxaservicoController@getTaxaservico')->name('gettaxaservico');
});
