<?php $__env->startSection('content_header'); ?>
    <h1><?php echo e($titulo); ?></h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  <div class="box box-success">
    <div class="box-header">
      <a class="btn btn-warning" href="<?php echo e(route('individual.lista')); ?>">
        <i class="fa fa-step-backward"></i> Voltar
      </a>
    </div>
    <div class="box-body">
        <?php if(isset($consultor)): ?>
        <form method="post" action="<?php echo e(route('individual.update',$consultor->idconsultorind)); ?>" enctype="multipart/form-data">
          <?php echo method_field('put'); ?>

        <?php else: ?>
          <form method="post" action="<?php echo e(route('individual.store')); ?>" enctype="multipart/form-data">
        <?php endif; ?>      
        <?php echo csrf_field(); ?>  
        <div class="box-body">
          <div class="row">
            <div class="col-md-6 well">
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="numero">N&ordm; de Processo</label>
                    <input type="text" name="noprocesso" class="form-control input-sm" value="<?php echo e($consultor->noprocesso ?? null); ?>">
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="nocertificado">N&ordm; de Certificado</label>
                    <input type="text" name="nocertificado" class="form-control input-sm" value="<?php echo e($consultor->nocertificado ?? null); ?>">
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!--/Row-->
          <div class="row well">
            <div class="col-md-6">
              <div class="row">
                <div class="col-md-7">
                  <div class="form-group">
                    <label for="nome">Nome do Consultor</label>
                    <input type="text" name="nome" class="form-control input-sm" value="<?php echo e($consultor->nome ?? null); ?>" required>
                  </div>                
                </div>
                <div class="col-md-5">
                  <div class="form-group">
                    <label for="datanasc">Data de Nascimento</label>
                    <input type="date" name="datanasc" class="form-control input-sm" value="<?php echo e($consultor->datanasc ?? null); ?>" required>
                  </div>                
                </div>
              </div>              
              <div class="row">
                <div class="col-md-5">
                  <div class="form-group">
                    <label for="tipodoc">Tipo de Documento</label>
                    <select name="tipodoc" id="tipodoc" class="form-control select2 input-sm" required>
                      <option value=""> --Selecione-- </option>
                      <option value="BI" <?php if(isset($consultor) && $consultor->tipodoc=='BI'): ?> selected <?php endif; ?> >BI</option>
                      <option value="Passaporte" <?php if(isset($consultor) && $consultor->tipodoc=='Passaporte'): ?> selected <?php endif; ?> >Passaporte</option>
                      <option value="DIRE" <?php if(isset($consultor) && $consultor->tipodoc=='DIRE'): ?> selected <?php endif; ?> >DIRE</option>
                    </select>
                  </div>
                </div>
                <div class="col-md-7">
                  <div class="form-group">
                    <label for="numdoc">N&ordm; do Documento</label>
                    <input type="text" name="numdoc" class="form-control input-sm" value="<?php echo e($consultor->numdoc ?? null); ?>" required>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="dataemissao">Data de Emissão</label>
                    <input type="date" name="dataemissao" class="form-control input-sm" value="<?php echo e($consultor->dataemissao ?? null); ?>" required>
                  </div>                
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="datavalidade">Data de Validade</label>
                    <input type="date" name="datavalidade" class="form-control input-sm" value="<?php echo e($consultor->datavalidade ?? null); ?>" required>
                  </div>                
                </div>
              </div>
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="localemissao">Local de Emissão</label>
                    <input type="text" name="localemissao" class="form-control input-sm" value="<?php echo e($consultor->localemissao ?? null); ?>" required>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="nacionalidade">Nacionalidade</label>
                    <input type="text" name="nacionalidade" class="form-control input-sm" value="<?php echo e($consultor->nacionalidade ?? null); ?>" required>
                  </div>
                </div>
              </div> 
              <div class="row">
                <div class="col-md-12">
                  <div class="form-group">
                    <label for="localtrabalho">Local de Trabalho</label>
                    <input type="text" name="localtrabalho" class="form-control input-sm" value="<?php echo e($consultor->localtrabalho ?? null); ?>" required>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="profissao">Profissão</label>
                    <input type="text" name="profissao" class="form-control input-sm" value="<?php echo e($consultor->profissao ?? null); ?>" required>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="telefone">Telefone</label>
                    <input type="text" name="telefone" class="form-control input-sm" value="<?php echo e($consultor->telefone ?? null); ?>">
                  </div>
                </div>
              </div> 
              <div class="row">
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="fax">Fax</label>
                    <input type="text" name="fax" class="form-control input-sm" value="<?php echo e($consultor->fax ?? null); ?>">
                  </div>
                </div>
                <div class="col-md-8">
                  <div class="form-group">
                    <label for="email">E-mail</label>
                    <input type="email" name="email" class="form-control input-sm" value="<?php echo e($consultor->email ?? null); ?>">
                  </div>
                </div> 
              </div> 
              <div class="row">
                <div class="col-md-8">
                  <div class="form-group">
                    <label for="residencia">Residência</label>
                    <input type="text" name="residencia" class="form-control input-sm" value="<?php echo e($consultor->residencia ?? null); ?>" required>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="telefoneres">Telefone</label>
                    <input type="text" name="telefoneres" class="form-control input-sm" value="<?php echo e($consultor->telefoneres ?? null); ?>">
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="faxres">Fax</label>
                    <input type="text" name="faxres" class="form-control input-sm" value="<?php echo e($consultor->faxres ?? null); ?>">
                  </div>
                </div>
                <div class="col-md-8">
                  <div class="form-group">
                    <label for="emailres">E-mail</label>
                    <input type="email" name="emailres" class="form-control input-sm" value="<?php echo e($consultor->emailres ?? null); ?>">
                  </div>
                </div> 
              </div> 
            </div>
          </div>
          <!--/Row-->
          <div class="row well">
            <div class="col-md-4">
              <div class="form-group">
                <label for="areaconsultoria">Área de Consultoria Ambiental</label>
                  <select name="areaconsultoria" id="areaconsultoria" class="form-control select2 input-sm" required>
                    <option value=""> --Selecione-- </option>
                    <option value="Florestas nativas" <?php if(isset($consultor) && $consultor->areaconsultoria=='Florestas nativas'): ?> selected <?php endif; ?> >Florestas nativas</option>

                    <option value="Especies endémicas" <?php if(isset($consultor) && $consultor->areaconsultoria=='Especies endémicas'): ?> selected <?php endif; ?> >Especies endémicas</option>

                    <option value="Especies Protegidas" <?php if(isset($consultor) && $consultor->areaconsultoria=='Especies Protegidas'): ?> selected <?php endif; ?> >Especies Protegidas</option>

                    <option value="Especies migratórias congregatórias" <?php if(isset($consultor) && $consultor->areaconsultoria=="Especies migratórias congregatórias"): ?> selected <?php endif; ?> >Especies migratórias congregatórias</option>

                    <option value="Escosistemas ameacaços ou unicos" <?php if(isset($consultor) && $consultor->areaconsultoria=='Escosistemas ameacaços ou unicos'): ?> selected <?php endif; ?> >Escosistemas ameacaços ou unicos</option>

                    <option value="Areas de Mangal" <?php if(isset($consultor) && $consultor->areaconsultoria=='Areas de Mangal'): ?> selected <?php endif; ?> >Areas de Mangal</option>
                  </select>
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label for="nuit">NUIT</label>
                <input type="number" name="nuit" minlength="11" maxlength="11" class="form-control input-sm" value="<?php echo e($consultor->nuit ?? null); ?>">
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label for="seguroprofissional">Seguro Profissional</label>
                <input type="text" name="seguroprofissional" class="form-control input-sm" value="<?php echo e($consultor->seguroprofissional ?? null); ?>">
              </div>
            </div>
          </div>
          <!--/Row-->
          <div class="row well">
            <div class="row">
              <div class="col-md-2" style="margin-left: 15px">
                <button type="button" name="addDocs" id="addDocs" class="btn btn-success btn-block btn-sm"  data-toggle="modal" data-target="#modal-docs"><i class="fa fa-plus"></i> Qualificação Académica</button> 
              </div>
              <div class="col-md-8" id="deleteds">
                
              </div>
            </div>
            <div class="col-md-12">
              <!--Tabela e a Modal de Anexos-->  
              <?php echo $__env->make('layouts.anexos', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>  
              <!-- /.modal -->          
            </div>
          </div>
          <!--/Row-->
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          <div class="col-md-6">
            <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Gravar</button>
          </div>
        </div>
      </form>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('adminlte_js'); ?>
<script>  
  (function($) {
    removeLinha = function(item) {
      var idqual = $(item).val();
      var idquals = '';
      var tr = $(item).closest('tr');
      var deleteds = '';
      deleteds += '<input type="text" name="deleted[]" readonly value="'+idqual+'" class="form-control" />';
      $("#deleteds").append(deleteds);

      // if(document.getElementById('deleted').value !=''){
      //   idquals = document.getElementById('deleted').value+','+idqual;
      //   $('#deleted').val(idquals);
      // }else{
      //   $('#deleted').val(idqual);
      // }

      tr.fadeOut(400, function() {
        tr.remove();  
      });
      
      return false;
    }
  })(jQuery);
  
  //GRID DE ANEXOS
  (function($) {
    addAnexos = function() {
    var idtipod=document.getElementById('idtipod').value;
    //var pathA=document.getElementById('pathA').value;
    if(idtipod==''){
      alert("Selecione um tipo de Documento");
      return false;
    }
    var newRow = $("<tr>");
    var cols = "";
    cols += '<td><input id="descricaodoc" type="text" name="descricaodoc[]" readonly value="'+idtipod+'" class="form-control" /><input type="hidden" name="new[]" value="true"> </td>';
    cols += '<td><input id="path" type="file" name="path[]" readonly class="form-control" /></td>';
    cols += '<td>';
    cols += '<button class="btn btn-danger btn-sm" onclick="removeLinha(this)" type="button" value="null"><i class="fa fa-remove"></i>&nbsp;Remover</button>';
    cols += '</td></tr>';

    newRow.append(cols);
    $("#docs").append(newRow);

    return false;
    }
  })(jQuery); 

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp73\htdocs\dinab\resources\views/individual/frmIndividual.blade.php ENDPATH**/ ?>