<?php $__env->startSection('breadcrumb'); ?>
<li>
	<a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li class="active">
	<strong>Ficha da Empresa</strong>
</li>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="row">	
	<div class="col-md-12">	
		<?php echo $__env->make('layout.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php if(isset($emp)): ?>
        	<form method="post" action="<?php echo e(route('empresa.update',$emp->idempresa)); ?>" enctype="multipart/form-data">
          	<?php echo method_field('put'); ?>

        <?php else: ?>
			<form role="form" class="form-horizontal" method="post" action="<?php echo e(route('empresa.store')); ?>" enctype="multipart/form-data">	
		<?php endif; ?> 
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong>Dados da Empresa</strong>
				</div>
			</div>			
			<div class="panel-body">				
					
					<?php echo csrf_field(); ?>  				
					<div class="row">
						<div class="col-md-6">					
							<div class="form-group has-info">
								<label for="nomeemp" class="control-label">Nome da Empresa</label>
								<input type="text" class="form-control" id="nomeemp" name="nomeemp" placeholder="Nome da Empresa" value="<?php echo e($emp->nomeemp); ?>" required>
							</div>	
							<div class="row">
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">Sigla</label>
										<input id="idempresa" name="idempresa" type="hidden" class="form-control" value="<?php echo e($emp->idempresa); ?>">
										<input type="text" class="form-control" id="sigla" name="sigla" placeholder="Sigla da Empresa" value="<?php echo e($emp->sigla); ?>">
									</div>		
								</div>
								<div class="col-md-8">
									<div class="form-group has-info">
										<label class="control-label">Localidade</label>
										<input type="text" class="form-control" id="localidade" name="localidade" placeholder="Localdidade da Empresa" value="<?php echo e($emp->localidade); ?>">
									</div>
								</div>
							</div>				
							<div class="form-group has-info">
								<label class="control-label">Endereço</label>
								<input type="text" class="form-control" id="mora" name="mora" placeholder="Morada da Empresa" value="<?php echo e($emp->mora); ?>" >
							</div>
							<div class="row">
								<div class="col-md-6">
									<div class="form-group has-info">
										<label class="control-label">Telefone</label>
										<input type="text" class="form-control" data-mask="(+258) 99 999 999" id="tel" name="tel" placeholder="Telefone da Empresa" value="<?php echo e($emp->tel); ?>" >
									</div>		
								</div>
								<div class="col-md-6">
									<div class="form-group has-info">
										<label class="control-label">Fax</label>
										<input type="text" class="form-control" data-mask="(+258) 99 999 999" id="fax" name="fax" placeholder="Fax da Empresa" value="<?php echo e($emp->fax); ?>" >
									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">Celular</label>
										<input type="text" class="form-control" data-mask="(+258) 99 999 9999" id="cel" name="cel" placeholder="Celular da Empresa" value="<?php echo e($emp->cel); ?>">
									</div>		
								</div>
								<div class="col-md-8">
									<div class="form-group has-info">
										<label class="control-label">Email</label>
										<input type="email" class="form-control" id="mail" name="mail" placeholder="Email da Empresa" value="<?php echo e($emp->mail); ?>" >
									</div>
								</div>
							</div>
						</div>
						<div class="col-md-6">	
							<div class="row">
								<div class="col-md-8">
									<div class="form-group has-info">
										<label class="control-label">Website</label>
										<input type="text" class="form-control" id="website" name="website" placeholder="Website da Empresa" value="<?php echo e($emp->website); ?>" >
									</div>		
								</div>
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">NUIT</label>
										<input type="text" data-mask="99999999999" class="form-control" id="nuitt" name="nuitt" placeholder="NUIT da Empresa" value="<?php echo e($emp->nuitt); ?>">
									</div>
								</div>
							</div>	
							<div class="row">
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">Banco 1</label>
										<input type="text" class="form-control" id="banco1" name="banco1" placeholder="Nome do Banco 1" value="<?php echo e($emp->banco1); ?>">
									</div>		
								</div>
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">N&ordm; de Conta 1</label>
										<input type="text" data-mask="9999999999999999999999999999"  class="form-control" id="conta1" name="conta1" placeholder="N&ordm; Conta 1" value="<?php echo e($emp->conta1); ?>" >
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">NIB 1</label>
										<input type="text" class="form-control" data-mask="9999999999999999999999999999" id="nib1" name="nib1" placeholder="NIB da Conta 1" value="<?php echo e($emp->nib1); ?>" >
									</div>		
								</div>
							</div>	
							<div class="row">
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">Banco 2</label>
										<input type="text" class="form-control" id="banco2" name="banco2" placeholder="Nome do Banco 2" value="<?php echo e($emp->banco2); ?>" >
									</div>		
								</div>
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">N&ordm; de Conta 2</label>
										<input type="text" data-mask="9999999999999999999999999999"  class="form-control" id="conta2" name="conta2" placeholder="N&ordm; Conta 2" value="<?php echo e($emp->conta2); ?>">
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">NIB 2</label>
										<input type="text" class="form-control" data-mask="9999999999999999999999999999" id="nib2" name="nib2" placeholder="NIB da Conta 2" value="<?php echo e($emp->nib2); ?>" >
									</div>		
								</div>
							</div>	
							<div class="row">
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">Banco 3</label>
										<input type="text" class="form-control" id="banco3" name="banco3" placeholder="Nome do Banco 1" value="<?php echo e($emp->banco3); ?>" >
									</div>		
								</div>
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label2">N&ordm; de Conta 3</label>
										<input type="text" data-mask="9999999999999999999999999999"  class="form-control" id="conta3" name="conta3" placeholder="N&ordm; Conta 3" value="<?php echo e($emp->conta3); ?>" >
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">NIB 3</label>
										<input type="text" class="form-control" data-mask="9999999999999999999999999999" id="nib3" name="nib3" placeholder="NIB da Conta 3" value="<?php echo e($emp->nib3); ?>" >
									</div>		
								</div>
							</div>
							<div class="row">
								<div class="col-md-6">
									<div class="form-group has-info">
										<label class="control-label">Comissão de Gestores (%)</label>
										<input data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="10" type="text" class="form-control" id="comissao" name="comissao" placeholder="Comissão de Gestores" value="<?php echo e($emp->comissao); ?>" >
									</div>		
								</div>								
							</div>
						</div>
					</div>			
							
			</div>
			<div class="panel-footer">
				<button type="submit" id="gravar" class="btn btn-success">
					<i class="fa fa-save"></i> Gravar
				</button>    
			</div>
			</form>	
		</div>
	
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp73\htdocs\smartechmz\jtmc\resources\views/empresa.blade.php ENDPATH**/ ?>