<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\Models\Avalista;
use App\Models\Tipodocid;
use App\Models\Negocio;
use App\Models\Emprego;
use Yajra\Datatables\Datatables;

class AvalistaController extends Controller
{

    public function __construct(){
         $this->url = (env('APP_DEBUG') == false) ? 'https://jtmc.co.mz/smartechmz/jtmc/public/' : 'http://localhost/smartechmz/smarcredito/public/';
    }

    //LISTA DE AVALISTAS
    public function getAvalistas($id)
    {
        $query = "select nome, apelido, morada, celular, email, naturalidade, tipotrabalho, idavalista from avalista where idcliente=".$id." order by nome ";

        $avalista = DB::select($query);

        return Datatables::of($avalista)->addColumn('action', function ($u) {
            return '<a href="'.$this->url.'reports/fichaAvalista.php?recordID='.$u->idavalista.'" target="_blank" class="btn btn-xs btn-primary" title="Visualizar"><i class="fa fa-eye"></i></a> <a href="'.route("avalista.edit",$u->idavalista).'" class="btn btn-xs btn-primary" title="Editar"><i class="entypo-pencil"></i></a> <a href="'.route("avalista.show",$u->idavalista).'" class="btn btn-xs btn-danger" title="Apagar"><i class="fa fa-trash"></i></a>';
        })->removeColumn('idavalista')->make();
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($id)
    {     
        $title = 'Lista de Avalistas';
        return view('avalista.lista', compact('title','id'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($idcliente)
    {
        $tipodocid = Tipodocid::orderBy('descricao')->get();
        $title = 'Cadastrar Avalista';
        return view('avalista.frmavalista', compact('title','tipodocid','idcliente'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->except(['tiponegocio','datainicio','capital','rendimento','nomeestab','endereco','profissao','empresa','rendimentoe','enderecoe']);
        $negocio = $request->only(['tiponegocio','datainicio','nomeestab','endereco']);
        $emprego = $request->only(['profissao','empresa','enderecoe']);

        //dd($data);

        DB::beginTransaction();
        $insert  = Avalista::create($data);

        if ($data['tipotrabalho']=='Comerciante') {
            $neg = [
                'tiponegocio' => $negocio['tiponegocio'],
                'datainicio'  => $negocio['datainicio'],
                'nome'        => $negocio['nomeestab'],
                'endereco'    => $negocio['endereco'],
                'idavalista'   => $insert->idavalista
            ];
            $insertF = Negocio::create($neg);
        }else{
            if($data['tipotrabalho']=='Funcionário(a)'){
                $emp = [
                    'profissao'  => $emprego['profissao'],
                    'empresa'    => $emprego['empresa'],
                    'endereco'   => $emprego['enderecoe'],
                    'idavalista'  => $insert->idavalista
                ];
                $insertF = Emprego::create($emp);
            }else{
                $insertF = true;
            }
        }

        if($insert && $insertF){
          DB::commit();
          return redirect()
                      ->route('avalista.create',$data['idcliente'])
                      ->with('success',"Avalista Gravado com Sucesso!");
        }else{
          DB::rollBack();
          return redirect()
                        ->back()
                        ->with('error', 'Erro ao Gravar!');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $tipodocid   = Tipodocid::orderBy('descricao')->get();
        $cl          = Avalista::where('idavalista',$id)->get()->first();
        $neg         = Negocio::where('idavalista',$id)->orderBy('idnegocio')->get()->first();
        $empr        = Emprego::where('idavalista',$id)->orderBy('idemprego')->get()->first();
        $title       = 'Apagar Avalista';
        $delete      = true;
        return view('avalista.frmavalistadelete', compact('title','tipodocid', 'cl', 'neg', 'empr', 'delete'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $tipodocid   = Tipodocid::orderBy('descricao')->get();        
        $cl     = Avalista::where('idavalista',$id)->get()->first();
        //dd($cl);
        $neg    = Negocio::where('idavalista',$id)->orderBy('idnegocio')->get()->first();
        $empr   = Emprego::where('idavalista',$id)->orderBy('idemprego')->get()->first();
        $title = 'Editar Avalista';
        return view('avalista.frmavalista', compact('title','tipodocid', 'cl', 'neg', 'empr'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data      = $request->except(['idavalista','idcliente','_token','_method','tiponegocio','datainicio','nomeestab','endereco','profissao','empresa','enderecoe']);
        $negocio   = $request->only(['tiponegocio','datainicio','nomeestab','endereco']);
        $emprego   = $request->only(['profissao','empresa','enderecoe']);
        $idcliente = $request->only(['idcliente']);

        //dd($idcliente);

        DB::beginTransaction();
        $insert  = Avalista::where('idavalista',$id)->update($data);

        if ($data['tipotrabalho']=='Comerciante') {
            $neg = [
                'tiponegocio' => $negocio['tiponegocio'],
                'datainicio'  => $negocio['datainicio'],
                'nome'        => $negocio['nomeestab'],
                'endereco'    => $negocio['endereco']
            ];
            $insertF = Negocio::where('idavalista',$id)->update($neg);
        }else{
            if($data['tipotrabalho']=='Funcionário(a)'){
                $emp = [
                    'profissao'  => $emprego['profissao'],
                    'empresa'    => $emprego['empresa'],
                    'endereco'   => $emprego['enderecoe']
                ];
                $insertF = Emprego::where('idavalista',$id)->update($emp);
            }else{
                $insertF = true;
            }
            
        }

        if($insert && $insertF){
          DB::commit();
          return redirect()
                      ->route('avalistas', $idcliente)
                      ->with('success',"Avalista Atualizado com Sucesso!");
        }else{
          DB::rollBack();
          return redirect()
                        ->back()
                        ->with('error', 'Erro ao Atualizar!');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete = Avalista::where('idavalista',$id)->delete();
        
        if($delete)
            return redirect()
                            ->route('clientes')
                            ->with('success',"Avalista Apagado com Sucesso!");
        else
            return redirect()
                            ->route('avalista.show',$id)
                            ->with('error', "Erro ao Apagar!");
    }
}
