<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\Models\Cliente;
use App\Models\Tipodocid;
use App\Models\Tipocliente;
use App\Models\Negocio;
use App\Models\Emprego;
use Yajra\Datatables\Datatables;

class ClienteController extends Controller
{

    //LISTA DE CLIENTES
    public function getClientes()
    {
        $query = "select nome, apelido, morada, celular, email, descricao, idcliente from cliente inner join tipocliente on cliente.idtipocliente=tipocliente.idtipocliente order by nome ";

        $cliente = DB::select($query);

        return Datatables::of($cliente)->addColumn('action', function ($u) {

            $ver = '<a href="reports/fichaCliente.php?recordID='.$u->idcliente.'" target="_blank" class="btn btn-xs btn-primary" title="Visualizar"><i class="fa fa-eye"></i></a>';

            $avalista = ' <a href="'.route("avalistas",$u->idcliente).'" class="btn btn-xs btn-info" title="Avalista"><i class="fa fa-user"></i></a>';

            $editar = ' <a href="'.route("cliente.edit",$u->idcliente).'" class="btn btn-xs btn-primary" title="Editar"><i class="entypo-pencil"></i></a>';

            $creditos = ' <a href="'.route("cliente.creditos",$u->idcliente).'" class="btn btn-xs btn-primary" title="Visualizar Créditos"><i class="fa fa-money"></i></a>';

            $apagar = ' <a href="'.route("cliente.show",$u->idcliente).'" class="btn btn-xs btn-danger" title="Apagar"><i class="fa fa-trash"></i></a>';

            if(auth()->user()->perfil == 'ADMIN'){
                $link = $ver.$avalista.$editar.$creditos.$apagar;
            }else{
                $link = $ver.$avalista.$creditos;
            }

            return $link;
        })->removeColumn('idcliente')->make();
    }

    //LISTA DE CREDITOS DUM CLIENTE
    public function getCreditos($idcliente)
    {
        $query = "select FORMAT(credito, 2) credito, prestacoes, FORMAT(valorprest, 2) valorprest, taxajuros, FORMAT(taxaservico, 2) taxaservico, datainicio, idemprestimo from emprestimo where idcliente = ".$idcliente." order by datainicio ";

        $emprestimo = DB::select($query);

        return Datatables::of($emprestimo)->addColumn('action', function ($u) {
            $ver = '<a href="'.route('emprestimo.show',$u->idemprestimo).'" class="btn btn-xs btn-primary" title="Visualizar"><i class="fa fa-eye"></i></a>';

            $editar = ' <a href="'.route("emprestimo.edit",$u->idemprestimo).'" class="btn btn-xs btn-warning" title="Editar"><i class="entypo-pencil"></i></a>';

            $apagar = ' <a href="'.route("emprestimo.show",$u->idemprestimo).'" class="btn btn-xs btn-danger" title="Apagar"><i class="fa fa-trash"></i></a>'; 

            if(auth()->user()->perfil == 'ADMIN'){
                $link = $ver.$editar.$apagar;
            }else{
                $link = $ver;
            }
            return $link;

        })->removeColumn('idemprestimo')->make();
    }

    public function viewCreditos($idcliente){
        $cl = Cliente::where('idcliente',$idcliente)->get()->first();
        $title = 'Lista de Créditos';

        return view("cliente.listacreditos", compact("cl", "title"));
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {        
        $title = 'Lista de Clientes';
        return view('cliente.lista', compact('title'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $tipodocid = Tipodocid::orderBy('descricao')->get();
        $tipocliente = Tipocliente::orderBy('descricao')->get();
        $title = 'Cadastrar Cliente';
        return view('cliente.frmcliente', compact('title','tipodocid','tipocliente'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->except(['tiponegocio','datainicio','capital','rendimento','nomeestab','endereco','profissao','empresa','rendimentoe','enderecoe']);
        $negocio = $request->only(['tiponegocio','datainicio','capital','rendimento','nomeestab','endereco']);
        $emprego = $request->only(['profissao','empresa','rendimentoe','enderecoe']);

        //dd($data);

        DB::beginTransaction();
        $insert  = Cliente::create($data);

        if ($data['idtipocliente']==1) {
            $neg = [
                'tiponegocio' => $negocio['tiponegocio'],
                'datainicio'  => $negocio['datainicio'],
                'capital'     => str_replace(',','',$negocio['capital']),
                'rendimento'  => str_replace(',','',$negocio['rendimento']),
                'nome'        => $negocio['nomeestab'],
                'endereco'    => $negocio['endereco'],
                'idcliente'   => $insert->idcliente
            ];
            $insertF = Negocio::create($neg);
        }else{
            $emp = [
                'profissao'  => $emprego['profissao'],
                'empresa'    => $emprego['empresa'],
                'rendimento' => str_replace(',','',$emprego['rendimentoe']),
                'endereco'   => $emprego['enderecoe'],
                'idcliente'  => $insert->idcliente
            ];
            $insertF = Emprego::create($emp);
        }

        if($insert && $insertF){
          DB::commit();
          return redirect()
                      ->route('cliente.create')
                      ->with('success',"Cliente Gravado com Sucesso!");
        }else{
          DB::rollBack();
          return redirect()
                        ->back()
                        ->with('error', 'Erro ao Gravar!');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $tipodocid   = Tipodocid::orderBy('descricao')->get();
        $tipocliente = Tipocliente::orderBy('descricao')->get();
        $cl          = Cliente::where('idcliente',$id)->get()->first();
        $neg         = Negocio::where('idcliente',$id)->orderBy('idnegocio')->get()->first();
        $empr        = Emprego::where('idcliente',$id)->orderBy('idemprego')->get()->first();
        $title       = 'Apagar Cliente';
        $delete      = true;
        return view('cliente.frmclientedelete', compact('title','tipodocid','tipocliente', 'cl', 'neg', 'empr', 'delete'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $tipodocid   = Tipodocid::orderBy('descricao')->get();
        $tipocliente = Tipocliente::orderBy('descricao')->get();
        $cl     = Cliente::where('idcliente',$id)->get()->first();
        //dd($cl);
        $neg    = Negocio::where('idcliente',$id)->orderBy('idnegocio')->get()->first();
        $empr   = Emprego::where('idcliente',$id)->orderBy('idemprego')->get()->first();
        $title = 'Editar Cliente';
        return view('cliente.frmcliente', compact('title','tipodocid','tipocliente', 'cl', 'neg', 'empr'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->except(['idcliente','_token','_method','tiponegocio','datainicio','capital','rendimento','nomeestab','endereco','profissao','empresa','rendimentoe','enderecoe']);
        $negocio = $request->only(['tiponegocio','datainicio','capital','rendimento','nomeestab','endereco']);
        $emprego = $request->only(['profissao','empresa','rendimentoe','enderecoe']);

        

        DB::beginTransaction();
        $insert  = Cliente::where('idcliente',$id)->update($data);

        if ($data['idtipocliente']==1) {
            $neg = [
                'tiponegocio' => $negocio['tiponegocio'],
                'datainicio'  => $negocio['datainicio'],
                'capital'     => str_replace(',','',$negocio['capital']),
                'rendimento'  => str_replace(',','',$negocio['rendimento']),
                'nome'        => $negocio['nomeestab'],
                'endereco'    => $negocio['endereco']
            ];
            $insertF = Negocio::where('idcliente',$id)->update($neg);
        }else{
            $emp = [
                'profissao'  => $emprego['profissao'],
                'empresa'    => $emprego['empresa'],
                'rendimento' => str_replace(',','',$emprego['rendimentoe']),
                'endereco'   => $emprego['enderecoe']
            ];
            $insertF = Emprego::where('idcliente',$id)->update($emp);
        }
        //dd($insertF);
        if($insert && $insertF){
          DB::commit();
          return redirect()
                      ->route('clientes')
                      ->with('success',"Cliente Atualizado com Sucesso!");
        }else{
          DB::rollBack();
          return redirect()
                        ->back()
                        ->with('error', 'Erro ao Atualizar!');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete = Cliente::where('idcliente',$id)->delete();
        
        if($delete)
            return redirect()
                            ->route('clientes')
                            ->with('success',"Cliente Apagado com Sucesso!");
        else
            return redirect()
                            ->route('cliente.show',$id)
                            ->with('error', "Erro ao Apagar!");
    }
}
