<?php

namespace App\Http\Controllers;
use App\Models\Empresa;
use App\Helpers\Helper;

use Illuminate\Http\Request;

class EmpresaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $emp = Empresa::first();
        $title = 'Atualizar Ficha da Empresa';
        return view('empresa', compact('title', 'emp'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data           = $request->all();
        $data['conta1'] = Helper::_trim($data['conta1'],'_');
        $data['nib1']   = Helper::_trim($data['nib1'],'_');
        $data['conta2'] = Helper::_trim($data['conta2'],'_');
        $data['nib2']   = Helper::_trim($data['nib2'],'_');
        $data['conta3'] = Helper::_trim($data['conta3'],'_');
        $data['nib3']   = Helper::_trim($data['nib3'],'_');

        $insert  = Empresa::create($data);
        if ($insert) {
            return redirect()
                      ->route('empresa')
                      ->with('success',"Dados Empresa Gravados com Sucesso!");
        }else{
            return redirect()
                        ->back()
                        ->with('error', 'Erro ao Gravar!');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       
        $data           = $request->except(['_token','_method']);
        $data['conta1'] = Helper::_trim($data['conta1'],'_');
        $data['nib1']   = Helper::_trim($data['nib1'],'_');
        $data['conta2'] = Helper::_trim($data['conta2'],'_');
        $data['nib2']   = Helper::_trim($data['nib2'],'_');
        $data['conta3'] = Helper::_trim($data['conta3'],'_');
        $data['nib3']   = Helper::_trim($data['nib3'],'_');

        $update  = Empresa::where('idempresa',$id)->update($data);
        if ($update) {
            return redirect()
                      ->route('empresa')
                      ->with('success',"Dados Empresa Atualizados com Sucesso!");
        }else{
            return redirect()
                        ->back()
                        ->with('error', 'Erro ao Atualizar!');
        }
    }
}
