<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Yajra\Datatables\Datatables;
use App\Models\Movimento;

class MovimentoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
        $query = "SELECT nome,apelido,deleted,num,valorprestacao, if(isnull(sum(valorpago)),0,valorpago) valorpago,idplanoamort,datapagar,(valorprestacao-if(isnull(sum(valorpago)),0,valorpago)) ppagar,origem,valortotal,idamort,prestacoes from (select nome,apelido,deleted,num,valorprestacao,sum(valor) valorpago,datapagar,planoamort.idplanoamort,origem,valortotal,idamort,prestacoes FROM movimento right join planoamort on movimento.idplanoamort=planoamort.idplanoamort join emprestimo on emprestimo.idemprestimo=planoamort.idemprestimo join cliente on cliente.idcliente=emprestimo.idcliente group by idplanoamort,num,origem having if(isnull(origem),'',origem)<>'JM' )t group by idplanoamort having (valorprestacao-valorpago)<>0 and deleted<>1 and t.idplanoamort=".$id;

        $emprestimo = DB::select($query);
        $emp = null;
        foreach ($emprestimo as $e) {
            $emp = $e;
        }
        $title      = 'Emitir Pagamento de Prestação';
        return view('movimento.pagamento', compact('title', 'emp'));
    }


    public function createJuros($id)
    {
        $query = "SELECT t.* from (SELECT nome,apelido,num,datapagar,datamov,valorprestacao,valortotal,idmovimento,(valortotal*0.05) juros,((valortotal*0.05)) valorjuros,movimento.idplanoamort,emprestimo.idamort,prestacoes FROM emprestimo inner join planoamort on emprestimo.idemprestimo=planoamort.idemprestimo inner join movimento on movimento.idplanoamort=planoamort.idplanoamort inner join cliente on cliente.idcliente=emprestimo.idcliente where (origem='PST' and idamort<>1 and datamov>datapagar and movimento.idplanoamort not in (select distinct idplanoamort from movimento where origem='JM'))union SELECT nome,apelido,num,datapagar,datamov,valorprestacao,valortotal,idmovimento,(valortotal*0.05) juros, ((valortotal*0.05)-(select sum((if(isnull(valor),0,valor))) from movimento where ltrim(rtrim(origem))=('JM') and movimento.idplanoamort=planoamort.idplanoamort)) valorjuros,movimento.idplanoamort,emprestimo.idamort,prestacoes FROM emprestimo inner join planoamort on emprestimo.idemprestimo=planoamort.idemprestimo inner join movimento on movimento.idplanoamort=planoamort.idplanoamort inner join cliente on cliente.idcliente=emprestimo.idcliente where (origem='JM' and ((valortotal-(select sum(if(isnull(valor),0,valor)) from movimento where origem='JM' and movimento.idplanoamort=planoamort.idplanoamort))>0)) group by movimento.idplanoamort)t where idplanoamort=".$id;

        $emprestimo = DB::select($query);
        $emp = null;
        foreach ($emprestimo as $e) {
            $emp = $e;
        }
        $title      = 'Emitir Pagamento de Juros de Mora';
        return view('movimento.pagamentojuros', compact('title', 'emp'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data                = $request->all();
        $data['valor']       = str_replace(',','',$data['valor']);
        $data['hora']        = date("H:i:s");
        $data['datasistema'] = date("Y-m-d H:i:s");

        if(Movimento::create($data)) {
            if($data['origem']=='PST')
                return redirect()
                    ->route("emprestimo.expedicao")
                    ->with("success", "Pagamento de Prestação Efetuado com Successo!");
            else
                return redirect()
                    ->route("emprestimo.juros")
                    ->with("success", "Pagamento de Juros de Mora Efetuado com Successo!"); 
        }else{
            return redirect()
                    ->back()
                    ->with("error", "Erro ao Gravar!");
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
