<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Yajra\Datatables\Datatables;
use App\Models\Taxajuro;

class TaxajuroController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       return view('taxajuro.lista');
    }

    public function getTaxajuro()
    {
        $query = "SELECT perc,idtaxajuro from taxajuro";

        $ta = DB::select($query);

        return Datatables::of($ta)->addColumn('action', function ($u) {
            return '<a href="'.route('taxajuro.edit',$u->idtaxajuro).'" class="btn btn-xs btn-primary" title="Editar"><i class="entypo-pencil"></i></a> <a href="'.route('taxajuro.delete', $u->idtaxajuro).'" class="btn btn-xs btn-danger" title="Apagar"><i class="entypo-trash"></i></a>';
            
        })->removeColumn('idtaxajuro')->make();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'Cadastrar Taxa de Juros';
        return view('taxajuro.frmtaxajuro', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data  = $request->all();
        $insert = Taxajuro::create($data);
        if ($insert) {
            return redirect()
                      ->route('taxajuros')
                      ->with('success',"Taxa de Juro Gravado com Sucesso!");
        }else{
            return redirect()
                        ->back()
                        ->with('error', 'Erro ao Gravar!');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $tjuro = Taxajuro::find($id);
        $title  = 'Atualizar Taxa de Juro';
        return view('taxajuro.frmtaxajuro', compact('tjuro','title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data  = $request->only(['perc']);
        $update = Taxajuro::where('idtaxajuro',$id)->update($data);
        if ($update) {
            return redirect()
                      ->route('taxajuros')
                      ->with('success',"Taxa de Juro Actualizada com Sucesso!");
        }else{
            return redirect()
                        ->back()
                        ->with('error', 'Erro ao Actualizar!');
        }
    }

    public function delete($id)
    {
        $tjuro = Taxajuro::find($id);
        $title  = 'Apagar Taxa de Juro';
        return view('taxajuro.taxajurodelete', compact('tjuro','title'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete = Taxajuro::where('idtaxajuro',$id)->delete();
        
        if($delete)
            return redirect()
                            ->route('taxajuros')
                            ->with('success',"Taxa de Juro Apagada com Sucesso!");
        else
            return redirect()
                            ->back()
                            ->with('error', "Erro ao Apagar!");
    }
}
