<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Yajra\Datatables\Datatables;
use App\Models\Taxaservico;

class TaxaservicoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       return view('taxaservico.lista');
    }

    public function getTaxaservico()
    {
        $query = "SELECT perc,idtaxaservico from taxaservico";

        $ta = DB::select($query);

        return Datatables::of($ta)->addColumn('action', function ($u) {
            return '<a href="'.route('taxaservico.edit',$u->idtaxaservico).'" class="btn btn-xs btn-primary" title="Editar"><i class="entypo-pencil"></i></a> <a href="'.route('taxaservico.delete', $u->idtaxaservico).'" class="btn btn-xs btn-danger" title="Apagar"><i class="entypo-trash"></i></a>';
            
        })->removeColumn('idtaxaservico')->make();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'Cadastrar Taxa de Serviço';
        return view('taxaservico.frmtaxaservico', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data  = $request->all();
        $insert = Taxaservico::create($data);
        if ($insert) {
            return redirect()
                      ->route('taxaservicos')
                      ->with('success',"Taxa de Serviço Gravado com Sucesso!");
        }else{
            return redirect()
                        ->back()
                        ->with('error', 'Erro ao Gravar!');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $tjuro = Taxaservico::find($id);
        $title  = 'Atualizar Taxa de Serviço';
        return view('taxaservico.frmtaxaservico', compact('tjuro','title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data  = $request->only(['perc']);
        $update = Taxaservico::where('idtaxaservico',$id)->update($data);
        if ($update) {
            return redirect()
                      ->route('taxaservicos')
                      ->with('success',"Taxa de Serviço Actualizada com Sucesso!");
        }else{
            return redirect()
                        ->back()
                        ->with('error', 'Erro ao Actualizar!');
        }
    }

    public function delete($id)
    {
        $tjuro = Taxaservico::find($id);
        $title  = 'Apagar Taxa de Serviço';
        return view('taxaservico.taxaservicodelete', compact('tjuro','title'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete = Taxaservico::where('idtaxaservico',$id)->delete();
        
        if($delete)
            return redirect()
                            ->route('taxaservicos')
                            ->with('success',"Taxa de Serviço Apagada com Sucesso!");
        else
            return redirect()
                            ->back()
                            ->with('error', "Erro ao Apagar!");
    }
}
