<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Yajra\Datatables\Datatables;
use App\Models\Tipodoc;

class TipoanexoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       return view('tipoanexo.lista');
    }

    public function getTipoanexo()
    {
        $query = "SELECT descricao,idtipodoc from tipodoc";

        $ta = DB::select($query);

        return Datatables::of($ta)->addColumn('action', function ($u) {
            return '<a href="'.route('tipoanexo.edit',$u->idtipodoc).'" class="btn btn-xs btn-primary" title="Editar Utilzador"><i class="entypo-pencil"></i></a> <a href="'.route('tipoanexo.delete', $u->idtipodoc).'" class="btn btn-xs btn-danger" title="Apagar"><i class="entypo-trash"></i></a>';
            
        })->removeColumn('idtipodoc')->make();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'Cadastrar Tipo de Anexo';
        return view('tipoanexo.frmtipoanexo', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data  = $request->all();
        $insert = Tipodoc::create($data);
        if ($insert) {
            return redirect()
                      ->route('tipoanexos')
                      ->with('success',"Tipo de Anexo Gravado com Sucesso!");
        }else{
            return redirect()
                        ->back()
                        ->with('error', 'Erro ao Gravar!');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $tanexo = Tipodoc::find($id);
        $title  = 'Atualizar Tipo de Anexo';
        return view('tipoanexo.frmtipoanexo', compact('tanexo','title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data  = $request->only(['descricao']);
        $update = Tipodoc::where('idtipodoc',$id)->update($data);
        if ($update) {
            return redirect()
                      ->route('tipoanexos')
                      ->with('success',"Tipo de Anexo Actualizado com Sucesso!");
        }else{
            return redirect()
                        ->back()
                        ->with('error', 'Erro ao Actualizar!');
        }
    }

    public function delete($id)
    {
        $tanexo = Tipodoc::find($id);
        $title  = 'Apagar Tipo de Anexo';
        return view('tipoanexo.tipoanexodelete', compact('tanexo','title'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete = Tipodoc::where('idtipodoc',$id)->delete();
        
        if($delete)
            return redirect()
                            ->route('tipoanexos')
                            ->with('success',"Tipo de Anexo Apagado com Sucesso!");
        else
            return redirect()
                            ->back()
                            ->with('error', "Erro ao Apagar!");
    }
}
