@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="index.html"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Clientes</li>
<li>Listagem</li>
<li>Lista de Avalista</li>
<li class="active">
	<strong>Cadastrar</strong>
</li>
@endsection
@section('content')
<div class="row">	
	<div class="col-md-12">	
		@include('layout.alerts')
        @if(isset($cl))
        	<form role="form" class="form-horizontal" method="post" action="{{route('avalista.update',$cl->idavalista)}}" enctype="multipart/form-data">
          		{!! method_field('put') !!}
        @else
			<form role="form" class="form-horizontal" method="post" action="{{route('avalista.store')}}" enctype="multipart/form-data">	
		@endif 
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong>{{ $title }}</strong>
				</div>
			</div>			
			<div class="panel-body">				
					
				{!! csrf_field() !!} 

				<input type="hidden" class="form-control" id="idcliente" name="idcliente" value="{{$cl->idcliente ?? $idcliente}}">
				<div class="row"> 
					<div class="col-md-6">
						<div class="row">
							<div class="col-md-8">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Nome *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="nome" name="nome" placeholder="Nome do Avalista" required value="{{$cl->nome ?? null}}">
									</div>
									
								</div>		
							</div>
							<div class="col-md-4">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Apelido *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="apelido" name="apelido" placeholder="Apelido" required value="{{$cl->apelido ?? null}}">
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-4">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Género *</label>
									<div class="col-md-12">
										<select class="selectboxit" name="sexo" id="sexo" style="width: 100%;" required>
										  <option value="" >Seleccione</option>
										  <option value="Masculino" @if(isset($cl->sexo) && $cl->sexo== 'Masculino') selected="true" @endif>Masculino</option>
										  <option value="Feminino" @if(isset($cl->sexo) && $cl->sexo == 'Feminino') selected="true" @endif>Feminino</option>
										  <option value="Outro" @if(isset($cl->sexo) && $cl->sexo == 'Outro') selected="true" @endif >Outro</option>
										</select>
									</div>
									
								</div>		
							</div>
							<div class="col-md-4">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Data de Nascimento *</label>
									<div class="col-md-12">
										<input type="date" id="datanasc" name="datanasc" class="form-control datepicker" required value="{{$cl->datanasc ?? null}}">
									</div>
								</div>
							</div>
							<div class="col-md-4">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Estado Civil *</label>
									<div class="col-md-12">
										<select class="selectboxit" name="ecivil" id="ecivil" style="width: 100%;" required>
										  <option value="">Seleccione</option>
										  <option value="Casado(a)" @if(isset($cl->ecivil) && $cl->ecivil== 'Casado(a)') selected="true" @endif>Casado(a)</option>
										  <option value="Divorciado(a)" @if(isset($cl->ecivil) && $cl->ecivil== 'Divorciado(a)') selected="true" @endif>Divorciado(a)</option>
										  <option value="Solteiro(a)" @if(isset($cl->ecivil) && $cl->ecivil== 'Solteiro(a)') selected="true" @endif>Solteiro(a)</option>
										  <option value="Viúvo(a)" @if(isset($cl->ecivil) && $cl->ecivil== 'Viúvo(a)') selected="true" @endif>Viúvo(a)</option>
										</select>
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Pai *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="pai" name="pai" placeholder="Nome do Pai" required value="{{$cl->pai ?? null}}">
									</div>
									
								</div>		
							</div>
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Mãe *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="mae" name="mae" placeholder="Nome da Mãe" required value="{{$cl->mae ?? null}}">
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-12">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Morada *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="morada" name="morada" placeholder="Endereço do Avalista" required value="{{$cl->morada ?? null}}">
									</div>								
								</div>		
							</div>
						</div>
						
					</div>
					<div class="col-md-6">	
						<div class="row">
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Nacionalidade *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="nacionalidade" name="nacionalidade" placeholder="Nacionalidade" required value="{{$cl->nacionalidade ?? null}}">
									</div>
									
								</div>		
							</div>
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Naturalidade *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="naturalidade" name="naturalidade" placeholder="Naturalidade" required value="{{$cl->naturalidade ?? null}}">
									</div>
								</div>
							</div>
						</div>	
						<div class="row">
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Celular *</label>
									<div class="col-md-12">
										<input type="text" data-mask="(+258) 99 999 9999" class="form-control" id="celular" name="celular" placeholder="Celular" required value="{{$cl->celular ?? null}}">
									</div>
									
								</div>		
							</div>
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Celular Alternativo *</label>
									<div class="col-md-12">
										<input type="text" data-mask="(+258) 99 999 9999" class="form-control" id="celular2" name="celular2" placeholder="Celular Alternativo" required value="{{$cl->celular2 ?? null}}">
									</div>
								</div>
							</div>
						</div>	
						<div class="row">
							<div class="col-md-12">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Email</label>
									<div class="col-md-12">
										<input type="email" class="form-control" id="email" name="email" placeholder="Email" value="{{$cl->email ?? null}}">
									</div>
								</div>
							</div>
						</div>

					</div>	
				</div>
				<div class="col-md-12 badge badge-roundless">
					<strong class="pull-left"> Dados de Identificação</strong>
				</div>
				<div class="row">
					<div class="col-md-6">
						<div class="row">
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Tipo Doc. Identificação *</label>
									<div class="col-md-12">
										<select class="selectboxit" name="idtipodocid" id="idtipodocid" style="width: 100%;" required>
										  <option value="" selected="selected" >Seleccione</option>
										  @foreach($tipodocid as $t)
										  	<option value="{{ $t->idtipodocid}}" @if(isset($cl->idtipodocid) && $cl->idtipodocid== $t->idtipodocid) selected="true" @endif >{{ $t->descricao}}</option>
										  @endforeach
										</select>
									</div>
									
								</div>		
							</div>
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">N&ordm; Doc. Identificação *</label>
									<div class="col-md-12">
										<input type="text" class="form-control"  id="nodocid" name="nodocid" placeholder="Número do Documento de Identificação" required value="{{$cl->nodocid ?? null}}">
									</div>
								</div>
							</div>
						</div>	
						<div class="row">
							<div class="col-md-12">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Local de Emissão *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="localemissao" name="localemissao" placeholder="Local de Emissão" required value="{{$cl->localemissao ?? null}}">
									</div>
								</div>
							</div>
						</div>		
					</div>
					<div class="col-md-6">
						<div class="row">
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Data de Emissão *</label>
									<div class="col-md-12">
										<input type="date" id="dataemissao" name="dataemissao" class="form-control" required value="{{$cl->dataemissao ?? null}}" >
									</div>
								</div>
							</div>
							<div class="col-md-6">								
								<div class="form-group has-info">
									<label class="control-label col-md-12">Data de Validade *</label>
									<div class="col-md-12">
										<input type="date" id="datavalidade" name="datavalidade" class="form-control" required value="{{$cl->datavalidade ?? null}}" >
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-12">
								<div class="form-group has-info">
									<label class="control-label col-md-12">NUIT *</label>
									<div class="col-md-12">
										<input type="text" data-mask="99999999999" class="form-control" id="nuit" name="nuit" placeholder="NUIT" required value="{{$cl->nuit ?? null}}">
									</div>								
								</div>		
							</div>
						</div>
					</div>
				</div>
				<div class="col-md-12 badge badge-roundless">
					<strong class="pull-left"> Negócio/Emprego</strong>					
				</div>
				<div class="row">
					<div class="col-md-6">
						<div class="form-group has-info">
							<label class="control-label col-md-12">Tipo de Cliente *</label>
							<div class="col-md-6">
								<select class="selectboxit" name="tipotrabalho" id="tipotrabalho" style="width: 100%;" required>
								  <option value="" >Seleccione</option>
								  <option value="Comerciante" @if(isset($cl->tipotrabalho) && $cl->tipotrabalho== "Comerciante") selected="true" @endif >Comerciante</option>
								  <option value="Doméstico(a)" @if(isset($cl->tipotrabalho) && $cl->tipotrabalho== "Doméstico(a)") selected="true" @endif >Doméstico(a)</option>
								  <option value="Funcionário(a)" @if(isset($cl->tipotrabalho) && $cl->tipotrabalho== "Funcionário(a)") selected="true" @endif >Funcionário(a)</option>
								</select>
							</div>
						</div>
					</div>
				</div>
				<div class="row" id="negocio">
					<div class="col-md-6">						
						<div class="row">
							<div class="col-md-12">
								<div class="row">
									<div class="col-md-12">
										<div class="form-group has-info">
											<label class="control-label col-md-12">Tipo de Negócio *</label>
											<div class="col-md-12">
												<input type="text" class="form-control" id="tiponegocio" name="tiponegocio" placeholder="Tipo de Negócio" value="{{$neg->tiponegocio ?? null}}">
											</div>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-md-12">
										<div class="form-group has-info">
											<label class="control-label col-md-12">Data de Início de Actividade</label>
											<div class="col-md-12">
												<input type="date" id="datainicio" name="datainicio" class="form-control" value="{{$neg->datainicio ?? null}}" >
											</div>
										</div>
									</div>
								</div>
							</div>

						</div>
					</div>
					<div class="col-md-6">
						<div class="row">
							<div class="col-md-12">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Mercado(Estabelecimento) *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="nomeestab" name="nomeestab" placeholder="Nome do Mercado ou Estabelecimento" value="{{$neg->nome ?? null}}" >
									</div>								
								</div>		
							</div>
							<div class="col-md-12">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Endereço *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="endereco" name="endereco" placeholder="Endereço do Estabelecimento" value="{{$neg->endereco ?? null}}" >
									</div>								
								</div>		
							</div>
						</div>
					</div>
				</div>
				<div class="row" id="emprego">
					<div class="col-md-6">						
						<div class="row">
							<div class="col-md-12">
								<div class="row">
									<div class="col-md-12">
										<div class="form-group has-info">
											<label class="control-label col-md-12">Profissão *</label>
											<div class="col-md-12">
												<input type="text" class="form-control" id="profissao" name="profissao" placeholder="Profissão" value="{{$empr->profissao ?? null}}" >
											</div>
										</div>
									</div>
									<div class="col-md-12">								
										<div class="form-group has-info">
											<label class="control-label col-md-12">Empresa *</label>
											<div class="col-md-12">
												<input type="text" class="form-control" id="empresa" name="empresa" placeholder="Empresa onde Trabalha" value="{{$empr->empresa ?? null}}" >
											</div>
										</div>
									</div>
								</div>
							</div>

						</div>
					</div>
					<div class="col-md-6">						
						<div class="row">
							<div class="col-md-12">								
								<div class="form-group has-info">
									<label class="control-label col-md-12">Endereço *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="enderecoe" name="enderecoe" placeholder="Endereço do Empresa" value="{{$empr->endereco ?? null}}" >
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>			
							
			<div class="panel-footer">
				<button type="submit" id="gravar" class="btn btn-success">
					<i class="fa fa-save"></i> Gravar
				</button> 
			</div>
			</form>	
		</div>
	
	</div>
</div>
@endsection

@section('js')
<script>		
	$(document).ready(function(){
		
		$('#emprego').hide();
		$('#negocio').hide();
		if($('#tipotrabalho').val()=='')
			$('#gravar').prop('disabled', true);
		
		$('#tipotrabalho').change(function(e){
			var tipotrabalho = $('#tipotrabalho').val();
			//alert(idtipocliente);
			if(tipotrabalho=='Comerciante'){
				$('#negocio').show();
				$('#emprego').hide();
				$('#gravar').prop('disabled', false);
				document.getElementById("tiponegocio").setAttribute("required", "required");
				document.getElementById("nomeestab").setAttribute("required", "required");
				document.getElementById("endereco").setAttribute("required", "required");

				$('#profissao').removeAttr('required');
				$('#empresa').removeAttr('required');
				$('#enderecoe').removeAttr('required');
			}else{
				if(tipotrabalho=='Funcionário(a)'){
					$('#emprego').show();
					$('#negocio').hide();
					$('#gravar').prop('disabled', false);
					document.getElementById("profissao").setAttribute("required", "required");
					document.getElementById("empresa").setAttribute("required", "required");
					document.getElementById("enderecoe").setAttribute("required", "required");

					$('#tiponegocio').removeAttr('required');
					$('#nomeestab').removeAttr('required');
					$('#rendimento').removeAttr('required');
					$('#endereco').removeAttr('required');
				}else{
					if(tipotrabalho=='Doméstico(a)'){
						$('#emprego').hide();
						$('#negocio').hide();
					}else{
					    $('#profissao').removeAttr('required');
				        $('#empresa').removeAttr('required');
				        $('#enderecoe').removeAttr('required');
				        
				        $('#tiponegocio').removeAttr('required');
					    $('#nomeestab').removeAttr('required');
					    $('#rendimento').removeAttr('required');
					    $('#endereco').removeAttr('required');
				        
						$('#emprego').hide();
						$('#negocio').hide();
						$('#gravar').prop('disabled', false);
					}					
				}				
			}
		});

		//VERIFICA TIPO DE TRABALHO NO UPDATE
		var tipotrabalho = $('#tipotrabalho').val();
		//alert(idtipocliente);
		if(tipotrabalho=='Comerciante'){
			$('#negocio').show();
			$('#emprego').hide();
			$('#gravar').prop('disabled', false);
		}else{
			if(tipotrabalho=='Funcionário(a)'){
				$('#emprego').show();
				$('#negocio').hide();
				$('#gravar').prop('disabled', false);
			}else{
				if(tipotrabalho=='Doméstico(a)'){
					$('#emprego').hide();
					$('#negocio').hide();
					$('#gravar').prop('disabled', false);
				}else{
					$('#emprego').hide();
					$('#negocio').hide();
					$('#gravar').prop('disabled', false);
				}
			}				
		}
	});
</script>
@endsection