@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="index.html"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Clientes</li>
<li class="active">
	<strong>Cadastrar</strong>
</li>
@endsection
@section('content')
<div class="row">	
	<div class="col-md-12">	
		@include('layout.alerts')
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong>{{ $title }}</strong>
				</div>
			</div>			
			<div class="panel-body">				
				<form role="form" class="form-horizontal">	
				{!! csrf_field() !!} 
				<div class="row"> 
					<div class="col-md-6">
						<div class="row">
							<div class="col-md-8">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Nome *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="nome" name="nome" placeholder="Nome do Avalista" required value="{{$cl->nome ?? null}}" readonly>
									</div>
									
								</div>		
							</div>
							<div class="col-md-4">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Apelido *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="apelido" name="apelido" placeholder="Apelido" required value="{{$cl->apelido ?? null}}" readonly>
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-4">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Género *</label>
									<div class="col-md-12">
										<select class="selectboxit" name="sexo" id="sexo" style="width: 100%;" required disabled="true">
										  <option value="" >Seleccione</option>
										  <option value="Masculino" @if(isset($cl->sexo) && $cl->sexo== 'Masculino') selected="true" @endif>Masculino</option>
										  <option value="Feminino" @if(isset($cl->sexo) && $cl->sexo == 'Feminino') selected="true" @endif>Feminino</option>
										  <option value="Outro" @if(isset($cl->sexo) && $cl->sexo == 'Outro') selected="true" @endif >Outro</option>
										</select>
									</div>
									
								</div>		
							</div>
							<div class="col-md-4">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Data de Nascimento *</label>
									<div class="col-md-12">
										<input type="date" id="datanasc" name="datanasc" class="form-control datepicker" required value="{{$cl->datanasc ?? null}}" readonly>
									</div>
								</div>
							</div>
							<div class="col-md-4">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Estado Civil *</label>
									<div class="col-md-12">
										<select class="selectboxit" name="ecivil" id="ecivil" style="width: 100%;" required disabled="true">
										  <option value="">Seleccione</option>
										  <option value="Casado(a)" @if(isset($cl->ecivil) && $cl->ecivil== 'Casado(a)') selected="true" @endif>Casado(a)</option>
										  <option value="Divorciado(a)" @if(isset($cl->ecivil) && $cl->ecivil== 'Divorciado(a)') selected="true" @endif>Divorciado(a)</option>
										  <option value="Solteiro(a)" @if(isset($cl->ecivil) && $cl->ecivil== 'Solteiro(a)') selected="true" @endif>Solteiro(a)</option>
										  <option value="Viúvo(a)" @if(isset($cl->ecivil) && $cl->ecivil== 'Viúvo(a)') selected="true" @endif>Viúvo(a)</option>
										</select>
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Pai *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="pai" name="pai" placeholder="Nome do Pai" required value="{{$cl->pai ?? null}}" readonly>
									</div>
									
								</div>		
							</div>
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Mãe *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="mae" name="mae" placeholder="Nome da Mãe" required value="{{$cl->mae ?? null}}" readonly>
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-12">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Morada *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="morada" name="morada" placeholder="Endereço do Avalista" required value="{{$cl->morada ?? null}}" readonly>
									</div>								
								</div>		
							</div>
						</div>
						
					</div>
					<div class="col-md-6">	
						<div class="row">
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Nacionalidade *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="nacionalidade" name="nacionalidade" placeholder="Nacionalidade" required value="{{$cl->nacionalidade ?? null}}" readonly>
									</div>
									
								</div>		
							</div>
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Naturalidade *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="naturalidade" name="naturalidade" placeholder="Naturalidade" required value="{{$cl->naturalidade ?? null}}" readonly>
									</div>
								</div>
							</div>
						</div>	
						<div class="row">
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Celular *</label>
									<div class="col-md-12">
										<input type="text" data-mask="(+258) 99 999 9999" class="form-control" id="celular" name="celular" placeholder="Celular" required value="{{$cl->celular ?? null}}" readonly>
									</div>
									
								</div>		
							</div>
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Celular Alternativo *</label>
									<div class="col-md-12">
										<input type="text" data-mask="(+258) 99 999 9999" class="form-control" id="celular2" name="celular2" placeholder="Celular Alternativo" required value="{{$cl->celular2 ?? null}}" readonly>
									</div>
								</div>
							</div>
						</div>	
						<div class="row">
							<div class="col-md-12">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Email</label>
									<div class="col-md-12">
										<input type="email" class="form-control" id="email" name="email" placeholder="Email" value="{{$cl->email ?? null}}" readonly>
									</div>
								</div>
							</div>
						</div>

					</div>	
				</div>
				<div class="col-md-12 badge badge-roundless">
					<strong class="pull-left"> Dados de Identificação</strong>
				</div>
				<div class="row">
					<div class="col-md-6">
						<div class="row">
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Tipo Doc. Identificação *</label>
									<div class="col-md-12">
										<select class="selectboxit" name="idtipodocid" id="idtipodocid" style="width: 100%;" required disabled="true">
										  <option value="" selected="selected" >Seleccione</option>
										  @foreach($tipodocid as $t)
										  	<option value="{{ $t->idtipodocid}}" @if(isset($cl->idtipodocid) && $cl->idtipodocid== $t->idtipodocid) selected="true" @endif >{{ $t->descricao}}</option>
										  @endforeach
										</select>
									</div>
									
								</div>		
							</div>
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">N&ordm; Doc. Identificação *</label>
									<div class="col-md-12">
										<input type="text" class="form-control"  id="nodocid" name="nodocid" placeholder="Número do Documento de Identificação" required value="{{$cl->nodocid ?? null}}" readonly>
									</div>
								</div>
							</div>
						</div>	
						<div class="row">
							<div class="col-md-12">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Local de Emissão *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="localemissao" name="localemissao" placeholder="Local de Emissão" required value="{{$cl->localemissao ?? null}}" readonly>
									</div>
								</div>
							</div>
						</div>		
					</div>
					<div class="col-md-6">
						<div class="row">
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Data de Emissão *</label>
									<div class="col-md-12">
										<input type="date" id="dataemissao" name="dataemissao" class="form-control" required value="{{$cl->dataemissao ?? null}}" readonly >
									</div>
								</div>
							</div>
							<div class="col-md-6">								
								<div class="form-group has-info">
									<label class="control-label col-md-12">Data de Validade *</label>
									<div class="col-md-12">
										<input type="date" id="datavalidade" name="datavalidade" class="form-control" required value="{{$cl->datavalidade ?? null}}" readonly >
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-12">
								<div class="form-group has-info">
									<label class="control-label col-md-12">NUIT *</label>
									<div class="col-md-12">
										<input type="text" data-mask="99999999999" class="form-control" id="nuit" name="nuit" placeholder="NUIT" required value="{{$cl->nuit ?? null}}" readonly>
									</div>								
								</div>		
							</div>
						</div>
					</div>
				</div>
				<div class="col-md-12 badge badge-roundless">
					<strong class="pull-left"> Negócio/Emprego</strong>					
				</div>
				<div class="row">
					<div class="col-md-6">
						<div class="form-group has-info">
							<label class="control-label col-md-12">Tipo de Cliente *</label>
							<div class="col-md-6">
								<select class="selectboxit" name="tipotrabalho" id="tipotrabalho" style="width: 100%;" required>
								  <option value="" >Seleccione</option>
								  <option value="Comerciante" @if(isset($cl->tipotrabalho) && $cl->tipotrabalho== "Comerciante") selected="true" @endif >Comerciante</option>
								  <option value="Doméstico(a)" @if(isset($cl->tipotrabalho) && $cl->tipotrabalho== "Doméstico(a)") selected="true" @endif >Doméstico(a)</option>
								  <option value="Funcionário(a)" @if(isset($cl->tipotrabalho) && $cl->tipotrabalho== "Funcionário(a)") selected="true" @endif >Funcionário(a)</option>
								</select>
							</div>
						</div>
					</div>
				</div>
				<div class="row" id="negocio">
					<div class="col-md-6">						
						<div class="row">
							<div class="col-md-12">
								<div class="row">
									<div class="col-md-12">
										<div class="form-group has-info">
											<label class="control-label col-md-12">Tipo de Negócio *</label>
											<div class="col-md-12">
												<input type="text" class="form-control" id="tiponegocio" name="tiponegocio" placeholder="Tipo de Negócio" value="{{$neg->tiponegocio ?? null}}" readonly>
											</div>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-md-6">
										<div class="form-group has-info">
											<label class="control-label col-md-12">Data de Início de Actividade</label>
											<div class="col-md-12">
												<input type="date" id="datainicio" name="datainicio" class="form-control" value="{{$neg->datainicio ?? null}}" readonly >
											</div>
										</div>
									</div>
								</div>
							</div>

						</div>
					</div>
					<div class="col-md-6">
						<div class="row">
							<div class="col-md-12">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Mercado(Estabelecimento) *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="nomeestab" name="nomeestab" placeholder="Nome do Mercado ou Estabelecimento" value="{{$neg->nome ?? null}}" readonly >
									</div>								
								</div>		
							</div>
							<div class="col-md-12">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Endereço *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="endereco" name="endereco" placeholder="Endereço do Estabelecimento" value="{{$neg->endereco ?? null}}" readonly >
									</div>								
								</div>		
							</div>
						</div>
					</div>
				</div>
				<div class="row" id="emprego">
					<div class="col-md-6">						
						<div class="row">
							<div class="col-md-12">
								<div class="row">
									<div class="col-md-12">
										<div class="form-group has-info">
											<label class="control-label col-md-12">Profissão *</label>
											<div class="col-md-12">
												<input type="text" class="form-control" id="profissao" name="profissao" placeholder="Profissão" value="{{$empr->profissao ?? null}}" readonly >
											</div>
										</div>
									</div>
									<div class="col-md-12">								
										<div class="form-group has-info">
											<label class="control-label col-md-12">Empresa *</label>
											<div class="col-md-12">
												<input type="text" class="form-control" id="empresa" name="empresa" placeholder="Empresa onde Trabalha" value="{{$empr->empresa ?? null}}" readonly >
											</div>
										</div>
									</div>
								</div>
							</div>

						</div>
					</div>
					<div class="col-md-6">						
						<div class="row">
							<div class="col-md-12">								
								<div class="form-group has-info">
									<label class="control-label col-md-12">Endereço *</label>
									<div class="col-md-12">
										<input type="text" class="form-control" id="enderecoe" name="enderecoe" placeholder="Endereço do Empresa" value="{{$empr->endereco ?? null}}" readonly >
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>			
							
			<div class="panel-footer">
				<button type="button" id="limpar" class="btn btn-danger"  data-toggle="modal" data-target="#confirm"><i class="fa fa-trash"></i> Apagar Cliente</button> 
			</div>
			</form>	

			<div class="modal fade" id="confirm" tabindex="-1" role="dialog" aria-labelledby="confirmLabel" aria-hidden="true">
			  	<div class="modal-dialog modal-sm" role="document">
					<div class="modal-content">
					  <div class="modal-header header-red" style=" background-color: #dc3545; color: #fff; text-align:center;">
						<h5 class="modal-title" id="confirmLabel">Alerta</h5>
						<button class="close" type="button" data-dismiss="modal" aria-label="Close">
						  <span aria-hidden="true">×</span>
						</button>
					  </div>
					  <div class="modal-body"><strong>Deseja realmente Apagar esse Avalista?</strong></div>
					  <div class="modal-footer">
					  		<button class="btn btn-secondary" type="button" data-dismiss="modal">Não</button>
					  		<a href="{{ route('avalista.delete', $cl->idavalista ?? null)}}" title="">
							<button type="submit" class="btn btn-success">Sim</button>
							</a>
						
					  </div>
					</div>
			    </div>
			</div>
		</div>
	
	</div>
</div>
@endsection

@section('js')
<script>		
	$(document).ready(function(){		
		$('#emprego').hide();
		$('#negocio').hide();
		if($('#tipotrabalho').val()=='')
			$('#gravar').prop('disabled', true);
		
		$('#tipotrabalho').change(function(e){
			var tipotrabalho = $('#tipotrabalho').val();
			if(tipotrabalho=='Comerciante'){
				$('#negocio').show();
				$('#emprego').hide();
				$('#gravar').prop('disabled', false);
				document.getElementById("tiponegocio").setAttribute("required", "required");
				document.getElementById("nomeestab").setAttribute("required", "required");
				document.getElementById("endereco").setAttribute("required", "required");

				$('#profissao').removeAttr('required');
				$('#empresa').removeAttr('required');
				$('#enderecoe').removeAttr('required');
			}else{
				if(tipotrabalho=='Funcionário(a)'){
					$('#emprego').show();
					$('#negocio').hide();
					$('#gravar').prop('disabled', false);
					document.getElementById("profissao").setAttribute("required", "required");
					document.getElementById("empresa").setAttribute("required", "required");
					document.getElementById("enderecoe").setAttribute("required", "required");

					$('#tiponegocio').removeAttr('required');
					$('#nomeestab').removeAttr('required');
					$('#rendimento').removeAttr('required');
					$('#endereco').removeAttr('required');
				}else{
					if(tipotrabalho=='Doméstico(a)'){
						$('#emprego').hide();
						$('#negocio').hide();
					}else{
						$('#emprego').hide();
						$('#negocio').hide();
						$('#gravar').prop('disabled', true);
					}					
				}				
			}
		});

		//VERIFICA TIPO DE TRABALHO NO UPDATE
		var tipotrabalho = $('#tipotrabalho').val();
		//alert(idtipocliente);
		if(tipotrabalho=='Comerciante'){
			$('#negocio').show();
			$('#emprego').hide();
			$('#gravar').prop('disabled', false);
		}else{
			if(tipotrabalho=='Funcionário(a)'){
				$('#emprego').show();
				$('#negocio').hide();
				$('#gravar').prop('disabled', false);
			}else{
				if(tipotrabalho=='Doméstico(a)'){
					$('#emprego').hide();
					$('#negocio').hide();
					$('#gravar').prop('disabled', false);
				}else{
					$('#emprego').hide();
					$('#negocio').hide();
					$('#gravar').prop('disabled', true);
				}
			}				
		}
	});
</script>
@endsection