@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="#"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Créditos</li>
<li class="active">
	<strong>Listagem</strong>
</li>
@endsection
@section('content')

<div class="row">	
  @if(isset($cl))
    <div class="col-md-12">
      <a  href="{{ route('clientes') }}" class="btn btn-info">
        <i class="entypo-to-start"></i> Voltar
      </a> <br><br> 
    </div>
  @endif
	<div class="col-md-12">
		<h3>{{ "Cliente: ".$cl->nome.' '.$cl->apelido}}</h3>
	</div>
	<div class="col-md-12">
		@include('layout.alerts')	
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong>Lista de Créditos</strong>
				</div>
			</div>			
			<div class="panel-body">								
				<div class="col-md-12">	
					<table class="table table-striped table-bordered _datatable_" id="clientes_table">
						<thead>
							<th>Crédito</th>
              <th>N&ordm; Prestações</th>
              <th>Amortização</th>
              <th>Taxa Juros (%)</th>
              <th>Taxa Serviço</th>
              <th>Data Início</th>
              <th class="noExport">Acção</th>
						</thead>
						<tbody>
						</tbody>
					</table>		
				</div>						
			</div>
		</div>
	
	</div>
</div>
@endsection

@section('js')
<script>
      $('#clientes_table').DataTable({
          processing: true,
          serverSide: true,
          responsive: true,
          dom: 'lBfrtip',
          search: {
            "case-insensitive": true
          },
          ajax: '{!! route('getcreditos', $cl->idcliente) !!}',
          columns: [
            { data: 'credito', name: 'credito' },
            { data: 'prestacoes', name: 'prestacoes' },
            { data: 'valorprest', name: 'valorprest' },
            { data: 'taxajuros', name: 'taxajuros' },
            { data: 'taxaservico', name: 'taxaservico' },
            { data: 'datainicio', name: 'datainicio' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
          ],
          buttons: [
              {
                extend: 'excel',
                title: 'Lista de Créditos',
                text: '<i class="fa fa-file-excel-o" style="font-size:20px; color: green"></i>',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                }
              },
              {
                extend: 'pdf',
                title: 'Lista de Créditos',
                text: '<i class="fa fa-file-pdf-o" style="font-size:20px; color: red"></i>',
                orientation: 'landscape',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                },
              },
              {
                text: '<i class="fa fa-refresh" style="font-size:20px"></i>',
                action: function ( e, dt, node, config ) {
                    dt.ajax.reload();
                }
              }
          ],
          language: {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "Nenhum registo encontrado",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "Sem registros disponíveis",
            "infoFiltered": "(filtrado de _MAX_ registros totais)",    
            "loadingRecords": "Carregando...",
            "processing":     "Processando...",
            "search":         "Pesquisar:",
            "paginate": {
              "first":      "Primeiro",
              "last":       "Último",
              "next":       "Próximo",
              "previous":   "Anterior"
            },
          }          
      });
</script>
@endsection