@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="{{ route('home') }}"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li class="active">
	<strong>Ficha da Empresa</strong>
</li>
@endsection
@section('content')
<div class="row">	
	<div class="col-md-12">	
		@include('layout.alerts')
        @if(isset($emp))
        	<form method="post" action="{{route('empresa.update',$emp->idempresa)}}" enctype="multipart/form-data">
          	{!! method_field('put') !!}
        @else
			<form role="form" class="form-horizontal" method="post" action="{{route('empresa.store')}}" enctype="multipart/form-data">	
		@endif 
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong>Dados da Empresa</strong>
				</div>
			</div>			
			<div class="panel-body">				
					
					{!! csrf_field() !!}  				
					<div class="row">
						<div class="col-md-6">					
							<div class="form-group has-info">
								<label for="nomeemp" class="control-label">Nome da Empresa</label>
								<input type="text" class="form-control" id="nomeemp" name="nomeemp" placeholder="Nome da Empresa" value="{{ $emp->nomeemp }}" required>
							</div>	
							<div class="row">
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">Sigla</label>
										<input id="idempresa" name="idempresa" type="hidden" class="form-control" value="{{ $emp->idempresa }}">
										<input type="text" class="form-control" id="sigla" name="sigla" placeholder="Sigla da Empresa" value="{{ $emp->sigla }}">
									</div>		
								</div>
								<div class="col-md-8">
									<div class="form-group has-info">
										<label class="control-label">Localidade</label>
										<input type="text" class="form-control" id="localidade" name="localidade" placeholder="Localdidade da Empresa" value="{{ $emp->localidade }}">
									</div>
								</div>
							</div>				
							<div class="form-group has-info">
								<label class="control-label">Endereço</label>
								<input type="text" class="form-control" id="mora" name="mora" placeholder="Morada da Empresa" value="{{ $emp->mora }}" >
							</div>
							<div class="row">
								<div class="col-md-6">
									<div class="form-group has-info">
										<label class="control-label">Telefone</label>
										<input type="text" class="form-control" data-mask="(+258) 99 999 999" id="tel" name="tel" placeholder="Telefone da Empresa" value="{{ $emp->tel }}" >
									</div>		
								</div>
								<div class="col-md-6">
									<div class="form-group has-info">
										<label class="control-label">Fax</label>
										<input type="text" class="form-control" data-mask="(+258) 99 999 999" id="fax" name="fax" placeholder="Fax da Empresa" value="{{ $emp->fax }}" >
									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">Celular</label>
										<input type="text" class="form-control" data-mask="(+258) 99 999 9999" id="cel" name="cel" placeholder="Celular da Empresa" value="{{ $emp->cel }}">
									</div>		
								</div>
								<div class="col-md-8">
									<div class="form-group has-info">
										<label class="control-label">Email</label>
										<input type="email" class="form-control" id="mail" name="mail" placeholder="Email da Empresa" value="{{ $emp->mail }}" >
									</div>
								</div>
							</div>
						</div>
						<div class="col-md-6">	
							<div class="row">
								<div class="col-md-8">
									<div class="form-group has-info">
										<label class="control-label">Website</label>
										<input type="text" class="form-control" id="website" name="website" placeholder="Website da Empresa" value="{{ $emp->website }}" >
									</div>		
								</div>
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">NUIT</label>
										<input type="text" data-mask="99999999999" class="form-control" id="nuitt" name="nuitt" placeholder="NUIT da Empresa" value="{{ $emp->nuitt }}">
									</div>
								</div>
							</div>	
							<div class="row">
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">Banco 1</label>
										<input type="text" class="form-control" id="banco1" name="banco1" placeholder="Nome do Banco 1" value="{{ $emp->banco1 }}">
									</div>		
								</div>
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">N&ordm; de Conta 1</label>
										<input type="text" data-mask="9999999999999999999999999999"  class="form-control" id="conta1" name="conta1" placeholder="N&ordm; Conta 1" value="{{ $emp->conta1 }}" >
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">NIB 1</label>
										<input type="text" class="form-control" data-mask="9999999999999999999999999999" id="nib1" name="nib1" placeholder="NIB da Conta 1" value="{{ $emp->nib1 }}" >
									</div>		
								</div>
							</div>	
							<div class="row">
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">Banco 2</label>
										<input type="text" class="form-control" id="banco2" name="banco2" placeholder="Nome do Banco 2" value="{{ $emp->banco2 }}" >
									</div>		
								</div>
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">N&ordm; de Conta 2</label>
										<input type="text" data-mask="9999999999999999999999999999"  class="form-control" id="conta2" name="conta2" placeholder="N&ordm; Conta 2" value="{{ $emp->conta2 }}">
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">NIB 2</label>
										<input type="text" class="form-control" data-mask="9999999999999999999999999999" id="nib2" name="nib2" placeholder="NIB da Conta 2" value="{{ $emp->nib2 }}" >
									</div>		
								</div>
							</div>	
							<div class="row">
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">Banco 3</label>
										<input type="text" class="form-control" id="banco3" name="banco3" placeholder="Nome do Banco 1" value="{{ $emp->banco3 }}" >
									</div>		
								</div>
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label2">N&ordm; de Conta 3</label>
										<input type="text" data-mask="9999999999999999999999999999"  class="form-control" id="conta3" name="conta3" placeholder="N&ordm; Conta 3" value="{{ $emp->conta3 }}" >
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group has-info">
										<label class="control-label">NIB 3</label>
										<input type="text" class="form-control" data-mask="9999999999999999999999999999" id="nib3" name="nib3" placeholder="NIB da Conta 3" value="{{ $emp->nib3 }}" >
									</div>		
								</div>
							</div>
							<div class="row">
								<div class="col-md-6">
									<div class="form-group has-info">
										<label class="control-label">Comissão de Gestores (%)</label>
										<input data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="10" type="text" class="form-control" id="comissao" name="comissao" placeholder="Comissão de Gestores" value="{{ $emp->comissao }}" >
									</div>		
								</div>								
							</div>
						</div>
					</div>			
							
			</div>
			<div class="panel-footer">
				<button type="submit" id="gravar" class="btn btn-success">
					<i class="fa fa-save"></i> Gravar
				</button>    
			</div>
			</form>	
		</div>
	
	</div>
</div>
@endsection

@section('js')

@endsection