@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="{{ route('home') }}"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Créditos</li>
<li>Listagem</li>
<li class="active">
	<strong>Visualizar Crédito</strong>
</li>
@endsection
@section('content')
<div class="row">	
	<div class="col-md-12">
		@foreach($emprestimo as $t)
		<a  href="{{ route('emprestimos') }}" class="btn btn-info">
			<i class="entypo-to-start"></i> Voltar
		</a> 

		@if(isset($delete))
			<button type="button" id="del" class="btn btn-danger"  data-toggle="modal" data-target="#confirm">
				<i class="entypo-trash"></i> Apagar Crédito
			</button>
			<form action="{{ route("emprestimo.destroy", $t->idemprestimo) }}" method="get" accept-charset="utf-8">
				<div class="modal fade" id="confirm" tabindex="-1" role="dialog" aria-labelledby="confirmLabel" aria-hidden="true">
					<div class="modal-dialog modal-sm" role="document">
						<div class="modal-content">
						  <div class="modal-header header-red" style=" background-color: #dc3545; color: #fff; text-align:center;">
							<h5 class="modal-title" id="confirmLabel">Alerta</h5>
							<button class="close" type="button" data-dismiss="modal" aria-label="Close">
							  <span aria-hidden="true">×</span>
							</button>
						  </div>
						  <div class="modal-body"><strong>Deseja realmente apagar este crédito?</strong></div>
						  <div class="modal-footer">
							<button class="btn btn-secondary" type="button" data-dismiss="modal">Não</button>
							<button  type="submit" class="btn btn-success">Sim 
							</button>
						  </div>
						</div>
					</div>
				</div>
			</form>
			

		@else
			<a class="btn btn-warning" id="plano" href="{{url('/').'/reports/planoAmortizacao.php?recordID='.$t->idemprestimo}}" target="_blank">
				<i class="fa fa-table"></i> Plano de Amortização
			</a> 
			<a class="btn btn-orange" id="extrato" title="Extracto de Pagamento" href="{{ url('/').'/reports/extrato.php?recordID='.$t->idemprestimo }}" target="_blank">
				<i class="fa fa-reorder"></i> Extracto
			</a> 
			@if(auth()->user()->perfil == 'ADMIN')
		<a id="pagar" class="btn btn-primary" title="Efectuar Pagamento" href="{{ route('emprestimo.expedicaodet',$t->idemprestimo) }}">
					<i class="fa fa-money"></i> Pagar Prestações
				</a> 
				<button type="button" id="garant" class="btn btn-danger"  data-toggle="modal" data-target="#confirmGarantia">
					<i class="fa fa-power-off"></i> Accionar Garantia
				</button> 
			@endif
			
			<a id="print" class="btn btn-success" title="Imprimir Dados do Crédito" href="{{url('/').'/reports/credito.php?recordID='.$t->idemprestimo }}" target="_blank">
				<i class="fa fa-print"></i> Imprimir
			</a>
		@endif

		<br /><br />

		@endforeach
	</div>
	<div class="col-md-12">	
		@include('layout.alerts')
		<form role="form" class="form-horizontal">	
			<div class="panel panel-primary" data-collapsed="0">		
				<div class="panel-heading ">
					<div class="panel-title">
						<strong>{{ $title }}</strong>
					</div>
				</div>			
				<div class="panel-body">
					@foreach($emprestimo as $e)	
						<div class="col-md-12 badge badge-roundless">
							<br><strong class="pull-left"> 1. Dados do Principais</strong><br><br>
						</div> 				
						<div class="row">
							<div class="col-md-4">
								<p><strong>Cliente: </strong>{{ $e->nome.' '.$e->apelido }}</p>
								<p><strong>Valor Embolsado: </strong>{{ number_format($e->credito,2).' MT' }}</p>
								<p><strong>Valor por Desembolsar: </strong>{{ number_format($e->valortotal,2).' MT'}}</p>
							</div>
							<div class="col-md-4">
								<p><strong>Plano de Amortização: </strong>{{ $e->planoamortizacao }}</p>
								<p><strong>N&ordm; de Prestações: </strong>{{ $e->prestacoes }}</p>
								<p><strong>Valor de Amortização: </strong>{{ number_format($e->valorprest,2).' MT'}}</p>
								@if($e->accgarant == 1)
									<p>
										<strong style="color: red">Garantia accionada em: </strong>
										{{ date("d-m-Y...H:i:s",strtotime($e->dataalterado)) }}
									</p>
								@endif
							</div>
							<div class="col-md-4">
								<p><strong>Data do 1&ordm; Pagamento: </strong>{{ $e->datainicio }}</p>
								<p><strong>Taxa de Juros: </strong>{{ number_format($e->taxajuros,2).' %' }}</p>
								<p><strong>Taxa de Serviço: </strong>{{ number_format($e->taxaservico,2).' MT'}}</p>
								@if($e->accgarant == 1)
									<p>
										<strong style="color: red">Observação: </strong>
										{{ $e->obs }}
									</p>
								@endif
							</div>
						</div>	
						<div class="col-md-12 badge badge-roundless">
							<br><strong class="pull-left"> 2. Garantias Bancárias</strong><br><br>
						</div>				
						<div class="row">
							@if(count($garantias)>0)
								<div class="col-md-12">
									<br>
									<table class="table table-bordered table-striped">
										<thead>
										  <th width="60%">Identificação do Bem</th>
										  <th width="20%">Valor Atribuido</th>
										</thead>
										<tbody>
											@foreach($garantias as $g)
												<tr>
													<td>{{ $g->bem }}</td>
													<td>{{ $g->valor }}</td>
												</tr>
											@endforeach
										</tbody>
									</table>
								</div>
							@else
								<div class="col-md-12 text-center ">
									<p>
										<strong style="color: red">SEM GARANTIAS CADASTRADAS</strong>
									</p>
								</div>
							@endif
						</div>	
						<div class="col-md-12 badge badge-roundless">
							<br><strong class="pull-left"> 3. Anexos</strong><br><br>
						</div>				
						<div class="row">
							@if(count($anexos)>0)
								<div class="col-md-12">
									<br>
									<table class="table table-bordered table-striped">
										<thead>
										  <th width="60%">Tipo de Documento</th>
										  <th width="20%">Acção</th>
										</thead>
										<tbody>
											@foreach($anexos as $a)
												<tr>
													<td>{{ $a->descricao }}</td>
													<td>
														<a class="btn btn-white btn-sm" href="{{ $url.$a->path }}" target="_blank" title=" Visualizar/Baixar"><i class="entypo-eye"></i></a>
													</td>
												</tr>
											@endforeach
										</tbody>
									</table>
								</div>
							@else
								<div class="col-md-12 text-center ">
									<p>
										<strong style="color: red;">SEM ANEXOS</strong>
									</p>
								</div>								
							@endif
						</div>
					@endforeach					
				</div>	
			</div>
		</form>
	</div>
</div>
@endsection

@section('js')
<script>

@endsection