@extends('layout.master')
@section('breadcrumb')
<li>
	<a href="{{ route('home') }}"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Créditos</li>
<li class="active">
	<strong>Listagem</strong>
</li>
@endsection
@section('content')

<div class="row">	
	<div class="col-md-12">
		<a  href="{{ route('emprestimo.create') }}" class="btn btn-info"><i class="fa fa-plus-circle"></i> Novo Crédito</a><br /><br />
	</div>
	<div class="col-md-12">
		@include('layout.alerts')	
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong>Lista de Créditos</strong>
				</div>
			</div>			
			<div class="panel-body">								
				<div class="col-md-12">	
					<table class="table table-striped table-bordered _datatable_" id="clientes_table">
						<thead>
							<th width="15%">Nome</th>
              <th>Apelido</th>
							<th>Crédito</th>
              <th>N&ordm; Prest.</th>
              <th>Plano&nbsp;Amort.</th>
              <th>Amortização</th>
              <th>Taxa Juros (%)</th>
              <th>Data Início</th>
              <th class="noExport">Acção</th>
						</thead>
						<tbody>
						</tbody>
					</table>		
				</div>						
			</div>
		</div>
	
	</div>
</div>
@endsection

@section('js')
<script>
      $('#clientes_table').DataTable({
          processing: true,
          serverSide: true,
          responsive: true,
          dom: 'lBfrtip',
          search: {
            "case-insensitive": true
          },
          ajax: '{!! route('getemprestimos') !!}',
          columns: [
            { data: 'nome', name: 'nome' },
            { data: 'apelido', name: 'apelido' },
            { data: 'credito', name: 'credito' },
            { data: 'prestacoes', name: 'prestacoes' },
            { data: 'descricao', name: 'descricao' },
            { data: 'valorprest', name: 'valorprest' },
            { data: 'taxajuros', name: 'taxajuros' },
            { data: 'datainicio', name: 'datainicio' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
          ],
          buttons: [
              {
                extend: 'excel',
                title: 'Lista de Créditos',
                text: '<i class="fa fa-file-excel-o" style="font-size:20px; color: green"></i>',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                }
              },
              {
                extend: 'pdf',
                title: 'Lista de Créditos',
                text: '<i class="fa fa-file-pdf-o" style="font-size:20px; color: red"></i>',
                orientation: 'landscape',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                },
              },
              {
                text: '<i class="fa fa-refresh" style="font-size:20px"></i>',
                action: function ( e, dt, node, config ) {
                    dt.ajax.reload();
                }
              }
          ],
          language: {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "Nenhum registo encontrado",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "Sem registros disponíveis",
            "infoFiltered": "(filtrado de _MAX_ registros totais)",    
            "loadingRecords": "Carregando...",
            "processing":     "Processando...",
            "search":         "Pesquisar:",
            "paginate": {
              "first":      "Primeiro",
              "last":       "Último",
              "next":       "Próximo",
              "previous":   "Anterior"
            },
          }          
      });
</script>
@endsection