
<?php $__env->startSection('breadcrumb'); ?>
<li>
	<a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Créditos</li>
<li class="active">
	<strong>Novo Crédito</strong>
</li>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="row">
	<?php if(isset($emp)): ?>
		<div class="col-md-12">
			<a  href="<?php echo e(route('emprestimos')); ?>" class="btn btn-info">
				<i class="entypo-to-start"></i> Voltar
			</a> <br><br>	
		</div>
	<?php endif; ?>	
	<div class="col-md-12">	
		<?php echo $__env->make('layout.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php if(isset($emp)): ?>
        	<form role="form" class="form-horizontal" method="post" action="<?php echo e(route('emprestimo.update',$emp->idemprestimo)); ?>" enctype="multipart/form-data">
          	<?php echo method_field('put'); ?>

        <?php else: ?>
			<form role="form" class="form-horizontal" method="post" action="<?php echo e(route('emprestimo.store')); ?>" enctype="multipart/form-data">	
		<?php endif; ?> 
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong><?php echo e($title); ?></strong>
				</div>
			</div>			
			<div class="panel-body">				
					
				<?php echo csrf_field(); ?>


				<input type="hidden" name="idutilizador" value="<?php echo e(auth()->user()->idutilizador); ?>">
				<input type="hidden" name="datacriado" value="<?php echo e(date("Y-m-d H:i:s")); ?>">  				
				<div class="row">
					<div class="col-md-6">
						<div class="row">
							<div class="col-md-12">
								<div class="form-group has-info">
								    <label class="control-label col-md-12">Cliente</label>
								    <div class="col-md-12">
								        <select class="select2" name="idcliente" id="idcliente" style="width: 100%;" required>
									        <option value="" selected="selected" >Seleccione</option>
									        <?php $__currentLoopData = $cl; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									  	        <option value="<?php echo e($c->idcliente); ?>" <?php if(isset($emp->idcliente) && $emp->idcliente== $c->idcliente): ?> selected="true" <?php endif; ?> ><?php echo e($c->nome.' '.$c->apelido); ?></option>
									        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									   </select>
								    </div>									
							    </div>
							</div>								
						</div>
						<div class="row">
							<div class="col-md-4">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Valor do Crédito</label>
									<div class="col-md-12">
										<input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" id="credito" name="credito" placeholder="Valor do Empréstimo" value="<?php echo e($emp->credito ?? 0); ?>" required onBlur="defineAmortizacao();" onKeyup="fill();" >
									</div>
								</div>
							</div>
							<div class="col-md-4">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Plano de Amortização</label>
									<div class="col-md-12">
										<select class="selectboxit" name="idamort" id="idamort" style="width: 100%;" required onChange="defineAmortizacao();">
									        <option value="" selected="selected" >Seleccione</option>
									        <?php $__currentLoopData = $amort; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									  	        <option value="<?php echo e($a->idamort); ?>" <?php if(isset($emp->idamort) && $emp->idamort== $a->idamort): ?> selected="true" <?php endif; ?> ><?php echo e($a->descricao); ?></option>
									        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									   </select>
									</div>
								</div>
							</div>
							<div class="col-md-4">
								<div class="form-group has-info">
									<label class="control-label col-md-12">N&ordm; de Prestações</label>
									<div class="col-md-12">
										<input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="" data-rad="" maxlength="2" class="form-control" id="prestacoes" name="prestacoes" placeholder="N&ordm; de Prestações" value="<?php echo e($emp->prestacoes ?? null); ?>" required onBlur="defineAmortizacao();">
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Data de Início de Pagamento</label>
									<div class="col-md-12">
										<input type="date" id="datainicio" name="datainicio" class="form-control" value="<?php echo e($emp->datainicio ?? null); ?>" required >
									</div>
								</div>
							</div>
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Data de Desembolso</label>
									<div class="col-md-12">
										<input type="date" id="datadesembolso" name="datadesembolso" class="form-control" value="<?php echo e($emp->datadesembolso ?? null); ?>" required >
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-md-6">
						<div class="row">
							<div class="col-md-6">
								<div class="form-group has-info">
								    <label class="control-label col-md-12">Taxa de Serviço (MT)</label>
								    <div class="col-md-12">
								        <select class="selectboxit" name="taxaservico" id="taxaservico" style="width: 100%;" required >
									        <option value="" selected="selected" >Seleccione</option>
									        <?php $__currentLoopData = $taxaservico; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									  	        <option value="<?php echo e($t->perc); ?>" <?php if(isset($emp->taxaservico) && $emp->taxaservico== $t->perc): ?> selected="true" <?php endif; ?> ><?php echo e($t->perc); ?></option>
									        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									   </select>
								    </div>									
							    </div>
							</div>	
							<div class="col-md-6">
								<div class="form-group has-info">
								    <label class="control-label col-md-12">Taxa de Juros (%)</label>
								    <div class="col-md-12">
								        <select class="selectboxit" name="taxajuros" id="taxajuros" style="width: 100%;" required onchange="defineAmortizacao();">
									        <option value="" selected="selected" >Seleccione</option>
									        <?php $__currentLoopData = $taxajuro; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									  	        <option value="<?php echo e($t->perc); ?>" <?php if(isset($emp->taxajuros) && $emp->taxajuros== $t->perc): ?> selected="true" <?php endif; ?> ><?php echo e($t->perc); ?></option>
									        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									   </select>
								    </div>									
							    </div>
							</div>							
						</div>
						<div class="row">
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Valor Total</label>
									<div class="col-md-12">
										<input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" id="valortotal" name="valortotal" value="<?php echo e($emp->valortotal ?? null); ?>" readonly >
									</div>
								</div>
							</div>
							<div class="col-md-6">
								<div class="form-group has-info">
									<label class="control-label col-md-12">Valor de Amortização</label>
									<div class="col-md-12">
										<input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" id="valorprest" name="valorprest" value="<?php echo e($emp->valorprest ?? null); ?>" readonly >
									</div>
								</div>
							</div>
						</div>
					</div>						
				</div>	
				<div class="col-md-12 badge badge-roundless">
					<strong class="pull-left"> Garantias</strong>
				</div>	
				<div class="row">
					<div class="col-md-2" style="margin-left: 0px; margin-top:10px">
						<button type="button" name="addGarant" id="addGarant" class="btn btn-info btn-sm" onClick="addGarantia();"><i class="fa fa-plus"></i> Garantia</button>
					 </div>
					 <!--Tabela e a Modal de Anexos-->
				</div>	
				<div class="row">
					<div class="col-md-12">
						<table id="garant" class="table table-hover">
							<tr>
							  <th>Identificação do Bem</th>
							  <th>Valor Atribuído</th>
							  <th>Acção</th>
							</tr>
							<?php if(isset($garantias)): ?>
								<?php $__currentLoopData = $garantias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $q): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<td>
											<input id="descricaodoc" type="text" name="beml[]" value="<?php echo e($q->bem); ?>" class="form-control" />  
											<input type="hidden" name="update[]" value="true">  
											<input type="hidden" name="idgarantia[]" value="<?php echo e($q->idgarantia); ?>">
										</td>
										<td>
											<input id="path" type="text" name="valorl[]" value="<?php echo e($q->valor); ?>" class="form-control" />
										</td>
										<td>
											<button class="btn btn-danger btn-sm" onclick="removeLinha(this)" type="button" value="<?php echo e($q->idgarantia); ?>" title="Remover Linha"><i class="entypo-trash"></i></button>
										</td>
									</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							<?php endif; ?>
						</table>
					</div>
					<div class="col-md-12" id="deleteds"></div>
				</div>
				<div class="col-md-12 badge badge-roundless">
					<strong class="pull-left"> Anexos</strong>
				</div>
				<div class="row">
					<div class="col-md-2" style="margin-left: 0px; margin-top:10px">
						<button type="button" name="addDocs" id="addDocs" class="btn btn-info btn-sm"  data-toggle="modal" data-target="#modal-docs"><i class="fa fa-plus"></i> Anexo</button>
					</div>
				</div>
				<div class="row">
					<div class="col-md-12">
						<table id="docs" class="table table-hover">
							<tr>
							  <th>Tipo de Anexo</th>
							  <th>Ficheiro</th>
							  <th>Acção</th>
							</tr>
							<?php if(isset($anexos)): ?>
								<?php $__currentLoopData = $anexos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $q): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<td>
											<input id="descricaodoc" type="text" name="descricaodocL[]" readonly value="<?php echo e($q->descricao); ?>" class="form-control" />
											<input type="hidden" name="new[]" value="false"> 
											<input type="hidden" name="update2[]" value="true"> 
											<input type="hidden" name="idanexo[]" value="<?php echo e($q->idanexo); ?>">
										</td>
										<td>
											<input id="path" type="text" name="pathL[]" value="<?php echo e($q->path); ?>" readonly class="form-control" placeholder="<?php echo e($q->path); ?>" />
										</td>
										<td>
											<button class="btn btn-danger btn-sm" onclick="removeLinha2(this)" type="button" value="<?php echo e($q->idanexo); ?>" title="Remover Linha"><i class="entypo-trash"></i></button> <a class="btn btn-primary " href="<?php echo e($url.$q->path); ?>" target="_blank" title=" Visualizar/Baixar"><i class="entypo-eye"></i></a>
										</td>
									</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							<?php endif; ?>
						</table>	
					</div>
					<div class="modal fade" id="modal-docs">
						<div class="modal-dialog">
							<div class="modal-content">
							  <div class="modal-header">
								<button type="button" class="close" data-dismiss="modal" aria-label="Close">
								  <span aria-hidden="true">&times;</span></button>
								<h4 class="modal-title">Anexo de Documentos</h4>
							  </div>
							  <div class="modal-body">
								<div class="col-md-12">
								  <div class="form-group">
									<label>Tipo</label>
									 <select class="selectboxit" name="tipodoc" id="tipodoc" style="width: 100%;">
									    <option value="" selected="selected">Seleccione</option>
									 	<?php $__currentLoopData = $tipodoc; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<option value="<?php echo e($t->descricao); ?>"><?php echo e($t->descricao); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
								  </div>
								  <!-- /.form-group -->
								</div>
								<!-- /.col -->
							  </div>
							  <div class="modal-footer">
								<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
								<button type="button" class="btn btn-info" onClick="addAnexos();">Adicionar</button>
							  </div>
							</div>
							<!-- /.modal-content -->
						</div>
					</div>
					<input type="hidden" id="credito2">
					<input type="hidden" id="valortotal2">
					<div class="col-md-12" id="deleteds2"></div>
				</div>
							
			</div>
			<div class="panel-footer">
				<button type="submit" id="gravar" class="btn btn-success">
					<i class="fa fa-save"></i> Gravar
				</button>    
			</div>
			</form>	
		</div>
	
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
function fill(){
	var valor = $('#credito').val().replace(',','');
	$('#credito2').val(valor.replace(',',''));
}

$(document).ready(function(){
	$('#credito').focus(function(){
		if($('#credito').val()==0){
				$('#credito').val('');
		}
	});
});
//Calcula o valor total a pagar no emprestimo
function calculaValorTotal(){
	var idamort    = $('#idamort').val();
	var prestacoes = 1;
	if(idamort == 1){
		prestacoes = parseFloat($('#prestacoes').val())/30;
	}
	if(idamort == 2){
		prestacoes = parseFloat($('#prestacoes').val())/4;
	}
	if(idamort == 3){
		prestacoes = parseFloat($('#prestacoes').val());
	}
	var cred      = parseFloat($('#credito2').val().replace(',',''));
	var taxajuros = parseFloat($('#taxajuros').val());
	var valortot  = Math.round(cred+((cred*(taxajuros/100))*prestacoes));
	$('#valortotal2').val(valortot);
	valortot      = new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(valortot);
	cred          = new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(cred);
	$('#credito').val(cred);
	$('#valortotal').val(valortot);
}
//Define o plano de amortização e calcula o valor da prestação
function defineAmortizacao(){
	calculaValorTotal();
	var idamort    = $('#idamort').val();
	var valorprest = 0;
	var npres      = 1;
	npres          = $('#prestacoes').val();
	valorprest     = Math.ceil(parseFloat($('#valortotal2').val().replace(',',''))/npres);
	valorprest     = new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(valorprest);
	$('#valorprest').val(valorprest);
}

(function($) {
    removeLinha = function(item) {
      var idgarantia = $(item).val();
      var idgarantias = '';
      var tr = $(item).closest('tr');
      var deleteds = '';
      deleteds += '<input type="hidden" name="deleteds[]" readonly value="'+idgarantia+'" class="form-control" />';
      $("#deleteds").append(deleteds);

      tr.fadeOut(400, function() {
        tr.remove();  
      });
      
      return false;
    }
 })(jQuery);

//GRID DE GARANTIAS
(function($) {
	addGarantia = function() {
	var newRow = $("<tr>");
	var cols = "";
	cols += '<td><textarea id="bem" name="bem[]" class="form-control" rows="2" placeholder="Descrição do Bem" style="resize:none;"></textarea></td>';
	cols += '<td style="max-width: 100px"><input id="valor" name="valor[]"  type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" /><input type="hidden" name="new[]" value="true"></td>';
	cols += '<td>';
	cols += '<button class="btn btn-danger btn-sm" onclick="removeLinha(this)" type="button" title="Remover Linha"><i class="entypo-trash"></i></button>';
	cols += '</td></tr>';

	newRow.append(cols);
	$("#garant").append(newRow);

	return false;
	}
})(jQuery);

(function($) {
    removeLinha2 = function(item) {
      var idanexo = $(item).val();
      var idanexos = '';
      var tr = $(item).closest('tr');
      var deleteds2 = '';
      deleteds2 += '<input type="text" name="deleteds2[]" readonly value="'+idanexo+'" class="form-control" />';
      $("#deleteds2").append(deleteds2);

      tr.fadeOut(400, function() {
        tr.remove();  
      });
      
      return false;
    }
})(jQuery);
  
//GRID DE ANEXOS
(function($) {
    addAnexos = function() {
    var tipodoc=document.getElementById('tipodoc').value;
    //var pathA=document.getElementById('pathA').value;
    if(tipodoc==''){
      alert("Selecione um tipo de Documento");
      return false;
    }
    var newRow = $("<tr>");
    var cols = "";
    cols += '<td><input id="descricaodoc" type="text" name="descricaodoc[]" readonly value="'+tipodoc+'" class="form-control" /><input type="hidden" name="new2[]" value="true"><input type="hidden" name="update2[]" value="false"><input type="hidden" name="idanexo[]" value=""><input type="hidden" name="update2[]" value="false"> </td>';
    cols += '<td><input id="path" type="file" name="path[]" readonly class="form-control" /></td>';
    cols += '<td>';
    cols += '<button class="btn btn-danger btn-sm" onclick="removeLinha2(this)" type="button" title="Remover Linha"><i class="entypo-trash"></i></button>';
    cols += '</td></tr>';

    newRow.append(cols);
    $("#docs").append(newRow);

    return false;
    }
})(jQuery); 

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jtmccomz/public_html/smartechmz/jtmc/resources/views/emprestimo/frmemprestimo.blade.php ENDPATH**/ ?>