<?php $__env->startSection('breadcrumb'); ?>
<li>
	<a href="#"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Relatórios</li>
<li class="active">
	<strong>Çréditos Não Liquidados</strong>
</li>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="row">	
	<div class="col-md-12">
		<?php echo $__env->make('layout.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>	
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong>Lista de Çréditos Não Liquidados</strong>
				</div>
			</div>			
			<div class="panel-body">								
				<div class="col-md-12">	
					<table class="table table-striped table-bordered _datatable_" id="clientes_table">
						<thead>
							<th>Nome</th>
              <th>Apelido</th>
              <th>Crédito</th>
              <th>Total Pagar</th>
              <th>Total Pago</th>
              <th>Nº Prest.</th>
              <th>Amortização</th>
              <th>Taxa Juros (%)</th>
              <th>Taxa Serviço (MT)</th>
              <th>Data Desembolso</th>
              <th>Data Início</th>
              <th class="noExport">Acção</th>
						</thead>
						<tbody>
						</tbody>
					</table>		
				</div>						
			</div>
		</div>
	
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
      $('#clientes_table').DataTable({
          processing: true,
          serverSide: true,
          responsive: true,
          dom: 'lBfrtip',
          search: {
            "case-insensitive": true
          },
          ajax: '<?php echo route('getcreditosnaoliq'); ?>',
          columns: [
            { data: 'nome', name: 'nome' },
            { data: 'apelido', name: 'apelido' },
            { data: 'credito', name: 'credito' },
            { data: 'valortotal', name: 'valortotal' },
            { data: 'valor', name: 'valor' },
            { data: 'prestacoes', name: 'prestacoes' },
            { data: 'descricao', name: 'descricao' },
            { data: 'taxajuros', name: 'taxajuros' },
            { data: 'taxaservico', name: 'taxaservico' },
            { data: 'datadesembolso', name: 'datadesembolso' },
            { data: 'datainicio', name: 'datainicio' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
          ],
          order: [[0, 'asc']],
          buttons: [
              {
                extend: 'excel',
                title: 'Lista de Créditos Não Liquidados',
                text: '<i class="fa fa-file-excel-o" style="font-size:20px; color: green"></i>',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                }
              },
              {
                extend: 'pdf',
                title: 'Lista de Créditos Não Liquidados',
                text: '<i class="fa fa-file-pdf-o" style="font-size:20px; color: red"></i>',
                orientation: 'landscape',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                },
              },
              {
                text: '<i class="fa fa-refresh" style="font-size:20px"></i>',
                action: function ( e, dt, node, config ) {
                    dt.ajax.reload();
                }
              }
          ],
          language: {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "Nenhum registo encontrado",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "Sem registros disponíveis",
            "infoFiltered": "(filtrado de _MAX_ registros totais)",    
            "loadingRecords": "Carregando...",
            "processing":     "Processando...",
            "search":         "Pesquisar:",
            "paginate": {
              "first":      "Primeiro",
              "last":       "Último",
              "next":       "Próximo",
              "previous":   "Anterior"
            },
          }          
      });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp73\htdocs\smartechmz\jtmc\resources\views/relatorios/listacreditosnaoliq.blade.php ENDPATH**/ ?>