<?php $__env->startSection('content_header'); ?>
    <h1><?php echo e($titulo); ?></h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  <div class="box box-success">
    <div class="box-header">
      <a class="btn btn-warning" href="<?php echo e(route('conflito.lista')); ?>">
        <i class="fa fa-step-backward"></i> Voltar
      </a>
    </div>
    <div class="box-body">
        <?php if(isset($conflito)): ?>
        <form method="post" action="<?php echo e(route('conflito.update',$conflito->idconflito)); ?>">
          <?php echo method_field('put'); ?>

        <?php else: ?>
          <form method="post" action="<?php echo e(route('conflito.store')); ?>">
        <?php endif; ?>      
        <?php echo csrf_field(); ?>  
        <div class="box-body">
          <div class="row">
            <div class="well well-sm"><strong>1. Dados do Principais</strong></div>
          </div>
          <!--/Row-->
          <div class="row">
            <div class="col-md-6">
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="numero">Número</label>
                    <input type="text" name="numero" class="form-control input-sm" value="<?php echo e($conflito->numero ?? $maxno); ?>" readonly>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="numprocesso">Número de Processo</label>
                    <input type="text" name="numprocesso" class="form-control input-sm" value="<?php echo e($conflito->numprocesso ?? null); ?>">
                    <input type="hidden" name="datastamp" class="form-control input-sm" value="<?php echo e($conflito->datastamp ?? date('Y-m-d')); ?>">
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="data">Data do Conflito</label>
                    <input type="date" name="data" class="form-control input-sm" value="<?php echo e($conflito->data ?? null); ?>" required>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="formareport">Forma de Reporte do Conflito</label>
                    <select name="formareport" id="formareport" class="form-control select2 input-sm" required>
                      <option value=""> --Selecione-- </option>
                      <?php $__currentLoopData = $formareport; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($fr->descricao); ?>" <?php if(isset($conflito) && $conflito->formareport==$fr->descricao): ?> selected <?php endif; ?>><?php echo e($fr->descricao); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                  </div>
                </div>
              </div>
              <div class="form-group">
                <label for="causa">Causa do Conflito</label>
                <select name="causa" id="causa" class="form-control select2 input-sm" required>
                  <option value=""> --Selecione-- </option>
                  <?php $__currentLoopData = $causa; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($c->descricao); ?>" <?php if(isset($conflito) && $conflito->causa==$c->descricao): ?> selected <?php endif; ?>><?php echo e($c->descricao); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
            </div>
            <div class="col-md-6">
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="proveniencia">Proveniência</label>
                    <select name="proveniencia" id="proveniencia" class="form-control select2 input-sm" required>
                      <option value=""> --Selecione-- </option>
                      <?php $__currentLoopData = $proveniencia; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($pr->descricao); ?>" <?php if(isset($conflito) && $conflito->proveniencia==$pr->descricao): ?> selected <?php endif; ?>><?php echo e($pr->descricao); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="idprovincia">Província</label>
                    <select name="idprovincia" id="idprovincia" class="form-control select2 input-sm" required>
                      <option value=""> --Selecione-- </option>
                      <?php $__currentLoopData = $provincias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prov): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($prov->idprovincia); ?>" <?php if(isset($conflito) && $conflito->idprovincia==$prov->idprovincia): ?> selected <?php endif; ?>><?php echo e($prov->provincia); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="iddistrito">Distrito</label>
                    <select name="iddistrito" id="iddistrito" class="form-control select2 input-sm" required>
                      <?php if(isset($conflito)): ?>
                        <?php $__currentLoopData = $distritos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <option value="<?php echo e($dist->iddistrito); ?>" <?php if($dist->iddistrito==$conflito->iddistrito): ?> selected <?php endif; ?>> <?php echo e($dist->distrito); ?> </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      <?php else: ?>
                        <option value=""> --Selecione-- </option>
                      <?php endif; ?>
                    </select>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="idpostoadm">Posto Administrativo</label>
                    <select name="idpostoadm" id="idpostoadm" class="form-control select2 input-sm">
                      <?php if(isset($conflito)): ?>
                        <?php $__currentLoopData = $postos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <option value="<?php echo e($p->idpostoadm); ?>" <?php if($p->idpostoadm==$conflito->idpostoadm): ?> selected <?php endif; ?>> <?php echo e($p->postoadm); ?> </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      <?php else: ?>
                        <option value=""> --Selecione-- </option>
                      <?php endif; ?>
                    </select>
                  </div>
                </div>
              </div>
              <div class="form-group">
                <label for="obs">Observações</label>
                <textarea class="form-control input-sm" rows="1" name="obs"><?php echo e($conflito->obs ?? ''); ?></textarea>
              </div>
            </div>
          </div>
          <!--/Row-->
          <div class="row">
            <div class="well well-sm"><strong>2. Dados dos Reclamante e Reclamado</strong></div>
          </div>
          <!--/Row-->
          <div class="row">
            <div class="col-md-6">
              <strong style="color:red">I. Reclamante</strong>
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="tiporeclamante">Tipo de Reclamante</label>
                    <select name="tiporeclamante" id="tiporeclamante" class="form-control select2 input-sm" required>
                      <option value=""> --Selecione-- </option>
                      <option <?php if(isset($conflito) && $conflito->tiporeclamante=='Singular'): ?> selected <?php endif; ?>>Pessoa Singular</option>
                      <option <?php if(isset($conflito) && $conflito->tiporeclamante=='Pessoa Colectiva'): ?> selected <?php endif; ?>>Pessoa Colectiva</option>
                    </select>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="generoreclamante">Género</label>
                    <select name="generoreclamante" id="generoreclamante" class="form-control select2 input-sm">
                      <option value=""> --Selecione-- </option>
                      <option <?php if(isset($conflito) && $conflito->generoreclamante=='Masculino'): ?> selected <?php endif; ?>>Masculino</option>
                      <option <?php if(isset($conflito) && $conflito->generoreclamante=='Feminino'): ?> selected <?php endif; ?>>Feminino</option>
                    </select>
                  </div>
                </div>
              </div>
              <!--/Row-->
              <div class="form-group">
                <label for="nomereclamante">Nome Completo</label>
                <input class="form-control input-sm" type="text" name="nomereclamante" value="<?php echo e($conflito->nomereclamante ?? null); ?>">
              </div>
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="contactoreclamante">Contacto</label>
                    <input class="form-control input-sm" type="text" name="contactoreclamante" value="<?php echo e($conflito->contactoreclamante ?? null); ?>">
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="outroreclamante">Outros</label>
                    <input class="form-control input-sm" type="text" name="outroreclamante" value="<?php echo e($conflito->outroreclamante ?? null); ?>">
                  </div>
                </div>
              </div>
              <!--/Row-->
            </div>
            <div class="col-md-6">
              <strong style="color:red">II. Reclamado</strong><div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="tiporeclamado">Tipo de Reclamado</label>
                    <select name="tiporeclamado" id="tiporeclamado" class="form-control select2 input-sm" required>
                      <option value=""> --Selecione-- </option>
                      <option <?php if(isset($conflito) && $conflito->tiporeclamado=='Singular'): ?> selected <?php endif; ?>>Pessoa Singular</option>
                      <option <?php if(isset($conflito) && $conflito->tiporeclamado=='Pessoa Colectiva'): ?> selected <?php endif; ?>>Pessoa Colectiva</option>
                    </select>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="generoreclamante">Género</label>
                    <select name="generoreclamado" id="generoreclamado" class="form-control select2 input-sm">
                      <option value=""> --Selecione-- </option>
                      <option <?php if(isset($conflito) && $conflito->generoreclamado=='Masculino'): ?> selected <?php endif; ?>>Masculino</option>
                      <option <?php if(isset($conflito) && $conflito->generoreclamado=='Feminino'): ?> selected <?php endif; ?>>Feminino</option>
                    </select>
                  </div>
                </div>
              </div>
              <!--/Row-->
              <div class="form-group">
                <label for="nomereclamado">Nome Completo</label>
                <input class="form-control input-sm" type="text" name="nomereclamado" value="<?php echo e($conflito->nomereclamado ?? null); ?>">
              </div>
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="contactoreclamado">Contacto</label>
                    <input class="form-control input-sm" type="text" name="contactoreclamado" value="<?php echo e($conflito->contactoreclamado ?? null); ?>">
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="outroreclamado">Outros</label>
                    <input class="form-control input-sm" type="text" name="outroreclamado" value="<?php echo e($conflito->outroreclamado ?? null); ?>">
                  </div>
                </div>
              </div>
              <!--/Row-->
            </div>
          </div>
          <!--/Row-->
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          <div class="col-md-6">
            <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Gravar</button>
          </div>
        </div>
      </form>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('adminlte_js'); ?>

<script type="text/javascript">
  function carregarDistritos(){
    var provincia = $('#idprovincia').val();
    var url = "<?php echo e(route('getDistritos', '_provincia_')); ?>".replace('_provincia_', provincia);

    $.getJSON(url, function (dados){ 
      //alert(dados);
       if (dados.length > 0){ 
        var option = '<option>Selecione o Distrito</option>';
        $.each(dados, function(i, obj){
          option += '<option value="'+obj.iddistrito+'">'+obj.distrito+'</option>';
        }) 
       }else{
      $('#iddistrito').empty().append('<option value="">Sem Distritos Definidos</option>');
       }
       $('#iddistrito').html(option).show(); 
    })
  }

  function carregarPostosAdm(){
    var postoadm = $('#iddistrito').val();
    var url = "<?php echo e(route('getPostoAdm', '_postoadm_')); ?>".replace('_postoadm_', postoadm);

    $.getJSON(url, function (dados){ 
      //alert(dados);
       if (dados.length > 0){ 
        var option = '<option>Selecione o Posto Administrativo</option>';
        $.each(dados, function(i, obj){
          option += '<option value="'+obj.idpostoadm+'">'+obj.postoadm+'</option>';
        }) 
       }else{
      $('#idpostoadm').empty().append('<option value="">Sem Postos Administrativos Definidos</option>');
       }
       $('#idpostoadm').html(option).show(); 
    })
  }
  //Carregar distritos
  $('#idprovincia').change(function(e){
      carregarDistritos();
    })

  //Carregar Postos administatitovs
  $('#iddistrito').change(function(e){
      carregarPostosAdm();
    })
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp73\htdocs\mrmct\resources\views/conflito/frmconflito.blade.php ENDPATH**/ ?>